# BeReferralPrescriptionRequestGroup - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeReferralPrescriptionRequestGroup**

## Resource Profile: BeReferralPrescriptionRequestGroup 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-request-group | *Version*:1.0.0 |
| Draft as of 2021-10-07 | *Computable Name*:BeReferralPrescriptionRequestGroup |

 
Envelope that allows different referralprescriptions to have an order 

**Usages:**

* Refer to this Profile: [BeReferralPrescriptionRequestGroup](StructureDefinition-be-referralprescription-request-group.md)
* Examples for this Profile: [RequestGroup/uc2a](RequestGroup-uc2a.md) and [RequestGroup/ucgh222p13](RequestGroup-ucgh222p13.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-referralprescription-request-group)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-referralprescription-request-group.csv), [Excel](StructureDefinition-be-referralprescription-request-group.xlsx), [Schematron](StructureDefinition-be-referralprescription-request-group.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-referralprescription-request-group",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-request-group",
  "version" : "1.0.0",
  "name" : "BeReferralPrescriptionRequestGroup",
  "status" : "draft",
  "date" : "2021-10-07T08:52:50+00:00",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    }
  ],
  "description" : "Envelope that allows different referralprescriptions to have an order",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RequestGroup",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/RequestGroup",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RequestGroup",
        "path" : "RequestGroup"
      },
      {
        "id" : "RequestGroup.identifier",
        "path" : "RequestGroup.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "RequestGroup.identifier:UHMEP",
        "path" : "RequestGroup.identifier",
        "sliceName" : "UHMEP",
        "short" : "Reference ID of the UHMEP once available there",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "RequestGroup.identifier:UHMEP.system",
        "path" : "RequestGroup.identifier.system",
        "min" : 1,
        "fixedUri" : "https://www.ehealth.fgov.be/standards/fhir/referral/NamingSystem/uhmep"
      },
      {
        "id" : "RequestGroup.identifier:UHMEP.value",
        "path" : "RequestGroup.identifier.value",
        "min" : 1
      },
      {
        "id" : "RequestGroup.groupIdentifier",
        "path" : "RequestGroup.groupIdentifier",
        "mustSupport" : true
      },
      {
        "id" : "RequestGroup.action",
        "path" : "RequestGroup.action",
        "short" : "At least one referral prescription",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "RequestGroup.action.id",
        "path" : "RequestGroup.action.id",
        "mustSupport" : true
      },
      {
        "id" : "RequestGroup.action.relatedAction",
        "path" : "RequestGroup.action.relatedAction",
        "mustSupport" : true
      },
      {
        "id" : "RequestGroup.action.relatedAction.actionId",
        "path" : "RequestGroup.action.relatedAction.actionId",
        "mustSupport" : true
      },
      {
        "id" : "RequestGroup.action.relatedAction.relationship",
        "path" : "RequestGroup.action.relatedAction.relationship",
        "mustSupport" : true
      },
      {
        "id" : "RequestGroup.action.resource",
        "path" : "RequestGroup.action.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription",
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-request-group"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
