# BeReferralPrescriptionNursing - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeReferralPrescriptionNursing**

## Resource Profile: BeReferralPrescriptionNursing 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-nursing | *Version*:1.0.0 |
| Draft as of 2021-07-15 | *Computable Name*:BeReferralPrescriptionNursing |

 
The nursing profile, generic version. Please note the nursing referral for medication does NOT depend on this generic version but is a FHIR prodfile on a different FHIR resource (MedicationRequest) 

**Usages:**

* Examples for this Profile: [ServiceRequest/example01-care02-colon-cleansing](ServiceRequest-example01-care02-colon-cleansing.md), [ServiceRequest/example02-referralprescription-nursing-digestive-system-care](ServiceRequest-example02-referralprescription-nursing-digestive-system-care.md), [ServiceRequest/example03-referralprescription-nursing-compressiontherapy](ServiceRequest-example03-referralprescription-nursing-compressiontherapy.md), [ServiceRequest/example04-referralprescription-nursing-bladder-care](ServiceRequest-example04-referralprescription-nursing-bladder-care.md)...Show 29 more,[ServiceRequest/example05-referralprescription-nursing-digestive-system-care](ServiceRequest-example05-referralprescription-nursing-digestive-system-care.md),[ServiceRequest/example06-referralprescription-nursing-compression-therapy](ServiceRequest-example06-referralprescription-nursing-compression-therapy.md),[ServiceRequest/example09-referralprescription-nursing-woundcare](ServiceRequest-example09-referralprescription-nursing-woundcare.md),[ServiceRequest/example12-referralprescription-nursing-annex81](ServiceRequest-example12-referralprescription-nursing-annex81.md),[ServiceRequest/example16-referralprescription-nursing-bladder-care](ServiceRequest-example16-referralprescription-nursing-bladder-care.md),[ServiceRequest/example24-referralprescription-nursing-non-reimbursable](ServiceRequest-example24-referralprescription-nursing-non-reimbursable.md),[ServiceRequest/example26-referralprescription-nursing-other](ServiceRequest-example26-referralprescription-nursing-other.md),[ServiceRequest/example32-referralprescription-nursing-chronical-psychiatric](ServiceRequest-example32-referralprescription-nursing-chronical-psychiatric.md),[ServiceRequest/referralprescription-nursing-example2-digestive-system-care](ServiceRequest-referralprescription-nursing-example2-digestive-system-care.md),[ServiceRequest/referralprescription-nursing-example3-compression-therapy](ServiceRequest-referralprescription-nursing-example3-compression-therapy.md),[ServiceRequest/referralprescription-nursing-example5-digestive-system-care](ServiceRequest-referralprescription-nursing-example5-digestive-system-care.md),[ServiceRequest/referralprescription-nursing-example6-compression-therapy](ServiceRequest-referralprescription-nursing-example6-compression-therapy.md),[ServiceRequest/uc2a-1](ServiceRequest-uc2a-1.md),[ServiceRequest/uc2a-2](ServiceRequest-uc2a-2.md),[ServiceRequest/uc2a-3](ServiceRequest-uc2a-3.md),[ServiceRequest/uc5a-1](ServiceRequest-uc5a-1.md),[ServiceRequest/ucgh211-1](ServiceRequest-ucgh211-1.md),[ServiceRequest/ucgh222p12-1](ServiceRequest-ucgh222p12-1.md),[ServiceRequest/ucgh222p12-2](ServiceRequest-ucgh222p12-2.md),[ServiceRequest/ucgh222p12-3](ServiceRequest-ucgh222p12-3.md),[ServiceRequest/ucgh222p13-1](ServiceRequest-ucgh222p13-1.md),[ServiceRequest/ucgh222p13-2](ServiceRequest-ucgh222p13-2.md),[ServiceRequest/ucgh241p110-1](ServiceRequest-ucgh241p110-1.md),[ServiceRequest/ucgh241p111-1](ServiceRequest-ucgh241p111-1.md),[ServiceRequest/ucgh241p15-1](ServiceRequest-ucgh241p15-1.md),[ServiceRequest/ucgh241p16-1](ServiceRequest-ucgh241p16-1.md),[ServiceRequest/ucgh241p17-1](ServiceRequest-ucgh241p17-1.md),[ServiceRequest/ucgh241p18-1](ServiceRequest-ucgh241p18-1.md)and[ServiceRequest/ucgh241p19-1](ServiceRequest-ucgh241p19-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-referralprescription-nursing)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-referralprescription-nursing.csv), [Excel](StructureDefinition-be-referralprescription-nursing.xlsx), [Schematron](StructureDefinition-be-referralprescription-nursing.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-referralprescription-nursing",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-nursing",
  "version" : "1.0.0",
  "name" : "BeReferralPrescriptionNursing",
  "status" : "draft",
  "date" : "2021-07-15T08:52:50+00:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "The nursing profile, generic version. Please note the nursing referral for medication does NOT depend on this generic version but is a FHIR prodfile on a different FHIR resource (MedicationRequest)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ServiceRequest",
  "baseDefinition" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ServiceRequest",
        "path" : "ServiceRequest"
      },
      {
        "id" : "ServiceRequest.category.coding.system",
        "path" : "ServiceRequest.category.coding.system",
        "fixedUri" : "http://snomed.info/sct"
      },
      {
        "id" : "ServiceRequest.category.coding.code",
        "path" : "ServiceRequest.category.coding.code",
        "fixedCode" : "9632001"
      },
      {
        "id" : "ServiceRequest.code",
        "path" : "ServiceRequest.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-requested-services-nurse"
        }
      },
      {
        "id" : "ServiceRequest.orderDetail",
        "path" : "ServiceRequest.orderDetail",
        "short" : "Details of the nursing activity",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-requested-services-nurse-detail"
        }
      },
      {
        "id" : "ServiceRequest.asNeeded[x]",
        "path" : "ServiceRequest.asNeeded[x]",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.bodySite",
        "path" : "ServiceRequest.bodySite",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-bodysite-nursing"
        }
      }
    ]
  }
}

```
