# BeReferralPrescriptionDiagnosticImaging - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeReferralPrescriptionDiagnosticImaging**

## Resource Profile: BeReferralPrescriptionDiagnosticImaging 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-diagnosticimaging | *Version*:1.0.0 |
| Draft as of 2021-07-15 | *Computable Name*:BeReferralPrescriptionDiagnosticImaging |

 
Referral prescription for a generic diagnostic imaging. Please note in .orderDetail, a specific slicing is available to give guidance how to express acquisition modalities if needed. In future iterations of this profile, more slicing might provide additional guidance. 

**Usages:**

* Examples for this Profile: [ServiceRequest/diagnostic-imaging-basic-example-concreteWithDetails](ServiceRequest-diagnostic-imaging-basic-example-concreteWithDetails.md), [ServiceRequest/diagnostic-imaging-basic-example-concreteWithText](ServiceRequest-diagnostic-imaging-basic-example-concreteWithText.md), [ServiceRequest/diagnostic-imaging-basic-example-everything-contained](ServiceRequest-diagnostic-imaging-basic-example-everything-contained.md) and [ServiceRequest/diagnostic-imaging-basic-example-useOfModality](ServiceRequest-diagnostic-imaging-basic-example-useOfModality.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-referralprescription-diagnosticimaging)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-referralprescription-diagnosticimaging.csv), [Excel](StructureDefinition-be-referralprescription-diagnosticimaging.xlsx), [Schematron](StructureDefinition-be-referralprescription-diagnosticimaging.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-referralprescription-diagnosticimaging",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-diagnosticimaging",
  "version" : "1.0.0",
  "name" : "BeReferralPrescriptionDiagnosticImaging",
  "status" : "draft",
  "date" : "2021-07-15T08:52:50+00:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Referral prescription for a generic diagnostic imaging.\nPlease note in .orderDetail, a specific slicing is available to give guidance how to express acquisition modalities if needed. In future iterations of this profile, more slicing might provide additional guidance.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ServiceRequest",
  "baseDefinition" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ServiceRequest",
        "path" : "ServiceRequest"
      },
      {
        "id" : "ServiceRequest.extension:relevantSupportingInformationAsAnnotationOrCodeableConcept",
        "path" : "ServiceRequest.extension",
        "sliceName" : "relevantSupportingInformationAsAnnotationOrCodeableConcept",
        "short" : "Relevant clinical information in the context of this prescription concerning for example allergies, kidney function, diabetic. This extension allows the use of a codeableConcept or Annotation but when more detailed information can be given, it is RECOMMENDED to express it as structured as possible using the appropriate elements (for general relevant supporting information, this means the use of the .supportingInfo element.) ContraIndications SHALL be expressed using the contraIndication modifierExtension.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-supporting-info"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.modifierExtension",
        "path" : "ServiceRequest.modifierExtension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ServiceRequest.modifierExtension:contraIndication",
        "path" : "ServiceRequest.modifierExtension",
        "sliceName" : "contraIndication",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-contraindication"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.modifierExtension:contrastFluidUse",
        "path" : "ServiceRequest.modifierExtension",
        "sliceName" : "contrastFluidUse",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-contrastfluiduse"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.category.coding.system",
        "path" : "ServiceRequest.category.coding.system",
        "fixedUri" : "http://snomed.info/sct"
      },
      {
        "id" : "ServiceRequest.category.coding.code",
        "path" : "ServiceRequest.category.coding.code",
        "fixedCode" : "363679005"
      },
      {
        "id" : "ServiceRequest.orderDetail",
        "path" : "ServiceRequest.orderDetail",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding.system"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "ServiceRequest.orderDetail:modality",
        "path" : "ServiceRequest.orderDetail",
        "sliceName" : "modality",
        "short" : "Acquisition modalities, i.e. those in the DICOM Context Group 29",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.orderDetail:modality.coding",
        "path" : "ServiceRequest.orderDetail.coding",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ImagingModality"
            }
          ],
          "strength" : "required",
          "description" : "Type of acquired data in the instance.",
          "valueSet" : "http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_29.html"
        }
      },
      {
        "id" : "ServiceRequest.orderDetail:modality.coding.system",
        "path" : "ServiceRequest.orderDetail.coding.system",
        "min" : 1,
        "fixedUri" : "http://dicom.nema.org/resources/ontology/DCM"
      },
      {
        "id" : "ServiceRequest.orderDetail:modality.coding.code",
        "path" : "ServiceRequest.orderDetail.coding.code",
        "min" : 1
      },
      {
        "id" : "ServiceRequest.reasonCode",
        "path" : "ServiceRequest.reasonCode",
        "short" : "Diagnostic question, explanation/Justification for procedure or service"
      },
      {
        "id" : "ServiceRequest.supportingInfo",
        "path" : "ServiceRequest.supportingInfo",
        "short" : "Relevant information in the context of this prescription concerning for example allergies, kidney function, diabetic. When detailed information can be given, it is RECOMMENDED to express it as structured as possible. ContraIndications SHALL be expressed using the contraIndication modifierExtension",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Resource",
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "https://www.ehealth.fgov.be/standards/fhir/core-clinical/StructureDefinition/be-observation",
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "https://www.ehealth.fgov.be/standards/fhir/allergy/StructureDefinition/be-allergyintolerance",
              "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
            ]
          }
        ]
      }
    ]
  }
}

```
