# BeUrgentCommunication - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeUrgentCommunication**

## Extension: BeUrgentCommunication 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-urgent-communication | *Version*:1.0.0 |
| Draft as of 2021-07-15 | *Computable Name*:BeUrgentCommunication |

When there is a need to urgently communicate results of an order.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [BeLabPrescription](StructureDefinition-be-lab-prescription.md)
* Examples for this Extension: [ServiceRequest/laboratory-order-example1](ServiceRequest-laboratory-order-example1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-ext-urgent-communication)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-ext-urgent-communication.csv), [Excel](StructureDefinition-be-ext-urgent-communication.xlsx), [Schematron](StructureDefinition-be-ext-urgent-communication.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-ext-urgent-communication",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-urgent-communication",
  "version" : "1.0.0",
  "name" : "BeUrgentCommunication",
  "title" : "BeUrgentCommunication",
  "status" : "draft",
  "date" : "2021-07-15T08:52:50+00:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "When there is a need to urgently communicate results of an order.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ServiceRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Urgent communication is needed"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 1
      },
      {
        "id" : "Extension.extension:party",
        "path" : "Extension.extension",
        "sliceName" : "party",
        "short" : "party to inform",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:party.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:party.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "party"
      },
      {
        "id" : "Extension.extension:party.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitioner",
              "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-organization",
              "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-patient"
            ]
          }
        ]
      },
      {
        "id" : "Extension.extension:instructions",
        "path" : "Extension.extension",
        "sliceName" : "instructions",
        "short" : "For example 'Try phone first but also send SMS and e-mail'",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:instructions.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:instructions.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "instructions"
      },
      {
        "id" : "Extension.extension:instructions.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:contactway",
        "path" : "Extension.extension",
        "sliceName" : "contactway",
        "short" : "Will override any other known channel for partner for urgent communication",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:contactway.extension",
        "path" : "Extension.extension.extension",
        "min" : 2
      },
      {
        "id" : "Extension.extension:contactway.extension:contactSystem",
        "path" : "Extension.extension.extension",
        "sliceName" : "contactSystem",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:contactway.extension:contactSystem.extension",
        "path" : "Extension.extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:contactway.extension:contactSystem.url",
        "path" : "Extension.extension.extension.url",
        "fixedUri" : "contactSystem"
      },
      {
        "id" : "Extension.extension:contactway.extension:contactSystem.value[x]",
        "path" : "Extension.extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-communication-method"
        }
      },
      {
        "id" : "Extension.extension:contactway.extension:contactSystemValue",
        "path" : "Extension.extension.extension",
        "sliceName" : "contactSystemValue",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:contactway.extension:contactSystemValue.extension",
        "path" : "Extension.extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:contactway.extension:contactSystemValue.url",
        "path" : "Extension.extension.extension.url",
        "fixedUri" : "contactSystemValue"
      },
      {
        "id" : "Extension.extension:contactway.extension:contactSystemValue.value[x]",
        "path" : "Extension.extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:contactway.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "contactway"
      },
      {
        "id" : "Extension.extension:contactway.value[x]",
        "path" : "Extension.extension.value[x]",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-urgent-communication"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
