# BeSupportingInfo - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeSupportingInfo**

## Extension: BeSupportingInfo 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-supporting-info | *Version*:1.0.0 |
| Draft as of 2021-07-15 | *Computable Name*:BeSupportingInfo |

Relevant clinical information in the context of this prescription concerning for example allergies, kidney function, diabetic. This extension allows the use of an Annotation or codeableConcept but when more detailed information can be given, it is RECOMMENDED to express it as structured as possible using the appropriate elements.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [BeReferralPrescriptionDiagnosticImaging](StructureDefinition-be-referralprescription-diagnosticimaging.md)
* Examples for this Extension: [ServiceRequest/diagnostic-imaging-basic-example-concreteWithText](ServiceRequest-diagnostic-imaging-basic-example-concreteWithText.md) and [ServiceRequest/diagnostic-imaging-basic-example-everything-contained](ServiceRequest-diagnostic-imaging-basic-example-everything-contained.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-ext-supporting-info)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-ext-supporting-info.csv), [Excel](StructureDefinition-be-ext-supporting-info.xlsx), [Schematron](StructureDefinition-be-ext-supporting-info.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-ext-supporting-info",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-supporting-info",
  "version" : "1.0.0",
  "name" : "BeSupportingInfo",
  "title" : "BeSupportingInfo",
  "status" : "draft",
  "date" : "2021-07-15T08:52:50+00:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Relevant clinical information in the context of this prescription concerning for example allergies, kidney function, diabetic. This extension allows the use of an Annotation or codeableConcept but when more detailed information can be given, it is RECOMMENDED to express it as structured as possible using the appropriate elements.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ServiceRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Supporting Information"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-supporting-info"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Annotation"
          },
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
