# BePSSInfo - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BePSSInfo**

## Extension: BePSSInfo 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-pss-info | *Version*:1.0.0 |
| Draft as of 2022-05-03 | *Computable Name*:BePSSInfo |

Information regarding the Prescription Search Support

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [BeReferralPrescription](StructureDefinition-be-referralprescription.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-ext-pss-info)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-ext-pss-info.csv), [Excel](StructureDefinition-be-ext-pss-info.xlsx), [Schematron](StructureDefinition-be-ext-pss-info.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-ext-pss-info",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-pss-info",
  "version" : "1.0.0",
  "name" : "BePSSInfo",
  "title" : "BePSSInfo",
  "status" : "draft",
  "date" : "2022-05-03T10:04:16+02:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Information regarding the Prescription Search Support",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ServiceRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "BePSSInfo",
        "definition" : "Prescription Search Support Info"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 1
      },
      {
        "id" : "Extension.extension:guidanceResponse",
        "path" : "Extension.extension",
        "sliceName" : "guidanceResponse",
        "short" : "Reference to the GuidanceResponse from the PSS",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:guidanceResponse.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:guidanceResponse.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "guidanceResponse"
      },
      {
        "id" : "Extension.extension:guidanceResponse.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/GuidanceResponse"]
          }
        ]
      },
      {
        "id" : "Extension.extension:rejectionReason",
        "path" : "Extension.extension",
        "sliceName" : "rejectionReason",
        "short" : "reason for not following the PSS",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:rejectionReason.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:rejectionReason.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "rejectionReason"
      },
      {
        "id" : "Extension.extension:rejectionReason.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "Annotation"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-pss-info"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
