# BeContrastFluidUse - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeContrastFluidUse**

## Extension: BeContrastFluidUse 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-contrastfluiduse | *Version*:1.0.0 |
| Draft as of 2021-07-15 | *Computable Name*:BeContrastFluidUse |

Whether the use of contrast fluid in diagnostic imaging can be defined as ‘If necessary’ or ‘Not permitted.’

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [BeReferralPrescriptionDiagnosticImaging](StructureDefinition-be-referralprescription-diagnosticimaging.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-ext-contrastfluiduse)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-ext-contrastfluiduse.csv), [Excel](StructureDefinition-be-ext-contrastfluiduse.xlsx), [Schematron](StructureDefinition-be-ext-contrastfluiduse.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-ext-contrastfluiduse",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-contrastfluiduse",
  "version" : "1.0.0",
  "name" : "BeContrastFluidUse",
  "title" : "BeContrastFluidUse",
  "status" : "draft",
  "date" : "2021-07-15T08:52:50+00:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Whether the use of contrast fluid in diagnostic imaging can be defined as 'If necessary' or 'Not permitted.'",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ServiceRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Whether the use of contrast fluid in diagnostic imaging can be defined as 'If necessary' or 'Not permitted.'",
        "isModifier" : true,
        "isModifierReason" : "Possible not permitted use of contrast fluid."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-contrastfluiduse"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-contrastfluid-use"
        }
      }
    ]
  }
}

```
