# BeCoPrescriber - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeCoPrescriber**

## Extension: BeCoPrescriber 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber | *Version*:1.0.0 |
| Draft as of 2022-05-03 | *Computable Name*:BeCoPrescriber |

Other practitioners that must take part in this prescripiton

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [BeCoPrescriberInfo](StructureDefinition-be-co-prescriber-info.md)
* Examples for this Extension: [ServiceRequest/ucgh211-1](ServiceRequest-ucgh211-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-co-prescriber)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-co-prescriber.csv), [Excel](StructureDefinition-be-co-prescriber.xlsx), [Schematron](StructureDefinition-be-co-prescriber.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-co-prescriber",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber",
  "version" : "1.0.0",
  "name" : "BeCoPrescriber",
  "title" : "BeCoPrescriber",
  "status" : "draft",
  "date" : "2022-05-03T10:04:16+02:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Other practitioners that must take part in this prescripiton",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Extension"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "BeCoPrescriber",
        "definition" : "Other practitioners that must take part in this prescripiton"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 3
      },
      {
        "id" : "Extension.extension:coprescriber",
        "path" : "Extension.extension",
        "sliceName" : "coprescriber",
        "short" : "Reference to practitionerrole",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:coprescriber.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:coprescriber.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "coprescriber"
      },
      {
        "id" : "Extension.extension:coprescriber.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
            ]
          }
        ]
      },
      {
        "id" : "Extension.extension:coprescriptionStatus",
        "path" : "Extension.extension",
        "sliceName" : "coprescriptionStatus",
        "short" : "Status of coprescription",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:coprescriptionStatus.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:coprescriptionStatus.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "coprescriptionStatus"
      },
      {
        "id" : "Extension.extension:coprescriptionStatus.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-co-prescription-status"
        }
      },
      {
        "id" : "Extension.extension:required",
        "path" : "Extension.extension",
        "sliceName" : "required",
        "short" : "Importance of the signature for the prescription",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:required.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:required.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "required"
      },
      {
        "id" : "Extension.extension:required.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-co-prescriber-choice"
        }
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
