# BeCoPrescriberInfo - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeCoPrescriberInfo**

## Extension: BeCoPrescriberInfo 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber-info | *Version*:1.0.0 |
| Draft as of 2022-05-03 | *Computable Name*:BeCoPrescriberInfo |

Info about the other practitioners that must take part in this prescripiton

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [BeReferralPrescription](StructureDefinition-be-referralprescription.md)
* Examples for this Extension: [ServiceRequest/ucgh211-1](ServiceRequest-ucgh211-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-co-prescriber-info)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-co-prescriber-info.csv), [Excel](StructureDefinition-be-co-prescriber-info.xlsx), [Schematron](StructureDefinition-be-co-prescriber-info.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-co-prescriber-info",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber-info",
  "version" : "1.0.0",
  "name" : "BeCoPrescriberInfo",
  "title" : "BeCoPrescriberInfo",
  "status" : "draft",
  "date" : "2022-05-03T10:04:16+02:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Info about the other practitioners that must take part in this prescripiton",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ServiceRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "BeCoPrescriber",
        "definition" : "Other practitioners that must take part in this prescripiton"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 1
      },
      {
        "id" : "Extension.extension:coprescriber",
        "path" : "Extension.extension",
        "sliceName" : "coprescriber",
        "short" : "List of other coprescribers",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:coprescriberNumber",
        "path" : "Extension.extension",
        "sliceName" : "coprescriberNumber",
        "short" : "Number of mandatory coprescriber signatures required",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:coprescriberNumber.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:coprescriberNumber.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "coprescriberNumber"
      },
      {
        "id" : "Extension.extension:coprescriberNumber.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber-info"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
