# BePhysiotherapyPrescription - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BePhysiotherapyPrescription**

## Logical Model: BePhysiotherapyPrescription 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BePhysiotherapyPrescription | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BePhysiotherapyPrescription |

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/BePhysiotherapyPrescription)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BePhysiotherapyPrescription.csv), [Excel](StructureDefinition-BePhysiotherapyPrescription.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BePhysiotherapyPrescription",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BePhysiotherapyPrescription",
  "version" : "1.0.0",
  "name" : "BePhysiotherapyPrescription",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BePhysiotherapyPrescription",
  "baseDefinition" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelReferralPrescription",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "BePhysiotherapyPrescription",
        "path" : "BePhysiotherapyPrescription",
        "short" : "BePhysiotherapyPrescription",
        "definition" : "BePhysiotherapyPrescription"
      },
      {
        "id" : "BePhysiotherapyPrescription.numberOfSessions",
        "path" : "BePhysiotherapyPrescription.numberOfSessions",
        "short" : "Number of pt sessions that are prescribed",
        "definition" : "Number of pt sessions that are prescribed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      }
    ]
  }
}

```
