# BeModelReferralRequestGroup - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeModelReferralRequestGroup**

## Logical Model: BeModelReferralRequestGroup 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelReferralRequestGroup | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BeModelReferralRequestGroup |

 
Logical model describing the model for a group of referral prescriptions. This draft is used in the HL7 Belgian workgroup for referral. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/BeModelReferralRequestGroup)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BeModelReferralRequestGroup.csv), [Excel](StructureDefinition-BeModelReferralRequestGroup.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BeModelReferralRequestGroup",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelReferralRequestGroup",
  "version" : "1.0.0",
  "name" : "BeModelReferralRequestGroup",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "Logical model describing the model for a group of referral prescriptions. This draft is used in the HL7 Belgian workgroup for referral.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelReferralRequestGroup",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "BeModelReferralRequestGroup",
        "path" : "BeModelReferralRequestGroup",
        "short" : "BeModelReferralRequestGroup",
        "definition" : "Logical model describing the model for a group of referral prescriptions. This draft is used in the HL7 Belgian workgroup for referral."
      },
      {
        "id" : "BeModelReferralRequestGroup.identifier",
        "path" : "BeModelReferralRequestGroup.identifier",
        "short" : "The business identifier of the request group",
        "definition" : "The business identifier of the request group",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "BeModelReferralRequestGroup.groupIdentifier",
        "path" : "BeModelReferralRequestGroup.groupIdentifier",
        "short" : "If the group belongs to another group, the identifier of this group",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "BeModelReferralRequestGroup.action",
        "path" : "BeModelReferralRequestGroup.action",
        "short" : "The actions (prescriptions) that belong together in the referral request-group",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BeModelReferralRequestGroup.action.identifier",
        "path" : "BeModelReferralRequestGroup.action.identifier",
        "short" : "id for local reference",
        "definition" : "id for local reference",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "BeModelReferralRequestGroup.action.relatedAction",
        "path" : "BeModelReferralRequestGroup.action.relatedAction",
        "short" : "The actions (prescriptions) that are related to the current action",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BeModelReferralRequestGroup.action.relatedAction.actionId",
        "path" : "BeModelReferralRequestGroup.action.relatedAction.actionId",
        "short" : "The actionId of the action the action is related to",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "BeModelReferralRequestGroup.action.relatedAction.relationShip",
        "path" : "BeModelReferralRequestGroup.action.relatedAction.relationShip",
        "short" : "The description of the relationship between both actions (before, after, concurrent)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      }
    ]
  }
}

```
