# BeModelReferralPrescription - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeModelReferralPrescription**

## Logical Model: BeModelReferralPrescription 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelReferralPrescription | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BeModelReferralPrescription |

 
Logical model describing the model for the prescription referral. This draft is used in the HL7 Belgian workgroup for referral. 

**Usages:**

* Derived from this Logical Model: [BeDiagnosticImagingPrescription](StructureDefinition-BeDiagnosticImagingPrescription.md), [BeLaboratoryPrescription](StructureDefinition-BeLaboratoryPrescription.md), [BeModelNursingPrescription](StructureDefinition-BeModelNursingPrescription.md) and [BePhysiotherapyPrescription](StructureDefinition-BePhysiotherapyPrescription.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/BeModelReferralPrescription)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BeModelReferralPrescription.csv), [Excel](StructureDefinition-BeModelReferralPrescription.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BeModelReferralPrescription",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelReferralPrescription",
  "version" : "1.0.0",
  "name" : "BeModelReferralPrescription",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "Logical model describing the model for the prescription referral. This draft is used in the HL7 Belgian workgroup for referral.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelReferralPrescription",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "BeModelReferralPrescription",
        "path" : "BeModelReferralPrescription",
        "short" : "BeModelReferralPrescription",
        "definition" : "Logical model describing the model for the prescription referral. This draft is used in the HL7 Belgian workgroup for referral."
      },
      {
        "id" : "BeModelReferralPrescription.recordedDate",
        "path" : "BeModelReferralPrescription.recordedDate",
        "short" : "When this prescription was created",
        "definition" : "When this prescription was created",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.recorder",
        "path" : "BeModelReferralPrescription.recorder",
        "short" : "The person who is responsable for the content, not necessarily the person who entered the content. This is either the prescriber, a co-prescriber or a performer. It is the last person who updated the resources.",
        "definition" : "The person who is responsable for the content, not necessarily the person who entered the content. This is either the prescriber, a co-prescriber or a performer. It is the last person who updated the resources.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.prescriber",
        "path" : "BeModelReferralPrescription.prescriber",
        "short" : "The prescribing healthcare party",
        "definition" : "The prescribing healthcare party",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.coprescriberNumber",
        "path" : "BeModelReferralPrescription.coprescriberNumber",
        "short" : "Number of co-prescribers that must sign the prescription to activate it",
        "definition" : "Number of co-prescribers that must sign the prescription to activate it",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.coprescriber",
        "path" : "BeModelReferralPrescription.coprescriber",
        "short" : "Information about co prescribers",
        "definition" : "Information about co prescribers",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.coprescriber.coprescriber",
        "path" : "BeModelReferralPrescription.coprescriber.coprescriber",
        "short" : "The co-prescriber party",
        "definition" : "The co-prescriber party",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.coprescriber.coprescriberType",
        "path" : "BeModelReferralPrescription.coprescriber.coprescriberType",
        "short" : "Type of the practitioner",
        "definition" : "Type of the practitioner",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.coprescriber.status",
        "path" : "BeModelReferralPrescription.coprescriber.status",
        "short" : "Status of co prescribing status (to sign, signed or refused)",
        "definition" : "Status of co prescribing status (to sign, signed or refused)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.coprescriber.required",
        "path" : "BeModelReferralPrescription.coprescriber.required",
        "short" : "Type of mandatory for the signature of the co-prescriber (1= required: the co-prescriber SHALL sign to make the prescription valid, 2= conditionally required: the co-prescriber SHALL sign if the number of co-prescribers with a signature is lower than the number in co-prescriber number 3= optional: the signature does not affect the validity of the prescription, but is for information only",
        "definition" : "Type of mandatory for the signature of the co-prescriber (1= required: the co-prescriber SHALL sign to make the prescription valid, 2= conditionally required: the co-prescriber SHALL sign if the number of co-prescribers with a signature is lower than the number in co-prescriber number 3= optional: the signature does not affect the validity of the prescription, but is for information only",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.patient",
        "path" : "BeModelReferralPrescription.patient",
        "short" : "The SSIN of the person for which the referral is prescribed.",
        "definition" : "The SSIN of the person for which the referral is prescribed.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.prescriptionNumber",
        "path" : "BeModelReferralPrescription.prescriptionNumber",
        "short" : "An identifier for the ReferralPrescription, e.g. the UHMEP identifier, once available",
        "definition" : "An identifier for the ReferralPrescription, e.g. the UHMEP identifier, once available",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.pssNumber",
        "path" : "BeModelReferralPrescription.pssNumber",
        "short" : "An identifier for the Prescription Search Support",
        "definition" : "An identifier for the Prescription Search Support",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.pssRejectionReason",
        "path" : "BeModelReferralPrescription.pssRejectionReason",
        "short" : "Reason for not following the PSS suggestion",
        "definition" : "Reason for not following the PSS suggestion",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Annotation"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.groupIdentifier",
        "path" : "BeModelReferralPrescription.groupIdentifier",
        "short" : "An identifier for the bundle this prescription belongs to.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.basedOn",
        "path" : "BeModelReferralPrescription.basedOn",
        "short" : "The original request or prescription triggered this prescription",
        "definition" : "The original request or prescription that is the reason for this request - for example when a detailed request is created by a broader request.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.validityPeriod",
        "path" : "BeModelReferralPrescription.validityPeriod",
        "short" : "Period of validity of prescription",
        "definition" : "Period of validity of prescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.treatmentPeriod",
        "path" : "BeModelReferralPrescription.treatmentPeriod",
        "short" : "When this prescription is executed, available after start of execution",
        "definition" : "When this prescription is executed, available after start of execution",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.treatmentValidationEndDate",
        "path" : "BeModelReferralPrescription.treatmentValidationEndDate",
        "short" : "The latest moment to end this treatment",
        "definition" : "The latest moment to end this treatment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.creationEndDate",
        "path" : "BeModelReferralPrescription.creationEndDate",
        "short" : "The prescription must have left the draft status before",
        "definition" : "The prescription must have left the draft status before",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.intendedPerformer",
        "path" : "BeModelReferralPrescription.intendedPerformer",
        "short" : "The intended provider, i.e. who is expected to perform the procedure - a specific person or a speciality",
        "definition" : "The intended provider, i.e. who is expected to perform the procedure - a specific person or a speciality",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.intendedPerformer.performer",
        "path" : "BeModelReferralPrescription.intendedPerformer.performer",
        "short" : "A reference to the provider party (e.g. a NIHDI number for a healthcare professional, a SSIN or only a displaystring for a non professional caregiver,...)",
        "definition" : "A reference to the provider party (e.g. a NIHDI number for a healthcare professional, a SSIN or only a displaystring for a non professional caregiver,...)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.intendedPerformer.discipline",
        "path" : "BeModelReferralPrescription.intendedPerformer.discipline",
        "short" : "The required discipline of the provider party",
        "definition" : "The required discipline of the provider party",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.intendedPerformer.period",
        "path" : "BeModelReferralPrescription.intendedPerformer.period",
        "short" : "Start and enddate for the particular provider",
        "definition" : "Start and enddate for the particular provider",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.intendedPerformer.organization",
        "path" : "BeModelReferralPrescription.intendedPerformer.organization",
        "short" : "Reference to an organization that will add the performer",
        "definition" : "Reference to an organization that will add the performer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.intendedPerformer.executionPeriod",
        "path" : "BeModelReferralPrescription.intendedPerformer.executionPeriod",
        "short" : "Period in which the caregiver executes the treatment",
        "definition" : "Period in which the caregiver executes the treatment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.intendedPerformer.status",
        "path" : "BeModelReferralPrescription.intendedPerformer.status",
        "short" : "Status of the action executed by the performer",
        "definition" : "Status of the action executed by the performer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.intendedPerformer.statusReason",
        "path" : "BeModelReferralPrescription.intendedPerformer.statusReason",
        "short" : "The reason of the status of the action executed by the performer",
        "definition" : "The reason of the status of the action executed by the performer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.serviceRequested",
        "path" : "BeModelReferralPrescription.serviceRequested",
        "short" : "What is prescribed",
        "definition" : "What is prescribed",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.serviceRequestedDetail",
        "path" : "BeModelReferralPrescription.serviceRequestedDetail",
        "short" : "More detailed specification of the prescribed act",
        "definition" : "More detailed specification of the prescribed act",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.problemCode",
        "path" : "BeModelReferralPrescription.problemCode",
        "short" : "The problem (code or reference) that is the main reason for this prescription",
        "definition" : "The problem (code or reference) that is the main reason for this prescription",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.anamnesis",
        "path" : "BeModelReferralPrescription.anamnesis",
        "short" : "Care Set Problem",
        "definition" : "Care Set Problem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.resultReceiver",
        "path" : "BeModelReferralPrescription.resultReceiver",
        "short" : "True if the prescriber wants feedback. Other caregivers can be mentioned in the note",
        "definition" : "True if the prescriber wants feedback. Other caregivers can be mentioned in the note",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.prescriptionStatus",
        "path" : "BeModelReferralPrescription.prescriptionStatus",
        "short" : "Current status",
        "definition" : "Current status",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/request-status"
        }
      },
      {
        "id" : "BeModelReferralPrescription.prescriptionStatusReason",
        "path" : "BeModelReferralPrescription.prescriptionStatusReason",
        "short" : "Reason current status",
        "definition" : "Reason current status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.treatmentStatus",
        "path" : "BeModelReferralPrescription.treatmentStatus",
        "short" : "Status of the treatment",
        "definition" : "Status of the treatment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.treatmentStatusReason",
        "path" : "BeModelReferralPrescription.treatmentStatusReason",
        "short" : "Reason treatment status",
        "definition" : "Reason treatment status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.bodyLocation",
        "path" : "BeModelReferralPrescription.bodyLocation",
        "short" : "Place where the treatment should be executed",
        "definition" : "Place where the treatment should be executed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.bodyLocation.bodySite",
        "path" : "BeModelReferralPrescription.bodyLocation.bodySite",
        "short" : "Anatomical place where the treatment should be executed",
        "definition" : "Anatomical place where the treatment should be executed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.bodyLocation.bodyLaterality",
        "path" : "BeModelReferralPrescription.bodyLocation.bodyLaterality",
        "short" : "Side of the body",
        "definition" : "Side of the body",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.note",
        "path" : "BeModelReferralPrescription.note",
        "short" : "Additional text notes about the request.",
        "definition" : "Additional text notes about the request.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.note.type",
        "path" : "BeModelReferralPrescription.note.type",
        "short" : "type of the note",
        "definition" : "type of the note",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.note.text",
        "path" : "BeModelReferralPrescription.note.text",
        "short" : "text of the note",
        "definition" : "text of the note",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "BeModelReferralPrescription.prescriptionType",
        "path" : "BeModelReferralPrescription.prescriptionType",
        "short" : "Proposal, Prolongation, Prescription",
        "definition" : "Proposal, Prolongation, Prescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      }
    ]
  }
}

```
