# BeLaboratoryPrescription - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeLaboratoryPrescription**

## Logical Model: BeLaboratoryPrescription 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeLaboratoryPrescription | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BeLaboratoryPrescription |

 
Logical model describing the model for the prescription laboratory. This draft is used in the HL7 Belgian workgroup for laboratory. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/BeLaboratoryPrescription)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BeLaboratoryPrescription.csv), [Excel](StructureDefinition-BeLaboratoryPrescription.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BeLaboratoryPrescription",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeLaboratoryPrescription",
  "version" : "1.0.0",
  "name" : "BeLaboratoryPrescription",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "Logical model describing the model for the prescription laboratory. This draft is used in the HL7 Belgian workgroup for laboratory.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeLaboratoryPrescription",
  "baseDefinition" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelReferralPrescription",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "BeLaboratoryPrescription",
        "path" : "BeLaboratoryPrescription",
        "short" : "BeLaboratoryPrescription",
        "definition" : "Logical model describing the model for the prescription laboratory. This draft is used in the HL7 Belgian workgroup for laboratory."
      }
    ]
  }
}

```
