# uc2a-1 - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **uc2a-1**

## Example ServiceRequest: uc2a-1

Profile: [BeReferralPrescriptionNursing](StructureDefinition-be-referralprescription-nursing.md)

**BeFeedbackToPrescriber**: true

**BeValidityPeriod**: 2023-01-26 --> 2023-07-26

**Request status reason**: In progress

**BePerformerType**: nurse

**basedOn**: Identifier: `https://nonexistant.system.be/vidis`/medication-line-id

**status**: Active

**intent**: Order

**category**: Nursing procedure

**priority**: Routine

**code**: 385796006

**subject**: Identifier: BeSSINNamingSystem/38012699993

**authoredOn**: 2023-01-26 00:00:00+0100

**requester**: Identifier: BeNIHDINamingSystem/10829059004

**reasonCode**: 44653001

**note**: 

> 

Dalacin 350 mg / 8 uur, intraveneus gedurende zeven dagen, via een perifere katheter




## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "uc2a-1",
  "meta" : {
    "profile" : [
      "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-nursing"
    ]
  },
  "extension" : [
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-feedback-to-prescriber",
      "valueBoolean" : true
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-validity-period",
      "valuePeriod" : {
        "start" : "2023-01-26",
        "end" : "2023-07-26"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/request-statusReason",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-status-reason",
            "code" : "inProgress",
            "display" : "In progress"
          }
        ]
      }
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-performer-type",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
            "code" : "persnurse"
          }
        ]
      }
    }
  ],
  "basedOn" : [
    {
      "identifier" : {
        "system" : "https://nonexistant.system.be/vidis",
        "value" : "medication-line-id"
      }
    }
  ],
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "9632001"
        }
      ],
      "text" : "Nursing procedure"
    }
  ],
  "priority" : "routine",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/11000172109",
        "code" : "385796006"
      }
    ]
  },
  "subject" : {
    "identifier" : {
      "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/ssin",
      "value" : "38012699993"
    }
  },
  "authoredOn" : "2023-01-26T00:00:00+01:00",
  "requester" : {
    "identifier" : {
      "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/nihdi",
      "value" : "10829059004"
    }
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "44653001"
        }
      ]
    }
  ],
  "note" : [
    {
      "text" : "Dalacin 350 mg / 8 uur, intraveneus gedurende zeven dagen, via een perifere katheter"
    }
  ]
}

```
