# example16-referralprescription-nursing-bladder-care - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **example16-referralprescription-nursing-bladder-care**

## Example ServiceRequest: example16-referralprescription-nursing-bladder-care



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "example16-referralprescription-nursing-bladder-care",
  "meta" : {
    "profile" : [
      "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-nursing"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Patient",
      "id" : "patient1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-patient"
        ]
      },
      "identifier" : [
        {
          "use" : "official",
          "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/ssin",
          "value" : "99999999991"
        }
      ],
      "name" : [
        {
          "family" : "Doe",
          "given" : ["Jane"]
        }
      ],
      "gender" : "female",
      "birthDate" : "1956-05-27"
    },
    {
      "resourceType" : "PractitionerRole",
      "id" : "practitionerrole1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
        ]
      },
      "identifier" : [
        {
          "system" : "http://www.acme.org/practitioners",
          "value" : "23"
        }
      ],
      "active" : true,
      "period" : {
        "start" : "2019-08-01T00:00:00.000Z",
        "end" : "2019-12-01T00:00:00.000Z"
      },
      "practitioner" : {
        "reference" : "Practitioner/Performer1",
        "display" : "Dr Katherine Pulaski"
      },
      "code" : [
        {
          "coding" : [
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
              "code" : "persphysician",
              "display" : "physician"
            }
          ]
        }
      ],
      "specialty" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "http://snomed.info/sct/11000172109",
              "code" : "419772000",
              "display" : "Family practice"
            }
          ]
        }
      ],
      "availableTime" : [
        {
          "daysOfWeek" : ["mon", "tue", "wed"],
          "availableStartTime" : "09:00:00",
          "availableEndTime" : "16:30:00"
        },
        {
          "daysOfWeek" : ["thu", "fri"],
          "availableStartTime" : "09:00:00",
          "availableEndTime" : "12:00:00"
        }
      ],
      "notAvailable" : [
        {
          "description" : "Katherine will be on extended leave during August 2020",
          "during" : {
            "start" : "2020-08-01T00:00:00.000Z",
            "end" : "2020-08-20T00:00:00.000Z"
          }
        }
      ],
      "availabilityExceptions" : "Katherine is generally unavailable on public holidays and during the Christmas/New Year break"
    },
    {
      "resourceType" : "PractitionerRole",
      "id" : "requesterrole1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
        ]
      },
      "practitioner" : {
        "reference" : "Practitioner/Requester1"
      },
      "code" : [
        {
          "coding" : [
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
              "code" : "persphysician",
              "display" : "physician"
            }
          ]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-feedback-to-prescriber",
      "valueBoolean" : true
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-validity-period",
      "valuePeriod" : {
        "start" : "2022-04-19",
        "end" : "2023-04-19"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/request-statusReason",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-status-reason",
            "code" : "inProgress",
            "display" : "In Progress"
          }
        ]
      }
    }
  ],
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "9632001"
        }
      ],
      "text" : "Nursing procedure"
    }
  ],
  "priority" : "routine",
  "code" : {
    "coding" : [
      {
        "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-cs-temp-requested-service",
        "code" : "tmp-inte-tion-6"
      }
    ]
  },
  "subject" : {
    "reference" : "#patient1"
  },
  "occurrenceTiming" : {
    "repeat" : {
      "boundsPeriod" : {
        "start" : "2021-07-06",
        "end" : "2022-07-20"
      },
      "frequency" : 2,
      "period" : 1,
      "periodUnit" : "d"
    }
  },
  "authoredOn" : "2022-10-31T00:00:00+01:00",
  "requester" : {
    "reference" : "#requesterrole1"
  },
  "performer" : [
    {
      "reference" : "#practitionerrole1"
    }
  ],
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "309256001"
        }
      ]
    }
  ]
}

```
