# diagnostic-imaging-basic-example-concreteWithText - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **diagnostic-imaging-basic-example-concreteWithText**

## Example ServiceRequest: diagnostic-imaging-basic-example-concreteWithText



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "diagnostic-imaging-basic-example-concreteWithText",
  "meta" : {
    "profile" : [
      "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-diagnosticimaging"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Patient",
      "id" : "patient1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-patient"
        ]
      },
      "identifier" : [
        {
          "use" : "official",
          "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/ssin",
          "value" : "99999999991"
        }
      ],
      "name" : [
        {
          "family" : "Doe",
          "given" : ["Jane"]
        }
      ],
      "gender" : "female",
      "birthDate" : "1956-05-27"
    },
    {
      "resourceType" : "PractitionerRole",
      "id" : "requesterrole1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
        ]
      },
      "practitioner" : {
        "reference" : "Practitioner/Requester1"
      },
      "code" : [
        {
          "coding" : [
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
              "code" : "persphysician",
              "display" : "physician"
            }
          ]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-feedback-to-prescriber",
      "valueBoolean" : true
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-validity-period",
      "valuePeriod" : {
        "start" : "2020-01-01",
        "end" : "2021-01-01"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/request-statusReason",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-status-reason",
            "code" : "inProgress",
            "display" : "In progress"
          }
        ]
      }
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-supporting-info",
      "valueAnnotation" : {
        "text" : "Inversietrauma rechtervoet 20/1"
      }
    }
  ],
  "modifierExtension" : [
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-contraindication",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
            "code" : "ASKU",
            "display" : "asked but unknown"
          }
        ]
      }
    }
  ],
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "363679005",
          "display" : "Clinical imaging"
        }
      ]
    }
  ],
  "priority" : "routine",
  "code" : {
    "text" : "Rx + echo rechtervoet"
  },
  "subject" : {
    "reference" : "#patient1"
  },
  "authoredOn" : "2022-01-01T00:00:00+01:00",
  "requester" : {
    "reference" : "#requesterrole1"
  },
  "reasonCode" : [
    {
      "text" : "Fractuur? Ligamentair letsel?"
    }
  ]
}

```
