# BeSPTaskStatusProfile - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeSPTaskStatusProfile**

## SearchParameter: BeSPTaskStatusProfile 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/SearchParameter/be-sp-task-status-profile | *Version*:1.0.0 |
| Active as of 2025-10-10 | *Computable Name*:statusProfile |

 
This SearchParameter enables query of Tasks on the combination of status and profile 

## statusProfile

Parameter `statusProfile`:`composite`

This SearchParameter enables query of Tasks on the combination of status and profile

| | |
| :--- | :--- |
| Resource | [Task](http://hl7.org/fhir/R4/task.html) |
| Expression | `(Task.status | Task.meta.profile).join('$')` |
| Multiples | * multipleAnd: The parameter may only appear once
* multipleOr: The parameter may have multiple values (separated by comma) where at least one must be true
 |

**Comparators**

| | |
| :--- | :--- |
| http://hl7.org/fhir/SearchParameter/Task-status | `status` |
| http://hl7.org/fhir/SearchParameter/Resource-profile | `_profile` |



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "be-sp-task-status-profile",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/SearchParameter/be-sp-task-status-profile",
  "version" : "1.0.0",
  "name" : "statusProfile",
  "status" : "active",
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "This SearchParameter enables query of Tasks on the combination of status and profile",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "code" : "statusProfile",
  "base" : ["Task"],
  "type" : "composite",
  "expression" : "(Task.status | Task.meta.profile).join('$')",
  "multipleOr" : true,
  "multipleAnd" : false,
  "component" : [
    {
      "definition" : "http://hl7.org/fhir/SearchParameter/Task-status",
      "expression" : "status"
    },
    {
      "definition" : "http://hl7.org/fhir/SearchParameter/Resource-profile",
      "expression" : "_profile"
    }
  ]
}

```
