# be-op-cancel - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **be-op-cancel**

## OperationDefinition: be-op-cancel (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/OperationDefinition/be-op-cancel | *Version*:1.0.0 |
| Draft as of 2020-07-24 | *Computable Name*:cancel |

 
Cancel Referral Prescription or Proposal 

### Parameters

* **Use**: IN
  * **Name**: reasonCode
  * **Scope**: 
  * **Cardinality**: 0..1
  * **Type**: [code](http://hl7.org/fhir/R4/datatypes.html#code)
  * **Binding**: https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-reason-referral-status (Required)
  * **Documentation**: reason for the cancelling



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "be-op-cancel",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/OperationDefinition/be-op-cancel",
  "version" : "1.0.0",
  "name" : "cancel",
  "title" : "Cancel Referral Prescription or Proposal",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : true,
  "date" : "2020-07-24",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Cancel Referral Prescription or Proposal",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "cancel",
  "resource" : ["ServiceRequest"],
  "system" : false,
  "type" : false,
  "instance" : false,
  "parameter" : [
    {
      "name" : "reasonCode",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "reason for the cancelling",
      "type" : "code",
      "binding" : {
        "strength" : "required",
        "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-reason-referral-status"
      }
    }
  ]
}

```
