# BePrescriptionProposalType - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BePrescriptionProposalType**

## CodeSystem: BePrescriptionProposalType 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-proposal-type | *Version*:1.0.0 |
| Draft as of 2022-05-03 | *Computable Name*:BePrescriptionProposalType |

 
Prescription Proposal Type. Indicates the type of proposal (new or prolongation) as from the uses cases by NIHDI 

 This Code system is referenced in the content logical definition of the following value sets: 

* [BeVsProposalType](ValueSet-be-vs-proposal-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "be-prescription-proposal-type",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-proposal-type",
  "version" : "1.0.0",
  "name" : "BePrescriptionProposalType",
  "title" : "BePrescriptionProposalType",
  "status" : "draft",
  "experimental" : false,
  "date" : "2022-05-03T10:04:16+02:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Prescription Proposal Type. Indicates the type of proposal (new or prolongation) as from the uses cases by NIHDI",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 2,
  "concept" : [
    {
      "code" : "new",
      "display" : "new",
      "designation" : [
        {
          "language" : "en",
          "value" : "This is a new proposal from a caregiver"
        }
      ]
    },
    {
      "code" : "prolongation",
      "display" : "prolongation",
      "designation" : [
        {
          "language" : "en",
          "value" : "This is a proposal based on an existing prescription"
        }
      ]
    }
  ]
}

```
