# BeCommunicationCode - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeCommunicationCode**

## CodeSystem: BeCommunicationCode 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-communication-code | *Version*:1.0.0 |
| Draft as of 2022-05-03 | *Computable Name*:BeCommunicationCode |

 
Communication codes in Belgium. To define a specific method of communicating. Initially defined as supporting CodeSystem for the referral prescription. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [BeCommunicationMethod](ValueSet-be-vs-communication-method.md)

This case-insensitive code system `https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-communication-code` provides **a fragment** that includes following codes:



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "be-communication-code",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-communication-code",
  "version" : "1.0.0",
  "name" : "BeCommunicationCode",
  "title" : "BeCommunicationCode",
  "status" : "draft",
  "experimental" : false,
  "date" : "2022-05-03T10:04:16+02:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Communication codes in Belgium. To define a specific method of communicating. Initially defined as supporting CodeSystem for the referral prescription.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "fragment",
  "concept" : [
    {
      "code" : "whatsapp",
      "display" : "Whatsapp"
    },
    {
      "code" : "signal",
      "display" : "Signal"
    },
    {
      "code" : "telegram",
      "display" : "Telegram"
    }
  ]
}

```
