# BeTempRequestedServiceDetail - Digital Referral Prescription Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeTempRequestedServiceDetail**

## CodeSystem: BeTempRequestedServiceDetail 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/drp/CodeSystem/be-cs-temp-requested-service-detail | *Version*:1.0.0 |
| Draft as of 2025-10-17 | *Computable Name*:BeTempRequestedServiceDetail |

 
DEMONSTRATIVE EXAMPLE - Temporary codes for indicating service details that can be requested from a Nurse 

 This Code system is referenced in the content logical definition of the following value sets: 

* [BeVSRequestedServicesNurseDetail](ValueSet-be-vs-requested-services-nurse-detail.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "be-cs-temp-requested-service-detail",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/drp/CodeSystem/be-cs-temp-requested-service-detail",
  "version" : "1.0.0",
  "name" : "BeTempRequestedServiceDetail",
  "title" : "BeTempRequestedServiceDetail",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-17T08:37:16+00:00",
  "description" : "DEMONSTRATIVE EXAMPLE - Temporary codes for indicating service details that can be requested from a Nurse",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 24,
  "concept" : [
    {
      "code" : "tmp-with-tion-7",
      "display" : "Within convention",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Binnen conventie"
        },
        {
          "language" : "nl-BE",
          "value" : "Au sein de la convention"
        },
        {
          "language" : "en",
          "value" : "Within convention"
        }
      ]
    },
    {
      "code" : "tmp-with-sion-8",
      "display" : "Within progression",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Binnen voortraject"
        },
        {
          "language" : "nl-BE",
          "value" : "Dans la progression"
        },
        {
          "language" : "en",
          "value" : "Within progression"
        }
      ]
    },
    {
      "code" : "tmp-with-tory-8",
      "display" : "Without trajectory",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Zonder traject"
        },
        {
          "language" : "nl-BE",
          "value" : "Sans trajectoire"
        },
        {
          "language" : "en",
          "value" : "Without trajectory"
        }
      ]
    },
    {
      "code" : "tmp-prot-dges-5",
      "display" : "protection of wound edges",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "bescherming van wondranden"
        },
        {
          "language" : "nl-BE",
          "value" : "protection des bords de la plaie"
        },
        {
          "language" : "en",
          "value" : "protection of wound edges"
        }
      ]
    },
    {
      "code" : "tmp-shor-wick-2",
      "display" : "Shorten wick",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Inkorten wiek"
        },
        {
          "language" : "nl-BE",
          "value" : "Raccourcir la mèche"
        },
        {
          "language" : "en",
          "value" : "Shorten wick"
        }
      ]
    },
    {
      "code" : "tmp-supe-tion-2",
      "display" : "supervised drain without suction",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "toezicht drain zonder suctie"
        },
        {
          "language" : "nl-BE",
          "value" : "vidange surveillée sans aspiration"
        },
        {
          "language" : "en",
          "value" : "supervised drain without suction"
        }
      ]
    },
    {
      "code" : "tmp-for0-tion-6",
      "display" : "For insulin administration",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Voor insuline toediening"
        },
        {
          "language" : "nl-BE",
          "value" : "Pour l'administration d'insuline"
        },
        {
          "language" : "en",
          "value" : "For insulin administration"
        }
      ]
    },
    {
      "code" : "tmp-for0-tion-9",
      "display" : "For medication administration",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Voor medicatietoediening"
        },
        {
          "language" : "nl-BE",
          "value" : "Pour l'administration des médicaments"
        },
        {
          "language" : "en",
          "value" : "For medication administration"
        }
      ]
    },
    {
      "code" : "tmp-glyc-file-0",
      "display" : "Glycemic day profile",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Glycemiedagprofiel"
        },
        {
          "language" : "nl-BE",
          "value" : "Profil glycémique du jour"
        },
        {
          "language" : "en",
          "value" : "Glycemic day profile"
        }
      ]
    },
    {
      "code" : "tmp-bolu-very-5",
      "display" : "bolus medication delivery",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "medicatietoediening in bolus"
        },
        {
          "language" : "nl-BE",
          "value" : "administration de médicaments en bolus"
        },
        {
          "language" : "en",
          "value" : "bolus medication delivery"
        }
      ]
    },
    {
      "code" : "tmp-medi-tion-8",
      "display" : "medication administration via dilution",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "medicatietoediening via verdunning"
        },
        {
          "language" : "nl-BE",
          "value" : "administration de médicaments par dilution"
        },
        {
          "language" : "en",
          "value" : "medication administration via dilution"
        }
      ]
    },
    {
      "code" : "tmp-supr-0tip-7",
      "display" : "Suprapubic bladder care insertion tip",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Suprapubische blaassonde verzorging insteekpunt"
        },
        {
          "language" : "nl-BE",
          "value" : "Embout d'insertion pour soins de la vessie sus-pubienne"
        },
        {
          "language" : "en",
          "value" : "Suprapubic bladder care insertion tip"
        }
      ]
    },
    {
      "code" : "tmp-supr-ring-4",
      "display" : "Suprapubic bladder tube monitoring",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Suprapubische blaassonde toezicht"
        },
        {
          "language" : "nl-BE",
          "value" : "Surveillance du tube vésical sus-pubien"
        },
        {
          "language" : "en",
          "value" : "Suprapubic bladder tube monitoring"
        }
      ]
    },
    {
      "code" : "tmp-educ-ight-0",
      "display" : "Education to insight",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Educatie tot inzicht"
        },
        {
          "language" : "nl-BE",
          "value" : "L'éducation à la perspicacité"
        },
        {
          "language" : "en",
          "value" : "Education to insight"
        }
      ]
    },
    {
      "code" : "tmp-guid-care-5",
      "display" : "Guidance if not self-care",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Begeleiding indien geen zelfzorg"
        },
        {
          "language" : "nl-BE",
          "value" : "Des conseils sinon des soins personnels"
        },
        {
          "language" : "en",
          "value" : "Guidance if not self-care"
        }
      ]
    },
    {
      "code" : "tmp-foll-tion-5",
      "display" : "Follow-up after education",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Opvolging na educatie"
        },
        {
          "language" : "nl-BE",
          "value" : "Suivi après l'éducation"
        },
        {
          "language" : "en",
          "value" : "Follow-up after education"
        }
      ]
    },
    {
      "code" : "tmp-foll-care-7",
      "display" : "Follow-up of the patient who does not switch to self-care",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Opvolging van de patiënt die niet overstapt op zelfzorg"
        },
        {
          "language" : "nl-BE",
          "value" : "Suivi du patient qui ne passe pas aux soins personnels"
        },
        {
          "language" : "en",
          "value" : "Follow-up of the patient who does not switch to self-care"
        }
      ]
    },
    {
      "code" : "tmp-star-nist-0",
      "display" : "Start insulin or GLP 1 agonist",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Start insuline of GLP 1-agonist"
        },
        {
          "language" : "nl-BE",
          "value" : "Démarrer l'insuline ou l'agoniste du GLP 1"
        },
        {
          "language" : "en",
          "value" : "Start insulin or GLP 1 agonist"
        }
      ]
    },
    {
      "code" : "tmp-addi->7.5-0",
      "display" : "Additional education HBA1C>7.5",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Bijkomende educatie HBA1C>7.5"
        },
        {
          "language" : "nl-BE",
          "value" : "Formation complémentaire HBA1C>7.5"
        },
        {
          "language" : "en",
          "value" : "Additional education HBA1C>7.5"
        }
      ]
    },
    {
      "code" : "tmp-addi-ions-3",
      "display" : "Additional education switching from 1 to 2 injections",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Bijkomende educatie omschakeling van 1 naar 2 injecties"
        },
        {
          "language" : "nl-BE",
          "value" : "Formation complémentaire passage de 1 à 2 injections"
        },
        {
          "language" : "en",
          "value" : "Additional education switching from 1 to 2 injections"
        }
      ]
    },
    {
      "code" : "tmp-educ-tion-0",
      "display" : "Education in patients on oral medication",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Educatie bij patiënten met orale medicatie"
        },
        {
          "language" : "nl-BE",
          "value" : "Éducation des patients sous médication orale"
        },
        {
          "language" : "en",
          "value" : "Education in patients on oral medication"
        }
      ]
    },
    {
      "code" : "tmp-educ-rial-8",
      "display" : "Education material",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Educatie materiaal"
        },
        {
          "language" : "nl-BE",
          "value" : "Matériel pédagogique"
        },
        {
          "language" : "en",
          "value" : "Education material"
        }
      ]
    },
    {
      "code" : "tmp-grou-sion-3",
      "display" : "Group session",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Groepsessie"
        },
        {
          "language" : "nl-BE",
          "value" : "Séance de groupe"
        },
        {
          "language" : "en",
          "value" : "Group session"
        }
      ]
    },
    {
      "code" : "tmp-indi-sion-8",
      "display" : "Individual session",
      "designation" : [
        {
          "language" : "fr-BE",
          "value" : "Individuele sessie"
        },
        {
          "language" : "nl-BE",
          "value" : "Séance individuelle"
        },
        {
          "language" : "en",
          "value" : "Individual session"
        }
      ]
    }
  ]
}

```
