# hl7.fhir.be.pss#1.0.0: Prescription Search Support

## Pages

* [Home](index.md)
* [Radiology](radiology.md)
* [Antimicrobiology](antimicrobiology.md)
* [Downloads](downloads.md)
* [Functional Overview](functional-overview.md)
* [Artifacts Summary](artifacts.md)
* [Overview of PSS services](services.md)
* [Changes](changes.md)

## Resources

### CodeSystems

* [PSS Feedback Codes](CodeSystem-PSSFeedbackCodes.md)
* [PSS Feedback Code Reasons](CodeSystem-PSSFeedbackReasons.md)
* [PSS-QSI condition codes](CodeSystem-PSSQSIConditions.md)
* [PSS-QSI procedure codes](CodeSystem-PSSQSIProcedures.md)
* [CodeSystem: Types of rating provided by the PSS system](CodeSystem-PSSRatingTypes.md)
* [PSS Exception Codes](CodeSystem-pss-exception-codes.md)

### ValueSets

* [Bacterial Codes](ValueSet-BacterialCodes.md)
* [Candida Codes](ValueSet-CandidaCodes.md)
* [Chlamydia Codes](ValueSet-ChlamydiaCodes.md)
* [CompromisedImmuneSystem Codes](ValueSet-CompromisedImmuneSystemCodes.md)
* [Gonokok Codes](ValueSet-GonokokCodes.md)
* [Mycoplasma Codes](ValueSet-MycoplasmaCodes.md)
* [OncologyPatient Codes](ValueSet-OncologyPatientCodes.md)
* [Other Codes](ValueSet-OtherCodes.md)
* [PSS Feedback Codes](ValueSet-PSSFeedbackCodesVS.md)
* [PSS Feedback Code Reasons](ValueSet-PSSFeedbackReasonsVS.md)
* [Types of rating provided by the PSS system](ValueSet-PSSRatingTypesVS.md)
* [Pregnancy Codes](ValueSet-PregnancyCodes.md)
* [Trichomonas Codes](ValueSet-TrichomonasCodes.md)
* [PSS Exception ValueSet](ValueSet-pss-exception-valueset.md)

### Logicals

* [PSS Consent](StructureDefinition-PSSConsentModel.md)
* [PSS Feedback](StructureDefinition-PSSFeedbackModel.md)
* [PSS Request](StructureDefinition-PSSRequest.md)
* [PSS Response](StructureDefinition-PSSResponse.md)

### Resource Profiles

* [PSS Feedback Task](StructureDefinition-FeedbackTask.md)
* [PSS Data Acquisition Form](StructureDefinition-PSSDataAcquisitionForm.md)
* [PSS MedicationRequest Task](StructureDefinition-PSSMedicationRequest.md)
* [PSS anonymised Patient](StructureDefinition-PSSPatient.md)
* [PSS Questionnaire Task](StructureDefinition-PSSQuestionnaireTask.md)
* [PSS Request Bundle](StructureDefinition-PSSRequestBundle.md)
* [PSS Response Bundle](StructureDefinition-PSSResponseBundle.md)
* [PSS Response Communication Request](StructureDefinition-PSSResponseCommunicationRequest.md)
* [PSS Response Medication Request](StructureDefinition-PSSResponseMedicationRequest.md)
* [PSS Response Request Group](StructureDefinition-PSSResponseRequestGroup.md)
* [PSS Response Service Request](StructureDefinition-PSSResponseServiceRequest.md)

### Extensions

* [AnswerOption Additional Code](StructureDefinition-AnswerOptionAdditionalCode.md)
* [Code ValueSet](StructureDefinition-CodeValueSet.md)
* [PSS Relevant Patient Age](StructureDefinition-PSSRelevantAge.md)
* [PSS Rating Extension](StructureDefinition-PSSStructuredRating.md)

### CapabilityStatements

* [PSS Provider System Capability Statement](CapabilityStatement-PSSProviderCapabilityStatement.md)

### ImplementationGuides

* [Prescription Search Support](index.md)

### OperationDefinitions

* [PSS Feedback](OperationDefinition-Feedback.md)

### Examples

* [30551ce1-5a28-4356-b684-2e639094ad02 (AllergyIntolerance)](AllergyIntolerance-30551ce1-5a28-4356-b684-2e639094ad02.md)
* [any-service-no-consent-response-response (Bundle)](Bundle-any-service-no-consent-response-response.md)
* [getdatatocollect-a-data (Bundle)](Bundle-getdatatocollect-a-data.md)
* [getdatatocollect-a-response (Bundle)](Bundle-getdatatocollect-a-response.md)
* [getrecommendations-a-data (Bundle)](Bundle-getrecommendations-a-data.md)
* [getrecommendations-a-response (Bundle)](Bundle-getrecommendations-a-response.md)
* [getrecommendations-data3 (Bundle)](Bundle-getrecommendations-data3.md)
* [getrecommendations-r-response (Bundle)](Bundle-getrecommendations-r-response.md)
* [no-response-response (Bundle)](Bundle-no-response-response.md)
* [radiology-getdiagnoses-response (Bundle)](Bundle-radiology-getdiagnoses-response.md)
* [radiology-getdiagnoses (Bundle)](Bundle-radiology-getdiagnoses.md)
* [1e6c8c0a-9f7f-4f65-bc16-3a7a5e7b29c2 (CommunicationRequest)](CommunicationRequest-1e6c8c0a-9f7f-4f65-bc16-3a7a5e7b29c2.md)
* [30551ce1-5a28-4356-b684-1e639094dd22 (CommunicationRequest)](CommunicationRequest-30551ce1-5a28-4356-b684-1e639094dd22.md)
* [287e8fe2-3e83-44bd-92e7-962bc90b6d67 (Condition)](Condition-287e8fe2-3e83-44bd-92e7-962bc90b6d67.md)
* [30551ce1-5a28-4356-b684-2e639094ad01 (Condition)](Condition-30551ce1-5a28-4356-b684-2e639094ad01.md)
* [30551ce1-5a28-4356-b684-4e639094ad11 (Condition)](Condition-30551ce1-5a28-4356-b684-4e639094ad11.md)
* [5f3aafb8-643c-4ed5-ad54-199939e7b2d1 (Condition)](Condition-5f3aafb8-643c-4ed5-ad54-199939e7b2d1.md)
* [72d3ced6-5133-4042-931e-04284c9f4283 (Condition)](Condition-72d3ced6-5133-4042-931e-04284c9f4283.md)
* [b90ca57a-1ae5-4ff6-8dce-48488660ea65 (Condition)](Condition-b90ca57a-1ae5-4ff6-8dce-48488660ea65.md)
* [pss-30551ce1-5a28-4356-b684-4e639094ad11 (Condition)](Condition-pss-30551ce1-5a28-4356-b684-4e639094ad11.md)
* [30551ce1-5a28-4356-b684-1e639094ac23 (MedicationRequest)](MedicationRequest-30551ce1-5a28-4356-b684-1e639094ac23.md)
* [30551ce1-5a28-4356-b684-1e639094ad24 (MedicationRequest)](MedicationRequest-30551ce1-5a28-4356-b684-1e639094ad24.md)
* [30551ce1-5a28-4356-b684-1e639094ad25 (MedicationRequest)](MedicationRequest-30551ce1-5a28-4356-b684-1e639094ad25.md)
* [30551ce1-5a28-4356-b684-1e639094ad26 (MedicationRequest)](MedicationRequest-30551ce1-5a28-4356-b684-1e639094ad26.md)
* [30551ce1-5a28-4356-b684-1e639094ad29 (MedicationRequest)](MedicationRequest-30551ce1-5a28-4356-b684-1e639094ad29.md)
* [30551ce1-5a28-4356-b684-2e639094ad12 (MedicationRequest)](MedicationRequest-30551ce1-5a28-4356-b684-2e639094ad12.md)
* [ataxia (Observation)](Observation-ataxia.md)
* [feedback-example (Parameters)](Parameters-feedback-example.md)
* [30551ce1-5a28-4356-b684-2e639094ad48 (Patient)](Patient-30551ce1-5a28-4356-b684-2e639094ad48.md)
* [30551ce1-5a28-4356-b684-3e639094ad48 (Patient)](Patient-30551ce1-5a28-4356-b684-3e639094ad48.md)
* [GetDataToCollect (PlanDefinition)](PlanDefinition-GetDataToCollect.md)
* [GetDiagnoses (PlanDefinition)](PlanDefinition-GetDiagnoses.md)
* [GetRecommendations (PlanDefinition)](PlanDefinition-GetRecommendations.md)
* [TCConsentForm (Questionnaire)](Questionnaire-26491cef-c5c7-4c5f-b10b-839e938f6b3e.md)
* [30551ce1-5a28-4356-b684-2e639094ad4c (Questionnaire)](Questionnaire-30551ce1-5a28-4356-b684-2e639094ad4c.md)
* [30551ce1-5a28-4356-b684-2e639094ac02 (QuestionnaireResponse)](QuestionnaireResponse-30551ce1-5a28-4356-b684-2e639094ac02.md)
* [26491cef-c5c7-4c5f-b10b-839e938f6b3c (RequestGroup)](RequestGroup-26491cef-c5c7-4c5f-b10b-839e938f6b3c.md)
* [30551ce1-5a28-4356-b684-3e639094ad08 (RequestGroup)](RequestGroup-30551ce1-5a28-4356-b684-3e639094ad08.md)
* [getdatatocollect-a-response-group (RequestGroup)](RequestGroup-getdatatocollect-a-response-group.md)
* [getrecommendations-a-response-group (RequestGroup)](RequestGroup-getrecommendations-a-response-group.md)
* [getrecommendations-r-response-1 (RequestGroup)](RequestGroup-getrecommendations-r-response-1.md)
* [no-response-group (RequestGroup)](RequestGroup-no-response-group.md)
* [30551ce1-5a28-4356-b684-1e639044ad77 (ServiceRequest)](ServiceRequest-30551ce1-5a28-4356-b684-1e639044ad77.md)
* [30551ce1-5a28-4356-b684-1e639094ad22 (ServiceRequest)](ServiceRequest-30551ce1-5a28-4356-b684-1e639094ad22.md)
* [30551ce1-5a28-4356-b684-1e639094ad23 (ServiceRequest)](ServiceRequest-30551ce1-5a28-4356-b684-1e639094ad23.md)
* [ct-head-wo-iv-contrast (ServiceRequest)](ServiceRequest-ct-head-wo-iv-contrast.md)
* [pss-ct-head-wo-iv-contrast (ServiceRequest)](ServiceRequest-pss-ct-head-wo-iv-contrast.md)
* [1cdd5aab-1d4d-4965-bbe1-c851698d07f0 (Task)](Task-1cdd5aab-1d4d-4965-bbe1-c851698d07f0.md)
* [26491cef-c5c7-4c5f-b10b-839e938f6b3d (Task)](Task-26491cef-c5c7-4c5f-b10b-839e938f6b3d.md)
* [30551ce1-5a28-4356-b684-11ef43a67755 (Task)](Task-30551ce1-5a28-4356-b684-11ef43a67755.md)
* [30551ce1-5a28-4356-b684-3e639094ad11 (Task)](Task-30551ce1-5a28-4356-b684-3e639094ad11.md)
* [54aad964-ad8a-4985-8ff1-3b09d707ee1e (Task)](Task-54aad964-ad8a-4985-8ff1-3b09d707ee1e.md)
* [FeedbackGroup1 (Task)](Task-FeedbackGroup1.md)
* [FeedbackOption1 (Task)](Task-FeedbackOption1.md)
* [FeedbackOption2 (Task)](Task-FeedbackOption2.md)
* [cfdfee5b-1db1-43fe-af72-4ea54b4e1a16 (Task)](Task-cfdfee5b-1db1-43fe-af72-4ea54b4e1a16.md)
* [db2698ba-cd0b-4c08-b57c-868ab5b95af6 (Task)](Task-db2698ba-cd0b-4c08-b57c-868ab5b95af6.md)
