# Home - Prescription Search Support v1.0.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/pss/ImplementationGuide/hl7.fhir.be.pss | *Version*:1.0.0 |
| Active as of 2024-04-26 | *Computable Name*:PrescriptionSearchSupport |
| *Other Identifiers:*OID:2.16.840.1.113883.2.51.22.2 | |

This publication contains the specification for the Prescription Search Support.

The functional scope is to provide options during a prescription. The initial focus is on Antimicrobiology, i.e. searches related to ordering of antibiotics.

Acknowledging the impact and complexity of providing feedback on ordering, the PSS project uses an overall approach taken based on the existing guidance, namely [Clinical Practice Guidelines](https://hl7.org/fhir/uv/cpg)

Note:

* The Questionnnaires, ValueSets and CodeSystems depend on the actual guidelines, so they are not normative, and may change. They will be subject to different updates.

-------

### Dependencies

This IG Contains the following dependencies on other IGs.





### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.be.pss.r4)](package.r4.tgz) and [R4B (hl7.fhir.be.pss.r4b)](package.r4b.tgz) are available. 

### Global Profiles

*There are no Global profiles defined*

### Intellectual Property

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AnswerOptionAdditionalCode](StructureDefinition-AnswerOptionAdditionalCode.md), [BacterialCodes](ValueSet-BacterialCodes.md)...Show 45 more,[CandidaCodes](ValueSet-CandidaCodes.md),[CapabilityStatement/PSSProviderCapabilityStatement](CapabilityStatement-PSSProviderCapabilityStatement.md),[ChlamydiaCodes](ValueSet-ChlamydiaCodes.md),[CodeValueSet](StructureDefinition-CodeValueSet.md),[CompromisedImmuneSystemCodes](ValueSet-CompromisedImmuneSystemCodes.md),[Feedback](OperationDefinition-Feedback.md),[FeedbackTask](StructureDefinition-FeedbackTask.md),[GonokokCodes](ValueSet-GonokokCodes.md),[MycoplasmaCodes](ValueSet-MycoplasmaCodes.md),[OncologyPatientCodes](ValueSet-OncologyPatientCodes.md),[OtherCodes](ValueSet-OtherCodes.md),[PSSConsentModel](StructureDefinition-PSSConsentModel.md),[PSSDataAcquisitionForm](StructureDefinition-PSSDataAcquisitionForm.md),[PSSExceptionCodes](CodeSystem-pss-exception-codes.md),[PSSExceptionValueSet](ValueSet-pss-exception-valueset.md),[PSSFeedbackCodes](CodeSystem-PSSFeedbackCodes.md),[PSSFeedbackCodesVS](ValueSet-PSSFeedbackCodesVS.md),[PSSFeedbackModel](StructureDefinition-PSSFeedbackModel.md),[PSSFeedbackReasons](CodeSystem-PSSFeedbackReasons.md),[PSSFeedbackReasonsVS](ValueSet-PSSFeedbackReasonsVS.md),[PSSMedicationRequest](StructureDefinition-PSSMedicationRequest.md),[PSSPatient](StructureDefinition-PSSPatient.md),[PSSQSIConditions](CodeSystem-PSSQSIConditions.md),[PSSQSIProcedures](CodeSystem-PSSQSIProcedures.md),[PSSQuestionnaireTask](StructureDefinition-PSSQuestionnaireTask.md),[PSSRatingTypes](CodeSystem-PSSRatingTypes.md),[PSSRatingTypesVS](ValueSet-PSSRatingTypesVS.md),[PSSRelevantAge](StructureDefinition-PSSRelevantAge.md),[PSSRequest](StructureDefinition-PSSRequest.md),[PSSRequestBundle](StructureDefinition-PSSRequestBundle.md),[PSSResponse](StructureDefinition-PSSResponse.md),[PSSResponseBundle](StructureDefinition-PSSResponseBundle.md),[PSSResponseCommunicationRequest](StructureDefinition-PSSResponseCommunicationRequest.md),[PSSResponseMedicationRequest](StructureDefinition-PSSResponseMedicationRequest.md),[PSSResponseRequestGroup](StructureDefinition-PSSResponseRequestGroup.md),[PSSResponseServiceRequest](StructureDefinition-PSSResponseServiceRequest.md),[PSSStructuredRating](StructureDefinition-PSSStructuredRating.md),[PlanDefinition/GetDataToCollect](PlanDefinition-GetDataToCollect.md),[PlanDefinition/GetDiagnoses](PlanDefinition-GetDiagnoses.md),[PlanDefinition/GetRecommendations](PlanDefinition-GetRecommendations.md),[PregnancyCodes](ValueSet-PregnancyCodes.md),[PrescriptionSearchSupport](index.md),[Questionnaire/30551ce1-5a28-4356-b684-2e639094ad4c](Questionnaire-30551ce1-5a28-4356-b684-2e639094ad4c.md),[TCConsentForm](Questionnaire-26491cef-c5c7-4c5f-b10b-839e938f6b3e.md)and[TrichomonasCodes](ValueSet-TrichomonasCodes.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Bundle/getrecommendations-a-response](Bundle-getrecommendations-a-response.md), [MedicationRequest/30551ce1-5a28-4356-b684-1e639094ac23](MedicationRequest-30551ce1-5a28-4356-b684-1e639094ac23.md), [MedicationRequest/30551ce1-5a28-4356-b684-1e639094ad24](MedicationRequest-30551ce1-5a28-4356-b684-1e639094ad24.md) and [MedicationRequest/30551ce1-5a28-4356-b684-1e639094ad25](MedicationRequest-30551ce1-5a28-4356-b684-1e639094ad25.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AllergyIntolerance/30551ce1-5a28-4356-b684-2e639094ad02](AllergyIntolerance-30551ce1-5a28-4356-b684-2e639094ad02.md), [BacterialCodes](ValueSet-BacterialCodes.md)...Show 15 more,[Bundle/getdatatocollect-a-data](Bundle-getdatatocollect-a-data.md),[Bundle/getrecommendations-a-data](Bundle-getrecommendations-a-data.md),[Bundle/radiology-getdiagnoses](Bundle-radiology-getdiagnoses.md),[CandidaCodes](ValueSet-CandidaCodes.md),[ChlamydiaCodes](ValueSet-ChlamydiaCodes.md),[CompromisedImmuneSystemCodes](ValueSet-CompromisedImmuneSystemCodes.md),[Condition/30551ce1-5a28-4356-b684-2e639094ad01](Condition-30551ce1-5a28-4356-b684-2e639094ad01.md),[GonokokCodes](ValueSet-GonokokCodes.md),[MycoplasmaCodes](ValueSet-MycoplasmaCodes.md),[Observation/ataxia](Observation-ataxia.md),[OncologyPatientCodes](ValueSet-OncologyPatientCodes.md),[OtherCodes](ValueSet-OtherCodes.md),[PSSResponseServiceRequest](StructureDefinition-PSSResponseServiceRequest.md),[PregnancyCodes](ValueSet-PregnancyCodes.md)and[TrichomonasCodes](ValueSet-TrichomonasCodes.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/30551ce1-5a28-4356-b684-2e639094ad02](AllergyIntolerance-30551ce1-5a28-4356-b684-2e639094ad02.md), [Bundle/getdatatocollect-a-data](Bundle-getdatatocollect-a-data.md) and [Bundle/getrecommendations-a-data](Bundle-getrecommendations-a-data.md)
* [Condition Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-category.html): [Bundle/getdatatocollect-a-data](Bundle-getdatatocollect-a-data.md), [Bundle/getrecommendations-a-data](Bundle-getrecommendations-a-data.md)...Show 12 more,[Bundle/getrecommendations-data3](Bundle-getrecommendations-data3.md),[Bundle/radiology-getdiagnoses-response](Bundle-radiology-getdiagnoses-response.md),[Condition/287e8fe2-3e83-44bd-92e7-962bc90b6d67](Condition-287e8fe2-3e83-44bd-92e7-962bc90b6d67.md),[Condition/30551ce1-5a28-4356-b684-2e639094ad01](Condition-30551ce1-5a28-4356-b684-2e639094ad01.md),[Condition/30551ce1-5a28-4356-b684-4e639094ad11](Condition-30551ce1-5a28-4356-b684-4e639094ad11.md),[Condition/5f3aafb8-643c-4ed5-ad54-199939e7b2d1](Condition-5f3aafb8-643c-4ed5-ad54-199939e7b2d1.md),[Condition/72d3ced6-5133-4042-931e-04284c9f4283](Condition-72d3ced6-5133-4042-931e-04284c9f4283.md),[Condition/b90ca57a-1ae5-4ff6-8dce-48488660ea65](Condition-b90ca57a-1ae5-4ff6-8dce-48488660ea65.md),[Condition/pss-30551ce1-5a28-4356-b684-4e639094ad11](Condition-pss-30551ce1-5a28-4356-b684-4e639094ad11.md),[PlanDefinition/GetDataToCollect](PlanDefinition-GetDataToCollect.md),[PlanDefinition/GetDiagnoses](PlanDefinition-GetDiagnoses.md)and[PlanDefinition/GetRecommendations](PlanDefinition-GetRecommendations.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [Bundle/getdatatocollect-a-data](Bundle-getdatatocollect-a-data.md), [Bundle/getrecommendations-a-data](Bundle-getrecommendations-a-data.md)...Show 9 more,[Bundle/getrecommendations-data3](Bundle-getrecommendations-data3.md),[Bundle/radiology-getdiagnoses-response](Bundle-radiology-getdiagnoses-response.md),[Condition/287e8fe2-3e83-44bd-92e7-962bc90b6d67](Condition-287e8fe2-3e83-44bd-92e7-962bc90b6d67.md),[Condition/30551ce1-5a28-4356-b684-2e639094ad01](Condition-30551ce1-5a28-4356-b684-2e639094ad01.md),[Condition/30551ce1-5a28-4356-b684-4e639094ad11](Condition-30551ce1-5a28-4356-b684-4e639094ad11.md),[Condition/5f3aafb8-643c-4ed5-ad54-199939e7b2d1](Condition-5f3aafb8-643c-4ed5-ad54-199939e7b2d1.md),[Condition/72d3ced6-5133-4042-931e-04284c9f4283](Condition-72d3ced6-5133-4042-931e-04284c9f4283.md),[Condition/b90ca57a-1ae5-4ff6-8dce-48488660ea65](Condition-b90ca57a-1ae5-4ff6-8dce-48488660ea65.md)and[Condition/pss-30551ce1-5a28-4356-b684-4e639094ad11](Condition-pss-30551ce1-5a28-4356-b684-4e639094ad11.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/6.5.0/CodeSystem-condition-ver-status.html): [Bundle/getdatatocollect-a-data](Bundle-getdatatocollect-a-data.md), [Bundle/getrecommendations-a-data](Bundle-getrecommendations-a-data.md)...Show 10 more,[Bundle/getrecommendations-data3](Bundle-getrecommendations-data3.md),[Bundle/radiology-getdiagnoses-response](Bundle-radiology-getdiagnoses-response.md),[Condition/287e8fe2-3e83-44bd-92e7-962bc90b6d67](Condition-287e8fe2-3e83-44bd-92e7-962bc90b6d67.md),[Condition/30551ce1-5a28-4356-b684-2e639094ad01](Condition-30551ce1-5a28-4356-b684-2e639094ad01.md),[Condition/30551ce1-5a28-4356-b684-4e639094ad11](Condition-30551ce1-5a28-4356-b684-4e639094ad11.md),[Condition/5f3aafb8-643c-4ed5-ad54-199939e7b2d1](Condition-5f3aafb8-643c-4ed5-ad54-199939e7b2d1.md),[Condition/72d3ced6-5133-4042-931e-04284c9f4283](Condition-72d3ced6-5133-4042-931e-04284c9f4283.md),[Condition/b90ca57a-1ae5-4ff6-8dce-48488660ea65](Condition-b90ca57a-1ae5-4ff6-8dce-48488660ea65.md),[Condition/pss-30551ce1-5a28-4356-b684-4e639094ad11](Condition-pss-30551ce1-5a28-4356-b684-4e639094ad11.md)and[PlanDefinition/GetDataToCollect](PlanDefinition-GetDataToCollect.md)
* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [PlanDefinition/GetDataToCollect](PlanDefinition-GetDataToCollect.md), [PlanDefinition/GetDiagnoses](PlanDefinition-GetDiagnoses.md) and [PlanDefinition/GetRecommendations](PlanDefinition-GetRecommendations.md)
* [PlanDefinitionType](http://terminology.hl7.org/6.5.0/CodeSystem-plan-definition-type.html): [PlanDefinition/GetDataToCollect](PlanDefinition-GetDataToCollect.md), [PlanDefinition/GetDiagnoses](PlanDefinition-GetDiagnoses.md) and [PlanDefinition/GetRecommendations](PlanDefinition-GetRecommendations.md)


