# Antimicrobiology - S3 Get Recommendations - Response - 1. Bundle - Prescription Search Support v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Antimicrobiology - S3 Get Recommendations - Response - 1. Bundle**

## Example Bundle: Antimicrobiology - S3 Get Recommendations - Response - 1. Bundle



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "getrecommendations-a-response",
  "meta" : {
    "profile" : [
      "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSResponseBundle"
    ]
  },
  "identifier" : {
    "value" : "response1"
  },
  "type" : "collection",
  "timestamp" : "2025-02-20T00:00:00Z",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:30551ce1-5a28-4356-b684-1e639094ad21",
      "resource" : {
        "resourceType" : "RequestGroup",
        "id" : "getrecommendations-a-response-group",
        "meta" : {
          "profile" : [
            "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSResponseRequestGroup"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"RequestGroup_getrecommendations-a-response-group\"> </a><p class=\"res-header-id\"><b>Generated Narrative: RequestGroup getrecommendations-a-response-group</b></p><a name=\"getrecommendations-a-response-group\"> </a><a name=\"hcgetrecommendations-a-response-group\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-PSSResponseRequestGroup.html\">PSS Response Request Group</a></p></div><p><b>status</b>: Active</p><p><b>intent</b>: Proposal</p><p><b>subject</b>: <a href=\"Patient-30551ce1-5a28-4356-b684-2e639094ad48.html\"> Female, DoB Unknown</a></p><blockquote><p><b>action</b></p><h3>Documentations</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td><td><b>Label</b></td><td><b>Url</b></td></tr><tr><td style=\"display: none\">*</td><td>Documentation</td><td>Meer details op de BCFI site</td><td><a href=\"https://bcfi.be/nl/chapters/12?frag=8001869\">https://bcfi.be/nl/chapters/12?frag=8001869</a></td></tr><tr><td style=\"display: none\">*</td><td>Documentation</td><td>Plus de details sur le site CBIP</td><td><a href=\"https://cbip.be/fr/chapters/12?frag=8001869\">https://cbip.be/fr/chapters/12?frag=8001869</a></td></tr><tr><td style=\"display: none\">*</td><td>Documentation</td><td>Download het beslismodel van EBPNET</td><td><a href=\"https://ebpnet.be/nl/pss-vaginitis\">https://ebpnet.be/nl/pss-vaginitis</a></td></tr><tr><td style=\"display: none\">*</td><td>Documentation</td><td>Télécharger le modèle de décision d'EBPNET</td><td><a href=\"https://ebpnet.be/fr/pss-vaginite\">https://ebpnet.be/fr/pss-vaginite</a></td></tr></table><p><b>selectionBehavior</b>: At Most One</p><blockquote><p><b>action</b></p><blockquote><p><b>PSS Rating Extension</b></p><ul><li>ratingType: overall</li><li>ratingValue: 3/3</li><li>ratingText: </li></ul></blockquote><div><p>Over het algemeen aangewezen</p>\n</div><p><b>textEquivalent</b>: Algemeen advies</p><p><b>resource</b>: <a href=\"CommunicationRequest-30551ce1-5a28-4356-b684-1e639094dd22.html\">CommunicationRequest: status = active</a></p></blockquote><blockquote><p><b>action</b></p><blockquote><p><b>PSS Rating Extension</b></p><ul><li>ratingType: overall</li><li>ratingValue: 3/3</li><li>ratingText: </li></ul></blockquote><div><p>Over het algemeen aangewezen</p>\n</div><p><b>textEquivalent</b>: Metronidazol Oraal</p><p><b>resource</b>: <a href=\"MedicationRequest-30551ce1-5a28-4356-b684-1e639094ac23.html\">MedicationRequest: status = active; intent = proposal; medication[x] = metronidazole</a></p></blockquote><blockquote><p><b>action</b></p><blockquote><p><b>PSS Rating Extension</b></p><ul><li>ratingType: overall</li><li>ratingValue: 3/3</li><li>ratingText: </li></ul></blockquote><div><p>Over het algemeen aangewezen</p>\n</div><p><b>textEquivalent</b>: Clindamycin local</p><p><b>selectionBehavior</b>: All</p><h3>Actions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>TextEquivalent</b></td><td><b>Resource</b></td></tr><tr><td style=\"display: none\">*</td><td>Clindamycine ovule</td><td><a href=\"MedicationRequest-30551ce1-5a28-4356-b684-1e639094ad24.html\">MedicationRequest: status = active; intent = proposal; medication[x] = clindamycin</a></td></tr><tr><td style=\"display: none\">*</td><td>Clindamycine vaginale crème</td><td><a href=\"MedicationRequest-30551ce1-5a28-4356-b684-1e639094ad25.html\">MedicationRequest: status = active; intent = proposal; medication[x] = clindamycin</a></td></tr></table></blockquote><blockquote><p><b>action</b></p><blockquote><p><b>PSS Rating Extension</b></p><ul><li>ratingType: overall</li><li>ratingValue: 1/3</li><li>ratingText: </li></ul></blockquote><div><p>Niet aangewezen</p>\n</div><p><b>textEquivalent</b>: Fluconazol Oraal</p><p><b>resource</b>: <a href=\"MedicationRequest-30551ce1-5a28-4356-b684-1e639094ad26.html\">MedicationRequest: status = active; intent = proposal; medication[x] = </a></p></blockquote><blockquote><p><b>action</b></p><blockquote><p><b>PSS Rating Extension</b></p><ul><li>ratingType: overall</li><li>ratingValue: 1/3</li><li>ratingText: </li></ul></blockquote><div><p>Niet aangewezen</p>\n</div><p><b>textEquivalent</b>: Miconazol lokaal</p><p><b>resource</b>: <a href=\"MedicationRequest-30551ce1-5a28-4356-b684-1e639094ad29.html\">MedicationRequest: status = active; intent = proposal; medication[x] = </a></p></blockquote></blockquote></div>"
        },
        "status" : "active",
        "intent" : "proposal",
        "subject" : {
          "reference" : "Patient/30551ce1-5a28-4356-b684-2e639094ad48"
        },
        "action" : [
          {
            "documentation" : [
              {
                "type" : "documentation",
                "label" : "Meer details op de BCFI site",
                "_label" : {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/language",
                      "valueCode" : "nl-BE"
                    }
                  ]
                },
                "url" : "https://bcfi.be/nl/chapters/12?frag=8001869"
              },
              {
                "type" : "documentation",
                "label" : "Plus de details sur le site CBIP",
                "_label" : {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/language",
                      "valueCode" : "fr-BE"
                    }
                  ]
                },
                "url" : "https://cbip.be/fr/chapters/12?frag=8001869"
              },
              {
                "type" : "documentation",
                "label" : "Download het beslismodel van EBPNET",
                "_label" : {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/language",
                      "valueCode" : "nl-BE"
                    }
                  ]
                },
                "url" : "https://ebpnet.be/nl/pss-vaginitis"
              },
              {
                "type" : "documentation",
                "label" : "Télécharger le modèle de décision d'EBPNET",
                "_label" : {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/language",
                      "valueCode" : "fr-BE"
                    }
                  ]
                },
                "url" : "https://ebpnet.be/fr/pss-vaginite"
              }
            ],
            "selectionBehavior" : "at-most-one",
            "action" : [
              {
                "extension" : [
                  {
                    "extension" : [
                      {
                        "url" : "ratingType",
                        "valueCode" : "overall"
                      },
                      {
                        "url" : "ratingValue",
                        "valueRatio" : {
                          "numerator" : {
                            "value" : 3
                          },
                          "denominator" : {
                            "value" : 3
                          }
                        }
                      },
                      {
                        "url" : "ratingText",
                        "valueMarkdown" : "Over het algemeen aangewezen",
                        "_valueMarkdown" : {
                          "extension" : [
                            {
                              "extension" : [
                                {
                                  "url" : "lang",
                                  "valueCode" : "fr-BE"
                                },
                                {
                                  "url" : "content",
                                  "valueString" : "Généralement approprié"
                                }
                              ],
                              "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                            }
                          ]
                        }
                      }
                    ],
                    "url" : "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSStructuredRating"
                  }
                ],
                "textEquivalent" : "Algemeen advies",
                "_textEquivalent" : {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "lang",
                          "valueCode" : "fr-BE"
                        },
                        {
                          "url" : "content",
                          "valueString" : "Conseil général"
                        }
                      ],
                      "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                    }
                  ]
                },
                "resource" : {
                  "reference" : "CommunicationRequest/30551ce1-5a28-4356-b684-1e639094dd22"
                }
              },
              {
                "extension" : [
                  {
                    "extension" : [
                      {
                        "url" : "ratingType",
                        "valueCode" : "overall"
                      },
                      {
                        "url" : "ratingValue",
                        "valueRatio" : {
                          "numerator" : {
                            "value" : 3
                          },
                          "denominator" : {
                            "value" : 3
                          }
                        }
                      },
                      {
                        "url" : "ratingText",
                        "valueMarkdown" : "Over het algemeen aangewezen",
                        "_valueMarkdown" : {
                          "extension" : [
                            {
                              "extension" : [
                                {
                                  "url" : "lang",
                                  "valueCode" : "fr-BE"
                                },
                                {
                                  "url" : "content",
                                  "valueString" : "Généralement approprié"
                                }
                              ],
                              "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                            }
                          ]
                        }
                      }
                    ],
                    "url" : "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSStructuredRating"
                  }
                ],
                "textEquivalent" : "Metronidazol Oraal",
                "_textEquivalent" : {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "lang",
                          "valueCode" : "fr-BE"
                        },
                        {
                          "url" : "content",
                          "valueString" : "Métronidazole orale"
                        }
                      ],
                      "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                    }
                  ]
                },
                "resource" : {
                  "reference" : "MedicationRequest/30551ce1-5a28-4356-b684-1e639094ac23"
                }
              },
              {
                "extension" : [
                  {
                    "extension" : [
                      {
                        "url" : "ratingType",
                        "valueCode" : "overall"
                      },
                      {
                        "url" : "ratingValue",
                        "valueRatio" : {
                          "numerator" : {
                            "value" : 3
                          },
                          "denominator" : {
                            "value" : 3
                          }
                        }
                      },
                      {
                        "url" : "ratingText",
                        "valueMarkdown" : "Over het algemeen aangewezen",
                        "_valueMarkdown" : {
                          "extension" : [
                            {
                              "extension" : [
                                {
                                  "url" : "lang",
                                  "valueCode" : "fr-BE"
                                },
                                {
                                  "url" : "content",
                                  "valueString" : "Généralement approprié"
                                }
                              ],
                              "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                            }
                          ]
                        }
                      }
                    ],
                    "url" : "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSStructuredRating"
                  }
                ],
                "textEquivalent" : "Clindamycin local",
                "_textEquivalent" : {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "lang",
                          "valueCode" : "fr-BE"
                        },
                        {
                          "url" : "content",
                          "valueString" : "Clindamycine localement"
                        }
                      ],
                      "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                    }
                  ]
                },
                "selectionBehavior" : "all",
                "action" : [
                  {
                    "textEquivalent" : "Clindamycine ovule",
                    "_textEquivalent" : {
                      "extension" : [
                        {
                          "extension" : [
                            {
                              "url" : "lang",
                              "valueCode" : "fr-BE"
                            },
                            {
                              "url" : "content",
                              "valueString" : "Clindamycine ovule"
                            }
                          ],
                          "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                        }
                      ]
                    },
                    "resource" : {
                      "reference" : "MedicationRequest/30551ce1-5a28-4356-b684-1e639094ad24"
                    }
                  },
                  {
                    "textEquivalent" : "Clindamycine vaginale crème",
                    "_textEquivalent" : {
                      "extension" : [
                        {
                          "extension" : [
                            {
                              "url" : "lang",
                              "valueCode" : "fr-BE"
                            },
                            {
                              "url" : "content",
                              "valueString" : "Clindamycine crème vaginale"
                            }
                          ],
                          "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                        }
                      ]
                    },
                    "resource" : {
                      "reference" : "MedicationRequest/30551ce1-5a28-4356-b684-1e639094ad25"
                    }
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "extension" : [
                      {
                        "url" : "ratingType",
                        "valueCode" : "overall"
                      },
                      {
                        "url" : "ratingValue",
                        "valueRatio" : {
                          "numerator" : {
                            "value" : 1
                          },
                          "denominator" : {
                            "value" : 3
                          }
                        }
                      },
                      {
                        "url" : "ratingText",
                        "valueMarkdown" : "Niet aangewezen",
                        "_valueMarkdown" : {
                          "extension" : [
                            {
                              "extension" : [
                                {
                                  "url" : "lang",
                                  "valueCode" : "fr-BE"
                                },
                                {
                                  "url" : "content",
                                  "valueString" : "Pas approprié"
                                }
                              ],
                              "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                            }
                          ]
                        }
                      }
                    ],
                    "url" : "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSStructuredRating"
                  }
                ],
                "textEquivalent" : "Fluconazol Oraal",
                "_textEquivalent" : {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "lang",
                          "valueCode" : "fr-BE"
                        },
                        {
                          "url" : "content",
                          "valueString" : "Fluconazole orale"
                        }
                      ],
                      "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                    }
                  ]
                },
                "resource" : {
                  "reference" : "MedicationRequest/30551ce1-5a28-4356-b684-1e639094ad26"
                }
              },
              {
                "extension" : [
                  {
                    "extension" : [
                      {
                        "url" : "ratingType",
                        "valueCode" : "overall"
                      },
                      {
                        "url" : "ratingValue",
                        "valueRatio" : {
                          "numerator" : {
                            "value" : 1
                          },
                          "denominator" : {
                            "value" : 3
                          }
                        }
                      },
                      {
                        "url" : "ratingText",
                        "valueMarkdown" : "Niet aangewezen",
                        "_valueMarkdown" : {
                          "extension" : [
                            {
                              "extension" : [
                                {
                                  "url" : "lang",
                                  "valueCode" : "fr-BE"
                                },
                                {
                                  "url" : "content",
                                  "valueString" : "Pas approprié"
                                }
                              ],
                              "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                            }
                          ]
                        }
                      }
                    ],
                    "url" : "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSStructuredRating"
                  }
                ],
                "textEquivalent" : "Miconazol lokaal",
                "_textEquivalent" : {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "lang",
                          "valueCode" : "fr-BE"
                        },
                        {
                          "url" : "content",
                          "valueString" : "Miconazole localement"
                        }
                      ],
                      "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                    }
                  ]
                },
                "resource" : {
                  "reference" : "MedicationRequest/30551ce1-5a28-4356-b684-1e639094ad29"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:30551ce1-5a28-4356-b684-1e639094dd22",
      "resource" : {
        "resourceType" : "CommunicationRequest",
        "id" : "30551ce1-5a28-4356-b684-1e639094dd22",
        "meta" : {
          "profile" : [
            "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSResponseCommunicationRequest"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"CommunicationRequest_30551ce1-5a28-4356-b684-1e639094dd22\"> </a><p class=\"res-header-id\"><b>Generated Narrative: CommunicationRequest 30551ce1-5a28-4356-b684-1e639094dd22</b></p><a name=\"30551ce1-5a28-4356-b684-1e639094dd22\"> </a><a name=\"hc30551ce1-5a28-4356-b684-1e639094dd22\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-PSSResponseCommunicationRequest.html\">PSS Response Communication Request</a></p></div><p><b>status</b>: Active</p><p><b>subject</b>: <a href=\"Patient-30551ce1-5a28-4356-b684-2e639094ad48.html\"> Female, DoB Unknown</a></p><h3>Payloads</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Content[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><code>Markdown: </code><div><p>Antibioticum behandeling enkel bij storende klachten of bij verhoogd risico op vroeggeboorte. Metronidazol en clindamycine worden in de SKP afgeraden in het eerste trimester. De klinische gegevens omtrent gebruik tijdens het eerste trimester van de zwangerschap zijn nochtans geruststellend en de meeste bronnen geven aan dat het kan gebruikt worden.</p>\n</div></td></tr></table></div>"
        },
        "status" : "active",
        "subject" : {
          "reference" : "Patient/30551ce1-5a28-4356-b684-2e639094ad48"
        },
        "payload" : [
          {
            "_contentString" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/rendering-markdown",
                  "valueMarkdown" : "Antibioticum behandeling enkel bij storende klachten of bij verhoogd risico op vroeggeboorte. Metronidazol en clindamycine worden in de SKP afgeraden in het eerste trimester. De klinische gegevens omtrent gebruik tijdens het eerste trimester van de zwangerschap zijn nochtans geruststellend en de meeste bronnen geven aan dat het kan gebruikt worden.",
                  "_valueMarkdown" : {
                    "extension" : [
                      {
                        "extension" : [
                          {
                            "url" : "lang",
                            "valueCode" : "fr-BE"
                          },
                          {
                            "url" : "content",
                            "valueString" : "Traitement antibiotique uniquement en cas de symptômes dérangeants ou de risque accru de naissance prématurée. Le RCP déconseille l'utilisation du métronidazole et de la clindamycine pendant le premier trimestre de la grossesse. Les données cliniques concernant leur utilisation pendant le premier trimestre de grossesse sont pourtant rassurantes et la plupart des sources acceptent leur utilisation en période de grossesse."
                          }
                        ],
                        "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                      }
                    ]
                  }
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:30551ce1-5a28-4356-b684-1e639094ac23",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "30551ce1-5a28-4356-b684-1e639094ac23",
        "meta" : {
          "profile" : [
            "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSResponseMedicationRequest"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_30551ce1-5a28-4356-b684-1e639094ac23\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 30551ce1-5a28-4356-b684-1e639094ac23</b></p><a name=\"30551ce1-5a28-4356-b684-1e639094ac23\"> </a><a name=\"hc30551ce1-5a28-4356-b684-1e639094ac23\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-PSSResponseMedicationRequest.html\">PSS Response Medication Request</a></p></div><p><b>status</b>: Active</p><p><b>intent</b>: Proposal</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc J01XD01}, {https://www.ehealth.fgov.be/standards/fhir/medication/CodeSystem/vmpg 21436}\">metronidazole</span></p><p><b>subject</b>: <a href=\"Patient-30551ce1-5a28-4356-b684-2e639094ad48.html\"> Female, DoB Unknown</a></p><blockquote><p><b>dosageInstruction</b></p><p><b>text</b>: 1000 mg per dag in 2 giften gedurende 7 dagen</p><p><b>timing</b>: 2 per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>1000 mg</td></tr></table></blockquote></div>"
        },
        "status" : "active",
        "intent" : "proposal",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J01XD01"
            },
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/medication/CodeSystem/vmpg",
              "code" : "21436"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/30551ce1-5a28-4356-b684-2e639094ad48"
        },
        "dosageInstruction" : [
          {
            "text" : "1000 mg per dag in 2 giften gedurende 7 dagen",
            "_text" : {
              "extension" : [
                {
                  "extension" : [
                    {
                      "url" : "lang",
                      "valueCode" : "fr-BE"
                    },
                    {
                      "url" : "content",
                      "valueString" : "1000 mg par jour en 2 prises pendant 7 jours"
                    }
                  ],
                  "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                }
              ]
            },
            "timing" : {
              "repeat" : {
                "boundsDuration" : {
                  "value" : 7,
                  "system" : "http://unitsofmeasure.org",
                  "code" : "d"
                },
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 1000,
                  "unit" : "mg",
                  "system" : "http://unitsofmeasure.org"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:30551ce1-5a28-4356-b684-1e639094ad24",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "30551ce1-5a28-4356-b684-1e639094ad24",
        "meta" : {
          "profile" : [
            "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSResponseMedicationRequest"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_30551ce1-5a28-4356-b684-1e639094ad24\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 30551ce1-5a28-4356-b684-1e639094ad24</b></p><a name=\"30551ce1-5a28-4356-b684-1e639094ad24\"> </a><a name=\"hc30551ce1-5a28-4356-b684-1e639094ad24\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-PSSResponseMedicationRequest.html\">PSS Response Medication Request</a></p></div><p><b>status</b>: Active</p><p><b>intent</b>: Proposal</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc G01AA10}\">clindamycin</span></p><p><b>subject</b>: <a href=\"Patient-30551ce1-5a28-4356-b684-2e639094ad48.html\"> Female, DoB Unknown</a></p><blockquote><p><b>dosageInstruction</b></p><p><b>text</b>: ovule: 100 mg per dag in 1 gift gedurende 3 dagen OF vaginale crème: 2% 5 g per dag in 1 gift gedurende 7 dagen</p><p><b>timing</b>: Once per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>100 mg</td></tr></table></blockquote></div>"
        },
        "status" : "active",
        "intent" : "proposal",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "G01AA10"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/30551ce1-5a28-4356-b684-2e639094ad48"
        },
        "dosageInstruction" : [
          {
            "text" : "ovule: 100 mg per dag in 1 gift gedurende 3 dagen OF vaginale crème: 2% 5 g per dag in 1 gift gedurende 7 dagen",
            "_text" : {
              "extension" : [
                {
                  "extension" : [
                    {
                      "url" : "lang",
                      "valueCode" : "fr-BE"
                    },
                    {
                      "url" : "content",
                      "valueString" : "ovule : 100 mg par jour en 1 prise pendant 3 jours OU crème vaginale : 2 % 5 g par jour en 1 prise pendant 7 jours"
                    }
                  ],
                  "url" : "http://hl7.org/fhir/StructureDefinition/translation"
                }
              ]
            },
            "timing" : {
              "repeat" : {
                "boundsDuration" : {
                  "value" : 3,
                  "system" : "http://unitsofmeasure.org",
                  "code" : "d"
                },
                "frequency" : 1,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 100,
                  "unit" : "mg",
                  "system" : "http://unitsofmeasure.org"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:30551ce1-5a28-4356-b684-1e639094ad26",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "30551ce1-5a28-4356-b684-1e639094ad26",
        "meta" : {
          "profile" : [
            "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSResponseMedicationRequest"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_30551ce1-5a28-4356-b684-1e639094ad26\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 30551ce1-5a28-4356-b684-1e639094ad26</b></p><a name=\"30551ce1-5a28-4356-b684-1e639094ad26\"> </a><a name=\"hc30551ce1-5a28-4356-b684-1e639094ad26\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-PSSResponseMedicationRequest.html\">PSS Response Medication Request</a></p></div><p><b>status</b>: Active</p><p><b>intent</b>: Proposal</p><p><b>medication</b>: <span title=\"Codes:\">Fluconazol</span></p><p><b>subject</b>: <a href=\"Patient-30551ce1-5a28-4356-b684-2e639094ad48.html\"> Female, DoB Unknown</a></p></div>"
        },
        "status" : "active",
        "intent" : "proposal",
        "medicationCodeableConcept" : {
          "text" : "Fluconazol"
        },
        "subject" : {
          "reference" : "Patient/30551ce1-5a28-4356-b684-2e639094ad48"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:30551ce1-5a28-4356-b684-1e639094ad29",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "30551ce1-5a28-4356-b684-1e639094ad29",
        "meta" : {
          "profile" : [
            "https://www.ehealth.fgov.be/standards/fhir/pss/StructureDefinition/PSSResponseMedicationRequest"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_30551ce1-5a28-4356-b684-1e639094ad29\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 30551ce1-5a28-4356-b684-1e639094ad29</b></p><a name=\"30551ce1-5a28-4356-b684-1e639094ad29\"> </a><a name=\"hc30551ce1-5a28-4356-b684-1e639094ad29\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-PSSResponseMedicationRequest.html\">PSS Response Medication Request</a></p></div><p><b>status</b>: Active</p><p><b>intent</b>: Proposal</p><p><b>medication</b>: <span title=\"Codes:\">Miconazol</span></p><p><b>subject</b>: <a href=\"Patient-30551ce1-5a28-4356-b684-2e639094ad48.html\"> Female, DoB Unknown</a></p></div>"
        },
        "status" : "active",
        "intent" : "proposal",
        "medicationCodeableConcept" : {
          "text" : "Miconazol"
        },
        "subject" : {
          "reference" : "Patient/30551ce1-5a28-4356-b684-2e639094ad48"
        }
      }
    }
  ]
}

```
