# Home - Medication v1.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/medication/ImplementationGuide/hl7.fhir.be.medication | *Version*:1.1.0 |
| Active as of 2025-09-26 | *Computable Name*:Medication |

This is the specification for the Medication CareSet, developed by the HL7 Belgium community. It includes the following parts:

* Medication Dispense
* Medication Line
* Medication Prescription

### Use of MUST, SHOULD, MAY

The key words “MUST”, “MUST NOT”, “REQUIRED”, “SHALL”, “SHALL NOT”, “SHOULD”, “SHOULD NOT”, “RECOMMENDED”, “MAY”, and “OPTIONAL” in this document are to be interpreted as described in RFC 2119:

1. **MUST**, or the terms**“REQUIRED”**or**“SHALL”**, mean that the definition is an absolute requirement of the specification.
1. **MUST NOT**, or the phrase**“SHALL NOT”**, mean that the definition is an absolute prohibition of the specification.
1. **SHOULD**, or the adjective**“RECOMMENDED”**, mean that there may exist valid reasons in particular circumstances to ignore a particular item, but the full implications must be understood and carefully weighed before choosing a different course.
1. **SHOULD NOT**, or the phrase**“NOT RECOMMENDED”**mean that there may exist valid reasons in particular circumstances when the particular behaviour is acceptable or even useful, but the full implications should be understood and the case carefully weighed before implementing any behaviour described with this label.
1. **MAY**, or the adjective**“OPTIONAL”**, mean that an item is truly optional. One vendor may choose to include the item because a particular marketplace requires it or because the vendor feels that it enhances the product while another vendor may omit the same item. An implementation which does not include a particular option MUST be prepared to interoperate with another implementation which does include the option, though perhaps with reduced functionality. In the same vein an implementation which does include a particular option MUST be prepared to interoperate with another implementation which does not include the option (except, of course, for the feature the option provides.)

### Must Support

Unless otherwise stated, the following criteria apply to elements marked as “Must Support” in this Implementation Guide:

#### For technical profiles

**Systems supporting the profile MUST NOT ignore the element**.

* Systems receiving or consuming a resource instance: 
* MUST be able to process the element’s content when it is present
* MUST process the content according to the rules defined for the profile
* MUST NOT fail when the value is not present.
 
* Systems sending or creating a resource instance 
* SHOULD populate the element when the information is available
* MUST populate the element according to the rules defined for the profile
 

#### For Logical Models

* **Functional Analysis MUST consider the data element as defined** 
* “Must Support” elements that are used in an implementation MUST inherit the behaviour and constraints defined for the data element
* “Must Support” elements not needed in a particular implementation MAY be excluded from implementation but such exclusion MUST be described
 
* **Derived implementations SHOULD inherit the field’s “Must Support” flag**

### Dependencies

This IG Contains the following dependencies on other IGs.





### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.be.medication.r4)](package.r4.tgz) and [R4B (hl7.fhir.be.medication.r4b)](package.r4b.tgz) are available. 

### Global Profiles

*There are no Global profiles defined*

### Intellectual Property

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.0.2/CodeSystem-ISO3166Part1.html): [BasedOnMedicationLine](StructureDefinition-BasedOnMedicationLine.md), [BeDosage](StructureDefinition-BeDosage.md)...Show 37 more,[BeExtAdherenceStatus](StructureDefinition-BeExtAdherenceStatus.md),[BeExtInstructionsForReimbursement](StructureDefinition-BeExtInstructionsForReimbursement.md),[BeExtMedicationLineRegistrationStatus](StructureDefinition-BeExtMedicationLineRegistrationStatus.md),[BeExtMedicationType](StructureDefinition-BeExtMedicationType.md),[BeExtOffLabel](StructureDefinition-BeExtOffLabel.md),[BeExtRecordedDate](StructureDefinition-BeExtRecordedDate.md),[BeExtRecorder](StructureDefinition-BeExtRecorder.md),[BeMedicationDispense](StructureDefinition-BeMedicationDispense.md),[BeMedicationExposureCategory](StructureDefinition-BeMedicationExposureCategory.md),[BeMedicationExposureIntentVS](ValueSet-BeMedicationExposureIntentVS.md),[BeMedicationLine](StructureDefinition-BeMedicationLine.md),[BeMedicationLineAdherenceStatus](CodeSystem-BeMedicationLineAdherenceStatus.md),[BeMedicationLineAdherenceStatusReason](CodeSystem-BeMedicationLineAdherenceStatusReason.md),[BeMedicationLineAdherenceStatusReasonVS](ValueSet-BeMedicationLineAdherenceStatusReasonVS.md),[BeMedicationLineAdherenceStatusVS](ValueSet-BeMedicationLineAdherenceStatusVS.md),[BeMedicationLineOriginType](CodeSystem-BeMedicationLineOriginType.md),[BeMedicationLineOriginTypeVS](ValueSet-BeMedicationLineOriginTypeVS.md),[BeMedicationLineRegistrationStatus](CodeSystem-BeMedicationLineRegistrationStatus.md),[BeMedicationLineRegistrationStatusVS](ValueSet-BeMedicationLineRegistrationStatusVS.md),[BeMedicationPrescription](StructureDefinition-BeMedicationPrescription.md),[BeMedicationPrescriptionStatusVS](ValueSet-BeMedicationPrescriptionStatusVS.md),[BeMedicationRequestReimbursementType](CodeSystem-BeMedicationRequestReimbursementType.md),[BeMedicationRequestReimbursementTypeVS](ValueSet-BeMedicationRequestReimbursementTypeVS.md),[BeMedicationType](CodeSystem-BeMedicationType.md),[BeMedicationTypeVS](ValueSet-BeMedicationTypeVS.md),[BeModelDosagingInformation](StructureDefinition-BeModelDosagingInformation.md),[BeModelMedication](StructureDefinition-BeModelMedication.md),[BeModelMedicationDispense](StructureDefinition-BeModelMedicationDispense.md),[BeModelMedicationPrescription](StructureDefinition-BeModelMedicationPrescription.md),[BeNSCNK](NamingSystem-be-ns-cnk-codes.md),[BeNSCTIExtended](NamingSystem-be-ns-cti-extended-code.md),[BeNSPrescriptions](NamingSystem-be-ns-prescription-ids.md),[BeNSProductPackage](NamingSystem-be-ns-product-package-type.md),[BeRouteOfAdministrationVS](ValueSet-BeRouteOfAdministrationVS.md),[DispenserTypes](ValueSet-be-vs-dispenser-types.md),[Medication](index.md)and[MedicationLine](StructureDefinition-BeModelMedicationLine.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.0.2/CodeSystem-v3-ucum.html): [MedicationDispense/example-dispense-hospital](MedicationDispense-example-dispense-hospital.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [BeDosage](StructureDefinition-BeDosage.md), [BeMedicationDispense](StructureDefinition-BeMedicationDispense.md)...Show 5 more,[BeMedicationExposureCategory](StructureDefinition-BeMedicationExposureCategory.md),[BeMedicationExposureIntentVS](ValueSet-BeMedicationExposureIntentVS.md),[BeModelDosagingInformation](StructureDefinition-BeModelDosagingInformation.md),[BeRouteOfAdministrationVS](ValueSet-BeRouteOfAdministrationVS.md)and[MedicationLine](StructureDefinition-BeModelMedicationLine.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.be.medication",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/medication/ImplementationGuide/hl7.fhir.be.medication",
  "version" : "1.1.0",
  "name" : "Medication",
  "title" : "Medication",
  "status" : "active",
  "date" : "2025-09-26",
  "publisher" : "eHealth Platform",
  "contact" : [
    {
      "name" : "eHealth Platform",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ehealth.fgov.be/standards/fhir"
        },
        {
          "system" : "email",
          "value" : "support@be-ehealth-standards.atlassian.net"
        }
      ]
    },
    {
      "name" : "Message Structure eHealth",
      "telecom" : [
        {
          "system" : "email",
          "value" : "support@be-ehealth-standards.atlassian.net",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "FHIR Medication specifications",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.be.medication",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_be_core",
      "uri" : "https://www.ehealth.fgov.be/standards/fhir/core/ImplementationGuide/hl7.fhir.be.core",
      "packageId" : "hl7.fhir.be.core",
      "version" : "2.1.2"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2021+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url-base"
          },
          {
            "url" : "value",
            "valueString" : "https://www.ehealth.fgov.be/standards/fhir/terminology"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://www.ehealth.fgov.be/standards/fhir/medication/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2021+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url-base"
          },
          {
            "url" : "value",
            "valueString" : "https://www.ehealth.fgov.be/standards/fhir/terminology"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://www.ehealth.fgov.be/standards/fhir/medication/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "LogicalModels",
        "name" : "Logical Data Models",
        "description" : "Logical data models. The Logical data models are representations of the data needs for the scope of this Implementation Guide. The data models are primarily aligned with key projects, namely VIDIS, but are prepared in coordination with the Belgian community to ensure a common data structure that supports the projects and the implementation data needs."
      },
      {
        "id" : "Profiles",
        "name" : "Profiles",
        "description" : "Profiles for Medication. These are implementable FHIR profiles."
      },
      {
        "id" : "Extensions",
        "name" : "Extensions",
        "description" : "Extensions for FHIR resources, to be used in Profiles"
      },
      {
        "id" : "Terminology",
        "name" : "Terminology",
        "description" : "Terminology for Medication. These are value sets, code systems and naming systems for identifiers."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/BeMedicationLineAdherenceStatusReason"
        },
        "name" : "Adherence Status Reason",
        "description" : "Reasons for non-adherence to a treatment or intervention.",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/BeMedicationLineAdherenceStatusReasonVS"
        },
        "name" : "Adherence Status Reason ValueSet",
        "description" : "ValueSet containing reasons for non-adherence to a treatment or intervention.",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/apotheek-onder-de-toren"
        },
        "name" : "apotheek-onder-de-toren",
        "description" : "Example organization for a pharmacy",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BasedOnMedicationLine"
        },
        "name" : "BasedOnMedicationLine",
        "description" : "Based on medication line.",
        "exampleBoolean" : false,
        "groupingId" : "Extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/be-ns-cnk-codes"
        },
        "name" : "be-ns-cnk-codes",
        "description" : "Naming System - CNK Product Codes",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/be-ns-cti-extended-code"
        },
        "name" : "be-ns-cti-extended-code",
        "description" : "Naming System - CTI Extended Codes",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/be-ns-prescription-ids"
        },
        "name" : "be-ns-prescription-ids",
        "description" : "Naming System - Prescription IDs",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NamingSystem"
          }
        ],
        "reference" : {
          "reference" : "NamingSystem/be-ns-product-package-type"
        },
        "name" : "be-ns-product-package-type",
        "description" : "Naming System - Prescription IDs",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeExtAdherenceStatus"
        },
        "name" : "BeExtAdherenceStatus",
        "description" : "Medication Line Adherence Status - statuses of taking the medication.",
        "exampleBoolean" : false,
        "groupingId" : "Extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/BeMedicationLineAdherenceStatusVS"
        },
        "name" : "BeExtAdherenceStatus",
        "description" : "The status of taking the medication.",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeExtInstructionsForReimbursement"
        },
        "name" : "BeExtInstructionsForReimbursement",
        "description" : "Instructions for Reimbursement.",
        "exampleBoolean" : false,
        "groupingId" : "Extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeExtMedicationType"
        },
        "name" : "BeExtMedicationType",
        "description" : "The type of medication.",
        "exampleBoolean" : false,
        "groupingId" : "Extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeExtRecordedDate"
        },
        "name" : "BeExtRecordedDate",
        "description" : "The date the information was recorded",
        "exampleBoolean" : false,
        "groupingId" : "Extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeExtRecorder"
        },
        "name" : "BeExtRecorder",
        "description" : "The person that recorded the information",
        "exampleBoolean" : false,
        "groupingId" : "Extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeMedicationDispense"
        },
        "name" : "BeMedicationDispense",
        "description" : "Defines constraints and extensions on the Medication Dispense resource for a record of a dispensation in Belgium.",
        "exampleBoolean" : false,
        "groupingId" : "Profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeMedicationExposureCategory"
        },
        "name" : "BeMedicationExposureCategory",
        "description" : "Exposure - category.",
        "exampleBoolean" : false,
        "groupingId" : "Extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeMedicationLine"
        },
        "name" : "BeMedicationLine",
        "description" : "Medication Line profile - contains the overview information for a single medication item",
        "exampleBoolean" : false,
        "groupingId" : "Profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeMedicationPrescription"
        },
        "name" : "BeMedicationPrescription",
        "description" : "Medication Request profile - The common structure for medication request",
        "exampleBoolean" : false,
        "groupingId" : "Profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/be-vs-dispenser-types"
        },
        "name" : "Dispenser Types",
        "description" : "Dispenser Types - from hcparty",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeModelDosagingInformation"
        },
        "name" : "Dosaging (model)",
        "description" : "Structured Dosage data model.",
        "exampleBoolean" : false,
        "groupingId" : "LogicalModels"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/example-minimal-dispense"
        },
        "name" : "Example Dispense (minimal)",
        "description" : "Dispense Example - Minimal amount of information",
        "exampleCanonical" : "https://www.ehealth.fgov.be/standards/fhir/medication/StructureDefinition/BeMedicationDispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/medicationdispense-example-1"
        },
        "name" : "Example Dispense (simple)",
        "description" : "Dispense Example - Simple example of a dispense",
        "exampleCanonical" : "https://www.ehealth.fgov.be/standards/fhir/medication/StructureDefinition/BeMedicationDispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/medicationdispense-example-2"
        },
        "name" : "Example Dispense entry - Community Pharmacy dispense, from prescription, with contained org.",
        "description" : "Medication Dispense example",
        "exampleCanonical" : "https://www.ehealth.fgov.be/standards/fhir/medication/StructureDefinition/BeMedicationDispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/example-dispense-hospital"
        },
        "name" : "Example Dispense from a hospital pharmacy",
        "description" : "A dispense from a hospital pharmacy, with a hospital nihdi and based on a prescription",
        "exampleCanonical" : "https://www.ehealth.fgov.be/standards/fhir/medication/StructureDefinition/BeMedicationDispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeModelMedication"
        },
        "name" : "Medication (model)",
        "description" : "Logical data model for medication.",
        "exampleBoolean" : false,
        "groupingId" : "LogicalModels"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeModelMedicationDispense"
        },
        "name" : "Medication Dispense (model)",
        "description" : "This is the logical model for the Dispense Record entry - the information that can be captured upon the act of dispensing - in a hospital pharmacy, or a community pharmacy. This is not for a future dispense, rather a record of an actual dispense.",
        "exampleBoolean" : false,
        "groupingId" : "LogicalModels"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/example-dispense-communitypharmacy-1med"
        },
        "name" : "Medication Dispense example",
        "description" : "Dispense entry Example - Community Pharmacy dispense, from prescription",
        "exampleCanonical" : "https://www.ehealth.fgov.be/standards/fhir/medication/StructureDefinition/BeMedicationDispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeDosage"
        },
        "name" : "Medication Dosage",
        "description" : "Specifications for a medication dosage for use in Belgian profiles.",
        "exampleBoolean" : false,
        "groupingId" : "Profiles"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/BeMedicationExposureIntentVS"
        },
        "name" : "Medication exposure intent",
        "description" : "The exposure purpose of a medication - whether the medication is given for therapeutic or prophylactic purposes.",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeModelMedicationLine"
        },
        "name" : "Medication Line (model)",
        "description" : "Logical data model for medication line.",
        "exampleBoolean" : false,
        "groupingId" : "LogicalModels"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/BeMedicationLineAdherenceStatus"
        },
        "name" : "Medication Line Adherence Status",
        "description" : "Medication Line Adherence Status - ValueSet.",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeExtMedicationLineRegistrationStatus"
        },
        "name" : "Medication Line Registration Status",
        "description" : "This extension indicates the registration status of a medication line, such as whether it is draft, recorded, or entered-in-error.",
        "exampleBoolean" : false,
        "groupingId" : "Extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/BeMedicationLineRegistrationStatus"
        },
        "name" : "Medication Line Registration Status",
        "description" : "This code system defines the registration statuses for medication lines.",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/BeMedicationLineRegistrationStatusVS"
        },
        "name" : "Medication Line Registration Status Value Set",
        "description" : "This value set includes the registration statuses for medication lines.",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/BeMedicationLineOriginType"
        },
        "name" : "Medication origin Type",
        "description" : "Medication origin type",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/BeMedicationLineOriginTypeVS"
        },
        "name" : "Medication origin type value set",
        "description" : "Medication origin type value set",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/BeMedicationType"
        },
        "name" : "Medication preparation Type",
        "description" : "Medication preparation type",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/BeMedicationTypeVS"
        },
        "name" : "Medication preparation Type value set",
        "description" : "Medication preparation type value set",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeModelMedicationPrescription"
        },
        "name" : "Medication prescription (model)",
        "description" : "Logical model for medication prescription (or some other form of order)",
        "exampleBoolean" : false,
        "groupingId" : "LogicalModels"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/BeMedicationPrescriptionStatusVS"
        },
        "name" : "Medication Prescription Status",
        "description" : "Medication prescription status codes.",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/BeMedicationRequestReimbursementType"
        },
        "name" : "Medication request reimbursement type",
        "description" : "Medication request reimbursement type - instructions for reimbursement of the medication request",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/BeMedicationRequestReimbursementTypeVS"
        },
        "name" : "Medication request reimbursement type ValueSet",
        "description" : "Medication request reimbursement type - instructions for reimbursement of the medication request",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BeExtOffLabel"
        },
        "name" : "MedicationRequest - Off-label use",
        "description" : "Indicates that the order placer has knowingly prescribed the medication for an indication, age group, dosage, or route of administration that is not approved by the regulatory agencies and is not mentioned in the prescribing information for the product.",
        "exampleBoolean" : false,
        "groupingId" : "Extensions"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/BeRouteOfAdministrationVS"
        },
        "name" : "Route of Administration ValueSet",
        "description" : "This ValueSet contains codes for the route of administration of medications. It is used to specify how a medication is administered to a patient, such as orally, intravenously, or topically.",
        "exampleBoolean" : false,
        "groupingId" : "Terminology"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "medicationrecord.html"
            }
          ],
          "nameUrl" : "medicationrecord.html",
          "title" : "Belgian Medication Record overview",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "definitions.html"
            }
          ],
          "nameUrl" : "definitions.html",
          "title" : "Definitions",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "usecases-medicationrecord.html"
            }
          ],
          "nameUrl" : "usecases-medicationrecord.html",
          "title" : "Medication Record - Use cases",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "medicationrecord-scenarios.html"
            }
          ],
          "nameUrl" : "medicationrecord-scenarios.html",
          "title" : "Medication Record - Extended scenarios",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "usecases-dispense.html"
            }
          ],
          "nameUrl" : "usecases-dispense.html",
          "title" : "Dispense - Use cases",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "howto.html"
            }
          ],
          "nameUrl" : "howto.html",
          "title" : "How to read this specification",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "html"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
