# hl7.fhir.be.core-clinical#1.0.1: HL7 FHIR Implementation Guide: Transversal Clinical Core

## Pages

* [Transversal Clinical Core](index.md)
* [Spec](spec.md)
* [Downloads](downloads.md)
* [Artifacts Summary](artifacts.md)
* [Guidance](guidance.md)
* [Changes](changes.md)

## Resources

### CodeSystems

* [Body Site CodeSystem](CodeSystem-be-cs-bodysite.md)
* [Problem Category](CodeSystem-be-cs-problem-category.md)
* [Problem Origin Type](CodeSystem-be-cs-problem-origin-type.md)
* [Score Category](CodeSystem-be-cs-score-category.md)
* [Score Code System](CodeSystem-be-cs-score.md)

### ValueSets

* [Body Site](ValueSet-be-vs-bodysite.md)
* [Laterality](ValueSet-be-vs-laterality.md)
* [Problem Category](ValueSet-be-vs-problem-category.md)
* [Problem Code](ValueSet-be-vs-problem-code.md)
* [Problem Origin Type](ValueSet-be-vs-problem-origin-type.md)
* [Reaction Manifestation Code](ValueSet-be-vs-reaction-manifestation-code.md)
* [Score Value Set](ValueSet-be-vs-score.md)
* [Score Category Value Set](ValueSet-be-vs-scorecategory.md)

### Logicals

* [BeModelAppointment](StructureDefinition-BeModelAppointment.md)
* [BeModelCarePlan](StructureDefinition-BeModelCarePlan.md)
* [BeModelClinicalImpression](StructureDefinition-BeModelClinicalImpression.md)
* [BeModelEncounter](StructureDefinition-BeModelEncounter.md)
* [BeModelGoal](StructureDefinition-BeModelGoal.md)
* [BeModelServiceRequest](StructureDefinition-BeModelServiceRequest.md)
* [BodySite Model](StructureDefinition-be-model-bodysite.md)
* [BeObservation Model](StructureDefinition-be-model-observation.md)

### Complex-type Profiles

* [BeObservationCodeableConcept](StructureDefinition-be-observationcodeableconcept.md)

### Resource Profiles

* [BeCarePlan](StructureDefinition-BeCarePlan.md)
* [BeClinicalImpression](StructureDefinition-BeClinicalImpression.md)
* [BeGoal](StructureDefinition-BeGoal.md)
* [BeEncounter](StructureDefinition-be-encounter.md)
* [BeObservation](StructureDefinition-be-observation.md)
* [BeProblem](StructureDefinition-be-problem.md)
* [BeProcedure](StructureDefinition-be-procedure.md)
* [BeQuestionnaireResponse](StructureDefinition-be-questionnaire-response.md)
* [BeScoreResult](StructureDefinition-be-scoreresult.md)
* [BeServiceRequest](StructureDefinition-be-service-request.md)

### Extensions

* [BeExtLaterality](StructureDefinition-be-ext-laterality.md)
* [BeExtProblemOriginType](StructureDefinition-be-ext-problem-origin-type.md)

### ImplementationGuides

* [HL7 FHIR Implementation Guide: Transversal Clinical Core](index.md)

### Examples

* [terminology-expansion (Parameters)](Parameters-terminology-expansion.md)
