# BeObservation Model - HL7 FHIR Implementation Guide: Transversal Clinical Core v1.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeObservation Model**

## Logical Model: BeObservation Model 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/core-clinical/StructureDefinition/be-model-observation | *Version*:1.0.1 |
| Active as of 2025-10-16 | *Computable Name*:BeModelObservation |

 
Observation logical model 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.core-clinical|current/StructureDefinition/be-model-observation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-model-observation.csv), [Excel](StructureDefinition-be-model-observation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-model-observation",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/core-clinical/StructureDefinition/be-model-observation",
  "version" : "1.0.1",
  "name" : "BeModelObservation",
  "title" : "BeObservation Model",
  "status" : "active",
  "date" : "2025-10-16T07:22:44+00:00",
  "publisher" : "eHealth Platform",
  "contact" : [
    {
      "name" : "eHealth Platform",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ehealth.fgov.be"
        },
        {
          "system" : "email",
          "value" : "message-structure@www.ehealth.fgov.be"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@www.ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Observation logical model",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://www.ehealth.fgov.be/standards/fhir/core-clinical/StructureDefinition/be-model-observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "be-model-observation",
        "path" : "be-model-observation",
        "short" : "BeObservation Model",
        "definition" : "Observation logical model"
      },
      {
        "id" : "be-model-observation.identifier",
        "path" : "be-model-observation.identifier",
        "short" : "Unique identifier for the observation",
        "definition" : "Unique identifier for the observation",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "be-model-observation.recordedDate",
        "path" : "be-model-observation.recordedDate",
        "short" : "Date when the observation was recorded",
        "definition" : "Date when the observation was recorded",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "be-model-observation.observationDate[x]",
        "path" : "be-model-observation.observationDate[x]",
        "short" : "Date or period of the observation",
        "definition" : "Date or period of the observation",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "be-model-observation.recorder",
        "path" : "be-model-observation.recorder",
        "short" : "Person, organisation or device that recorded the observation",
        "definition" : "Person, organisation or device that recorded the observation",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "be-model-observation.performer",
        "path" : "be-model-observation.performer",
        "short" : "The professional that performed the observation",
        "definition" : "The professional that performed the observation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "be-model-observation.patient",
        "path" : "be-model-observation.patient",
        "short" : "The patient that this observation is about",
        "definition" : "The patient that this observation is about",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "be-model-observation.request",
        "path" : "be-model-observation.request",
        "short" : "The request that this observation is fulfilling",
        "definition" : "The request that this observation is fulfilling",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "be-model-observation.partOfProcedure",
        "path" : "be-model-observation.partOfProcedure",
        "short" : "Part of referenced procedure",
        "definition" : "Part of referenced procedure",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "be-model-observation.specimen",
        "path" : "be-model-observation.specimen",
        "short" : "The specimen that was used when this observation was made",
        "definition" : "The specimen that was used when this observation was made",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "be-model-observation.device",
        "path" : "be-model-observation.device",
        "short" : "The device used to generate the observation data",
        "definition" : "The device used to generate the observation data",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      },
      {
        "id" : "be-model-observation.category",
        "path" : "be-model-observation.category",
        "short" : "A code that classifies the general type of observation being made",
        "definition" : "A code that classifies the general type of observation being made",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "be-model-observation.code",
        "path" : "be-model-observation.code",
        "short" : "Describes what was observed. Sometimes this is called the observation 'name'",
        "definition" : "Describes what was observed. Sometimes this is called the observation 'name'",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "be-model-observation.value[x]",
        "path" : "be-model-observation.value[x]",
        "short" : "The value of the observation - typically a code, an amount or a date",
        "definition" : "The value of the observation - typically a code, an amount or a date",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          },
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "string"
          },
          {
            "code" : "boolean"
          },
          {
            "code" : "integer"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "Ratio"
          },
          {
            "code" : "time"
          },
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "be-model-observation.component",
        "path" : "be-model-observation.component",
        "short" : "Some observations have multiple component observations",
        "definition" : "Some observations have multiple component observations",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "be-model-observation.component.code",
        "path" : "be-model-observation.component.code",
        "short" : "Describes what was observed.",
        "definition" : "Describes what was observed.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "be-model-observation.component.value[x]",
        "path" : "be-model-observation.component.value[x]",
        "short" : "The value of the component observation - typically a code, an amount or a date",
        "definition" : "The value of the component observation - typically a code, an amount or a date",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          },
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "string"
          },
          {
            "code" : "boolean"
          },
          {
            "code" : "integer"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "Ratio"
          },
          {
            "code" : "time"
          },
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "be-model-observation.status",
        "path" : "be-model-observation.status",
        "short" : "The status of the result value.",
        "definition" : "The status of the result value.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "be-model-observation.interpretation",
        "path" : "be-model-observation.interpretation",
        "short" : "A categorical assessment of an observation value",
        "definition" : "A categorical assessment of an observation value",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "be-model-observation.referenceRange",
        "path" : "be-model-observation.referenceRange",
        "short" : "Guidance on how to interpret the value by comparison to a normal or recommended range",
        "definition" : "Guidance on how to interpret the value by comparison to a normal or recommended range",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "be-model-observation.referenceRange.low",
        "path" : "be-model-observation.referenceRange.low",
        "short" : "Low Range, if relevant",
        "definition" : "Low Range, if relevant",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "be-model-observation.referenceRange.high",
        "path" : "be-model-observation.referenceRange.high",
        "short" : "High Range, if relevant",
        "definition" : "High Range, if relevant",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "be-model-observation.bodySite",
        "path" : "be-model-observation.bodySite",
        "short" : "The site on the subject's body where the observation was made (i.e. the target site)",
        "definition" : "The site on the subject's body where the observation was made (i.e. the target site)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://www.ehealth.fgov.be/standards/fhir/core-clinical/StructureDefinition/be-model-bodysite"
          }
        ]
      },
      {
        "id" : "be-model-observation.certainty",
        "path" : "be-model-observation.certainty",
        "short" : "A subjective assessment of the quality of the observation",
        "definition" : "A subjective assessment of the quality of the observation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "be-model-observation.note",
        "path" : "be-model-observation.note",
        "short" : "Comments about the observation or the results",
        "definition" : "Comments about the observation or the results",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Annotation"
          }
        ]
      }
    ]
  }
}

```
