# BodySite Model - HL7 FHIR Implementation Guide: Transversal Clinical Core v1.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BodySite Model**

## Logical Model: BodySite Model 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/core-clinical/StructureDefinition/be-model-bodysite | *Version*:1.0.1 |
| Active as of 2025-10-16 | *Computable Name*:BeModelBodySite |

 
Body site model 

**Usages:**

* Use this Logical Model: [BeObservation Model](StructureDefinition-be-model-observation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.core-clinical|current/StructureDefinition/be-model-bodysite)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-model-bodysite.csv), [Excel](StructureDefinition-be-model-bodysite.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-model-bodysite",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/core-clinical/StructureDefinition/be-model-bodysite",
  "version" : "1.0.1",
  "name" : "BeModelBodySite",
  "title" : "BodySite Model",
  "status" : "active",
  "date" : "2025-10-16T07:22:44+00:00",
  "publisher" : "eHealth Platform",
  "contact" : [
    {
      "name" : "eHealth Platform",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ehealth.fgov.be"
        },
        {
          "system" : "email",
          "value" : "message-structure@www.ehealth.fgov.be"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@www.ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Body site model",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://www.ehealth.fgov.be/standards/fhir/core-clinical/StructureDefinition/be-model-bodysite",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "be-model-bodysite",
        "path" : "be-model-bodysite",
        "short" : "BodySite Model",
        "definition" : "Body site model"
      },
      {
        "id" : "be-model-bodysite.bodyLocation",
        "path" : "be-model-bodysite.bodyLocation",
        "short" : "Code that identifies the anatomical location of the specimen on the subject's body",
        "definition" : "Code that identifies the anatomical location of the specimen on the subject's body",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "be-model-bodysite.bodyLaterality",
        "path" : "be-model-bodysite.bodyLaterality",
        "short" : "The laterality of a body site - the side of the body",
        "definition" : "The laterality of a body site - the side of the body",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "be-model-bodysite.bodyTopography",
        "path" : "be-model-bodysite.bodyTopography",
        "short" : "The topography of the location of the specimen on the subject's body",
        "definition" : "The topography of the location of the specimen on the subject's body",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
