# Bundle - No Known X - AU Patient Summary Implementation Guide v0.6.0-cibuild

* [**Table of Contents**](toc.md)
* [**FHIR artefacts**](artefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Bundle - No Known X**

## Example Bundle: Bundle - No Known X



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "aups-noknownx",
  "meta" : {
    "profile" : ["http://hl7.org.au/fhir/ps/StructureDefinition/au-ps-bundle"]
  },
  "language" : "en-AU",
  "identifier" : {
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:uuid:c1b07c4e-7a7a-4711-93e2-9a589b8c87e0"
  },
  "type" : "document",
  "timestamp" : "2025-05-14T08:17:43.912+10:00",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:63b319ec-7321-4a70-973b-2cead2b28c28",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "63b319ec-7321-4a70-973b-2cead2b28c28",
        "meta" : {
          "profile" : [
            "http://hl7.org.au/fhir/ps/StructureDefinition/au-ps-composition"
          ]
        },
        "language" : "en-AU",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-AU\" lang=\"en-AU\"><a name=\"Composition_63b319ec-7321-4a70-973b-2cead2b28c28\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition 63b319ec-7321-4a70-973b-2cead2b28c28</b></p><a name=\"63b319ec-7321-4a70-973b-2cead2b28c28\"> </a><a name=\"hc63b319ec-7321-4a70-973b-2cead2b28c28\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Language: en-AU</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-au-ps-composition.html\">AU PS Composition</a></p></div><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 60591-5}\">Patient summary Document</span></p><p><b>date</b>: 2025-05-14</p><p><b>author</b>: <a href=\"Bundle-aups-noknownx.html#urn-uuid-719de42c-3b25-45d6-b24f-ebec9a753175\">PractitionerRole Diagnostic and Interventional Radiologist</a></p><p><b>title</b>: Australian Patient Summary</p><p><b>custodian</b>: <a href=\"Bundle-aups-noknownx.html#urn-uuid-abfb35a4-7b89-46d1-be21-dec293999a1b\">Organization Douglas Radiology</a></p></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:03b8cc8a-df59-4daf-b9f2-8b49d3c7579a"
        },
        "date" : "2025-05-14",
        "author" : [
          {
            "reference" : "urn:uuid:719de42c-3b25-45d6-b24f-ebec9a753175"
          }
        ],
        "title" : "Australian Patient Summary",
        "custodian" : {
          "reference" : "urn:uuid:abfb35a4-7b89-46d1-be21-dec293999a1b"
        },
        "section" : [
          {
            "title" : "Active Problems",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list - Reported"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-AU\" lang=\"en-AU\">30/03/2025 No current problem or disability</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:df366c47-c739-4c16-939e-b5cf9afb0b7d"
              }
            ]
          },
          {
            "title" : "Active Allergies or Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-AU\" lang=\"en-AU\">10/12/2024 No known allergy</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:9840a67e-3621-470d-9a7c-e559422591f5"
              }
            ]
          },
          {
            "title" : "Current Medicines",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "History of Medication use Narrative"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-AU\" lang=\"en-AU\">14/05/2025 No known current medicines</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:0fc878c1-a158-425f-ba08-ea4366fbb4e1"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:03b8cc8a-df59-4daf-b9f2-8b49d3c7579a",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "03b8cc8a-df59-4daf-b9f2-8b49d3c7579a",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_03b8cc8a-df59-4daf-b9f2-8b49d3c7579a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 03b8cc8a-df59-4daf-b9f2-8b49d3c7579a</b></p><a name=\"03b8cc8a-df59-4daf-b9f2-8b49d3c7579a\"> </a><a name=\"hc03b8cc8a-df59-4daf-b9f2-8b49d3c7579a\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Charlotte MORRIS  Female, DoB: 1994-11-11 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314687)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li>ph: 0370106762(Work)</li><li>ph: 0491577644(Mobile)</li><li><a href=\"mailto:charlotte.morris@my-own-personal-domain.com\">charlotte.morris@my-own-personal-domain.com</a></li><li>ph: 0370103886(Home)</li><li>175 Zeppelin Ave Mountain View VIC 3988 AU </li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"This extension applies to the Patient, Person, and RelatedPerson resources and is used to indicate whether a person identifies as being of Aboriginal or Torres Strait Islander origin.\"><a href=\"https://build.fhir.org/ig/hl7au/au-fhir-base/StructureDefinition-indigenous-status.html\">Australian Indigenous Status</a></td><td colspan=\"3\">australian-indigenous-status-1: 1 (Aboriginal but not Torres Strait Islander origin)</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org.au/fhir/StructureDefinition/indigenous-status",
            "valueCoding" : {
              "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
              "code" : "1",
              "display" : "Aboriginal but not Torres Strait Islander origin"
            }
          }
        ],
        "identifier" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-status",
                "valueCoding" : {
                  "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-status-1",
                  "code" : "active"
                }
              },
              {
                "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-record-status",
                "valueCoding" : {
                  "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-record-status-1",
                  "code" : "verified",
                  "display" : "verified"
                }
              }
            ],
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NI"
                }
              ],
              "text" : "IHI"
            },
            "system" : "http://ns.electronichealth.net.au/id/hi/ihi/1.0",
            "value" : "8003608500314687"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "MORRIS",
            "given" : ["Charlotte"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0370106762",
            "use" : "work"
          },
          {
            "system" : "phone",
            "value" : "0491577644",
            "use" : "mobile"
          },
          {
            "system" : "email",
            "value" : "charlotte.morris@my-own-personal-domain.com"
          },
          {
            "system" : "phone",
            "value" : "0370103886",
            "use" : "home"
          }
        ],
        "gender" : "female",
        "birthDate" : "1994-11-11",
        "address" : [
          {
            "line" : ["175 Zeppelin Ave"],
            "city" : "Mountain View",
            "state" : "VIC",
            "postalCode" : "3988",
            "country" : "AU"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:abfb35a4-7b89-46d1-be21-dec293999a1b",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "abfb35a4-7b89-46d1-be21-dec293999a1b",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_abfb35a4-7b89-46d1-be21-dec293999a1b\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization abfb35a4-7b89-46d1-be21-dec293999a1b</b></p><a name=\"abfb35a4-7b89-46d1-be21-dec293999a1b\"> </a><a name=\"hcabfb35a4-7b89-46d1-be21-dec293999a1b\"> </a><p><b>identifier</b>: HPI-O/8003629900040482, ABN/81132303164</p><p><b>type</b>: <span title=\"Codes:{http://www.abs.gov.au/ausstats/abs@.nsf/mf/1292.0 8520}, {http://snomed.info/sct 708175003}\">Diagnostic Radiology</span></p><p><b>name</b>: Douglas Radiology</p><p><b>telecom</b>: ph: 0355500107(Work), <a href=\"mailto:reception@douglasradiology.example.com.au\">reception@douglasradiology.example.com.au</a></p><p><b>address</b>: 74 Freedom Lane Douglas VIC 3401 </p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
                  "code" : "NOI"
                }
              ],
              "text" : "HPI-O"
            },
            "system" : "http://ns.electronichealth.net.au/id/hi/hpio/1.0",
            "value" : "8003629900040482"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "XX"
                }
              ],
              "text" : "ABN"
            },
            "system" : "http://hl7.org.au/id/abn",
            "value" : "81132303164"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1292.0",
                "code" : "8520",
                "display" : "Pathology and Diagnostic Imaging Services"
              },
              {
                "system" : "http://snomed.info/sct",
                "code" : "708175003",
                "display" : "Diagnostic imaging service"
              }
            ],
            "text" : "Diagnostic Radiology"
          }
        ],
        "name" : "Douglas Radiology",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0355500107",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "reception@douglasradiology.example.com.au"
          }
        ],
        "address" : [
          {
            "line" : ["74 Freedom Lane"],
            "city" : "Douglas",
            "state" : "VIC",
            "postalCode" : "3401"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:719de42c-3b25-45d6-b24f-ebec9a753175",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "afead11c-3bee-4020-af4f-44040abfa961",
        "meta" : {
          "profile" : [
            "http://hl7.org.au/fhir/ps/StructureDefinition/au-ps-practitionerrole"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_afead11c-3bee-4020-af4f-44040abfa961\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole afead11c-3bee-4020-af4f-44040abfa961</b></p><a name=\"afead11c-3bee-4020-af4f-44040abfa961\"> </a><a name=\"hcafead11c-3bee-4020-af4f-44040abfa961\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-au-ps-practitionerrole.html\">AU PS PractitionerRole</a></p></div><p><b>identifier</b>: Medicare Provider Number/2449191X</p><p><b>practitioner</b>: <a href=\"Bundle-aups-noknownx.html#urn-uuid-f8135a88-5992-4a78-8d9f-6bc3f533292d\">Practitioner Palmer BURDETT </a></p><p><b>organization</b>: <a href=\"Bundle-aups-noknownx.html#urn-uuid-abfb35a4-7b89-46d1-be21-dec293999a1b\">Organization Douglas Radiology</a></p><p><b>code</b>: <span title=\"Codes:{http://www.abs.gov.au/ausstats/abs@.nsf/mf/1220.0 253917}\">Diagnostic and Interventional Radiologist</span></p><p><b>specialty</b>: <span title=\"Codes:{http://snomed.info/sct 408455009}\">Interventional radiology - speciality</span></p><p><b>telecom</b>: ph: 0370101180(Work), <a href=\"mailto:palmer.burdett@douglasradiology.example.com.au\">palmer.burdett@douglasradiology.example.com.au</a></p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
                  "code" : "UPIN"
                }
              ],
              "text" : "Medicare Provider Number"
            },
            "system" : "http://ns.electronichealth.net.au/id/medicare-provider-number",
            "value" : "2449191X"
          }
        ],
        "practitioner" : {
          "reference" : "urn:uuid:f8135a88-5992-4a78-8d9f-6bc3f533292d"
        },
        "organization" : {
          "reference" : "urn:uuid:abfb35a4-7b89-46d1-be21-dec293999a1b"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1220.0",
                "code" : "253917"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "408455009"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0370101180",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "palmer.burdett@douglasradiology.example.com.au",
            "use" : "work"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:f8135a88-5992-4a78-8d9f-6bc3f533292d",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "f8135a88-5992-4a78-8d9f-6bc3f533292d",
        "meta" : {
          "profile" : [
            "http://hl7.org.au/fhir/ps/StructureDefinition/au-ps-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_f8135a88-5992-4a78-8d9f-6bc3f533292d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner f8135a88-5992-4a78-8d9f-6bc3f533292d</b></p><a name=\"f8135a88-5992-4a78-8d9f-6bc3f533292d\"> </a><a name=\"hcf8135a88-5992-4a78-8d9f-6bc3f533292d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-au-ps-practitioner.html\">AU PS Practitioner</a></p></div><p><b>identifier</b>: HPI-I/8003616566719012</p><p><b>name</b>: Palmer BURDETT </p><p><b>telecom</b>: ph: 0370101180(Work), <a href=\"mailto:palmer.burdett@douglasradiology.example.com.au\">palmer.burdett@douglasradiology.example.com.au</a></p><p><b>address</b>: 31 Museum Pde Douglas VIC 3401 </p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NPI",
                  "display" : "National provider identifier"
                }
              ],
              "text" : "HPI-I"
            },
            "system" : "http://ns.electronichealth.net.au/id/hi/hpii/1.0",
            "value" : "8003616566719012"
          }
        ],
        "name" : [
          {
            "family" : "BURDETT",
            "given" : ["Palmer"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0370101180",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "palmer.burdett@douglasradiology.example.com.au"
          }
        ],
        "address" : [
          {
            "line" : ["31 Museum Pde"],
            "city" : "Douglas",
            "state" : "VIC",
            "postalCode" : "3401"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:9840a67e-3621-470d-9a7c-e559422591f5",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "9840a67e-3621-470d-9a7c-e559422591f5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_9840a67e-3621-470d-9a7c-e559422591f5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance 9840a67e-3621-470d-9a7c-e559422591f5</b></p><a name=\"9840a67e-3621-470d-9a7c-e559422591f5\"> </a><a name=\"hc9840a67e-3621-470d-9a7c-e559422591f5\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 716186003}\">No known allergy</span></p><p><b>patient</b>: <a href=\"Bundle-aups-noknownx.html#urn-uuid-03b8cc8a-df59-4daf-b9f2-8b49d3c7579a\">Charlotte MORRIS  Female, DoB: 1994-11-11 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314687)</a></p><p><b>recordedDate</b>: 2024-12-10</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "716186003",
              "display" : "No known allergy"
            }
          ],
          "text" : "No known allergy"
        },
        "patient" : {
          "reference" : "urn:uuid:03b8cc8a-df59-4daf-b9f2-8b49d3c7579a"
        },
        "recordedDate" : "2024-12-10"
      }
    },
    {
      "fullUrl" : "urn:uuid:0fc878c1-a158-425f-ba08-ea4366fbb4e1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "0fc878c1-a158-425f-ba08-ea4366fbb4e1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_0fc878c1-a158-425f-ba08-ea4366fbb4e1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 0fc878c1-a158-425f-ba08-ea4366fbb4e1</b></p><a name=\"0fc878c1-a158-425f-ba08-ea4366fbb4e1\"> </a><a name=\"hc0fc878c1-a158-425f-ba08-ea4366fbb4e1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <span title=\"Codes:{http://snomed.info/sct 1234391000168107}\">No known current medicines</span></p><p><b>subject</b>: <a href=\"Bundle-aups-noknownx.html#urn-uuid-03b8cc8a-df59-4daf-b9f2-8b49d3c7579a\">Charlotte MORRIS  Female, DoB: 1994-11-11 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314687)</a></p><p><b>effective</b>: 2025-05-14</p></div>"
        },
        "status" : "active",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1234391000168107",
              "display" : "No known current medicines"
            }
          ],
          "text" : "No known current medicines"
        },
        "subject" : {
          "reference" : "urn:uuid:03b8cc8a-df59-4daf-b9f2-8b49d3c7579a"
        },
        "effectiveDateTime" : "2025-05-14"
      }
    },
    {
      "fullUrl" : "urn:uuid:df366c47-c739-4c16-939e-b5cf9afb0b7d",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "df366c47-c739-4c16-939e-b5cf9afb0b7d",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_df366c47-c739-4c16-939e-b5cf9afb0b7d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition df366c47-c739-4c16-939e-b5cf9afb0b7d</b></p><a name=\"df366c47-c739-4c16-939e-b5cf9afb0b7d\"> </a><a name=\"hcdf366c47-c739-4c16-939e-b5cf9afb0b7d\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 160245001}\">No current problems or disability</span></p><p><b>subject</b>: <a href=\"Bundle-aups-noknownx.html#urn-uuid-03b8cc8a-df59-4daf-b9f2-8b49d3c7579a\">Charlotte MORRIS  Female, DoB: 1994-11-11 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314687)</a></p><p><b>recordedDate</b>: 2025-03-30</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "160245001",
              "display" : "No current problems or disability"
            }
          ],
          "text" : "No current problems or disability"
        },
        "subject" : {
          "reference" : "urn:uuid:03b8cc8a-df59-4daf-b9f2-8b49d3c7579a"
        },
        "recordedDate" : "2025-03-30"
      }
    }
  ]
}

```
