# Bundle - Basic summary - AU Patient Summary Implementation Guide v0.6.0-cibuild

* [**Table of Contents**](toc.md)
* [**FHIR artefacts**](artefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Bundle - Basic summary**

## Example Bundle: Bundle - Basic summary



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "aups-basicsummary",
  "meta" : {
    "profile" : ["http://hl7.org.au/fhir/ps/StructureDefinition/au-ps-bundle"]
  },
  "language" : "en-AU",
  "identifier" : {
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:uuid:0bd27fed-5f11-4344-beeb-c3b78c00f604"
  },
  "type" : "document",
  "timestamp" : "2025-02-05T19:33:11.0607701+10:00",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:514af4c1-194d-48b4-8afe-7be09d3f895a",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "514af4c1-194d-48b4-8afe-7be09d3f895a",
        "meta" : {
          "versionId" : "1"
        },
        "language" : "en-AU",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-AU\" lang=\"en-AU\"><a name=\"Composition_514af4c1-194d-48b4-8afe-7be09d3f895a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition 514af4c1-194d-48b4-8afe-7be09d3f895a</b></p><a name=\"514af4c1-194d-48b4-8afe-7be09d3f895a\"> </a><a name=\"hc514af4c1-194d-48b4-8afe-7be09d3f895a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Language: en-AU</p></div><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 60591-5}\">Patient summary Document</span></p><p><b>date</b>: 2025-02-03</p><p><b>author</b>: <a href=\"Bundle-aups-basicsummary.html#urn-uuid-463c2982-3759-4022-b40e-521bbe54d544\">PractitionerRole General practitioner</a></p><p><b>title</b>: International Patient Summary</p><p><b>custodian</b>: <a href=\"Bundle-aups-basicsummary.html#urn-uuid-70a756e3-20b3-4637-8601-a222983e295a\">Organization Bobrester Medical Center</a></p></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:9be88cc6-09e8-4dc6-b058-88676240dbc7"
        },
        "date" : "2025-02-03",
        "author" : [
          {
            "reference" : "urn:uuid:463c2982-3759-4022-b40e-521bbe54d544"
          }
        ],
        "title" : "International Patient Summary",
        "custodian" : {
          "reference" : "urn:uuid:70a756e3-20b3-4637-8601-a222983e295a"
        },
        "section" : [
          {
            "title" : "Active Problems",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list - Reported"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-AU\" lang=\"en-AU\">21/12/2024 No current problem or disability.</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:310f1593-d610-4144-a6e8-1f823d955e0d"
              }
            ]
          },
          {
            "title" : "Active Allergies or Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-AU\" lang=\"en-AU\">\n            <table border=\"1\">\n              <thead>\n                <tr>\n                  <th>Allergy, Intolerance, Substance</th>\n                  <th>Onset</th>\n                  <th>Recorded</th>\n                  <th>Manifestation</th>\n                  <th>Manifestation Severity</th>\n                </tr>\n              </thead>\n              <tbody>\n                <tr>\n                  <td>Intolerance to lactose</td>\n                  <td>2022</td>\n                  <td>14/03/2023</td>\n                  <td>Abdominal pain, Abdominal bloating, Diarrhoea</td>\n                  <td>Mild</td>\n                </tr>\n                <tr>\n                  <td>Gluten intolerance</td>\n                  <td>1999</td>\n                  <td>12/01/2023</td>\n                  <td>Fatigue</td>\n                  <td>Mild</td>\n                </tr>\n                <tr>\n                  <td>Chlorhexidine</td>\n                  <td>12/01/2023</td>\n                  <td>09/09/2023</td>\n                  <td>Hives</td>\n                  <td>Mild</td>\n                </tr>\n              </tbody>\n            </table>\n            </div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:ad6fb7b7-c76f-441e-88a5-9051e795db26"
              },
              {
                "reference" : "urn:uuid:06ba95f5-345b-412d-aa66-99e354470015"
              },
              {
                "reference" : "urn:uuid:d24db2d5-3400-4158-892c-d018acdeba09"
              }
            ]
          },
          {
            "title" : "Current Medicines",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "History of Medication use Narrative"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-AU\" lang=\"en-AU\">\n              <table border=\"1\">\n                <thead>\n                  <tr>\n                    <th>Medicine</th>\n                    <th>Directions</th>\n                    <th>Date asserted</th>\n                  </tr>\n                </thead>\n                <tbody>\n                  <tr>\n                    <td><b>Bisoprolol</b> 2.5mg tab</td>\n                    <td>Take 1/2 tablet in the morning</td>\n                    <td>05/01/2025</td>\n                  </tr>\n                </tbody>\n              </table>\n            </div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:347e8435-cea1-4e94-9755-abb027926bb1"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:9be88cc6-09e8-4dc6-b058-88676240dbc7",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "9be88cc6-09e8-4dc6-b058-88676240dbc7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_9be88cc6-09e8-4dc6-b058-88676240dbc7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 9be88cc6-09e8-4dc6-b058-88676240dbc7</b></p><a name=\"9be88cc6-09e8-4dc6-b058-88676240dbc7\"> </a><a name=\"hc9be88cc6-09e8-4dc6-b058-88676240dbc7\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Mia Leanne Banks  Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li>ph: 0270102724(Work)</li><li>ph: 0491574632(Mobile)</li><li>ph: 0270107520(Home)</li><li><a href=\"mailto:mia.banks@myownpersonaldomain.com\">mia.banks@myownpersonaldomain.com</a></li><li>ph: 270107520(Home)</li><li>50 Sebastien St Minjary NSW 2720 AU </li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The pronouns to use when referring to an individual in verbal or written communication.\">Individual Pronouns:</td><td colspan=\"3\"><ul><li>value: <span title=\"Codes:{http://loinc.org LA29519-8}\">she/her/her/hers/herself</span></li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"An individual's personal sense of being a man, woman, boy, girl, nonbinary, or something else. This represents an individual’s identity, ascertained by asking them what that identity is. \n In the case where the gender identity is communicated by a third party, for example, if a spouse indicates the gender identity of their partner on an intake form, a Provenance resource can be used with a Provenance.target referring to the Patient, with a targetElement extension identifying the gender identity extension as the target element within the Patient resource.  When exchanging this concept, refer to the guidance in the [Gender Harmony Implementation Guide](http://hl7.org/xprod/ig/uv/gender-harmony/).\">Individual Gender Identity:</td><td colspan=\"3\"><ul><li>value: <span title=\"Codes:{http://snomed.info/sct 446141000124107}\">Identifies as female gender</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/individual-genderIdentity",
            "extension" : [
              {
                "url" : "value",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://snomed.info/sct",
                      "code" : "446141000124107",
                      "display" : "Identifies as female gender"
                    }
                  ]
                }
              }
            ]
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/individual-pronouns",
            "extension" : [
              {
                "url" : "value",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "LA29519-8",
                      "display" : "she/her/her/hers/herself"
                    }
                  ]
                }
              }
            ]
          }
        ],
        "identifier" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-status",
                "valueCoding" : {
                  "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-status-1",
                  "code" : "active"
                }
              },
              {
                "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-record-status",
                "valueCoding" : {
                  "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-record-status-1",
                  "code" : "verified",
                  "display" : "verified"
                }
              }
            ],
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NI"
                }
              ],
              "text" : "IHI"
            },
            "system" : "http://ns.electronichealth.net.au/id/hi/ihi/1.0",
            "value" : "8003608333647261"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "Banks",
            "given" : ["Mia", "Leanne"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0270102724",
            "use" : "work"
          },
          {
            "system" : "phone",
            "value" : "0491574632",
            "use" : "mobile"
          },
          {
            "system" : "phone",
            "value" : "0270107520",
            "use" : "home"
          },
          {
            "system" : "email",
            "value" : "mia.banks@myownpersonaldomain.com"
          },
          {
            "system" : "phone",
            "value" : "270107520",
            "use" : "home"
          }
        ],
        "gender" : "female",
        "birthDate" : "1983-08-25",
        "address" : [
          {
            "line" : ["50 Sebastien St"],
            "city" : "Minjary",
            "state" : "NSW",
            "postalCode" : "2720",
            "country" : "AU"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:70a756e3-20b3-4637-8601-a222983e295a",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "70a756e3-20b3-4637-8601-a222983e295a",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_70a756e3-20b3-4637-8601-a222983e295a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization 70a756e3-20b3-4637-8601-a222983e295a</b></p><a name=\"70a756e3-20b3-4637-8601-a222983e295a\"> </a><a name=\"hc70a756e3-20b3-4637-8601-a222983e295a\"> </a><p><b>identifier</b>: ABN/12345678901</p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 288565001}\">Medical Center</span></p><p><b>name</b>: Bobrester Medical Center</p><p><b>telecom</b>: <a href=\"mailto:info@bobrestermedical.example.com\">info@bobrestermedical.example.com</a>, ph: (07) 5550 2427(Work)</p><p><b>address</b>: 87 Western Esp Tindal RAAF QLD 4655 AU </p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "XX"
                }
              ],
              "text" : "ABN"
            },
            "system" : "http://hl7.org.au/id/abn",
            "value" : "12345678901"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "288565001",
                "display" : "Medical centre"
              }
            ],
            "text" : "Medical Center"
          }
        ],
        "name" : "Bobrester Medical Center",
        "telecom" : [
          {
            "system" : "email",
            "value" : "info@bobrestermedical.example.com",
            "use" : "work"
          },
          {
            "system" : "phone",
            "value" : "(07) 5550 2427",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["87 Western Esp"],
            "city" : "Tindal RAAF",
            "state" : "QLD",
            "postalCode" : "4655",
            "country" : "AU"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:463c2982-3759-4022-b40e-521bbe54d544",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "463c2982-3759-4022-b40e-521bbe54d544",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_463c2982-3759-4022-b40e-521bbe54d544\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole 463c2982-3759-4022-b40e-521bbe54d544</b></p><a name=\"463c2982-3759-4022-b40e-521bbe54d544\"> </a><a name=\"hc463c2982-3759-4022-b40e-521bbe54d544\"> </a><p><b>identifier</b>: Employee Number/12345678</p><p><b>practitioner</b>: <a href=\"Bundle-aups-basicsummary.html#urn-uuid-dce50472-2a94-47e6-9501-b52f0df0c813\">Practitioner Bob Bobrester </a></p><p><b>organization</b>: <a href=\"Bundle-aups-basicsummary.html#urn-uuid-70a756e3-20b3-4637-8601-a222983e295a\">Organization Bobrester Medical Center</a></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 62247001}, {http://www.abs.gov.au/ausstats/abs@.nsf/mf/1220.0 253111}\">General Practitioner</span></p><p><b>telecom</b>: ph: 0491579760, <a href=\"mailto:drbob@bobrestermedical.example.com\">drbob@bobrestermedical.example.com</a></p></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "EI",
                  "display" : "Employee number"
                }
              ],
              "text" : "Employee Number"
            },
            "system" : "http://ns.electronichealth.net.au/id/abn-scoped/service-provider-individual/1.0/12345678901",
            "value" : "12345678",
            "assigner" : {
              "display" : "Bobrester Medical Center"
            }
          }
        ],
        "practitioner" : {
          "reference" : "urn:uuid:dce50472-2a94-47e6-9501-b52f0df0c813"
        },
        "organization" : {
          "reference" : "urn:uuid:70a756e3-20b3-4637-8601-a222983e295a"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "62247001"
              },
              {
                "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1220.0",
                "code" : "253111"
              }
            ],
            "text" : "General Practitioner"
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0491579760"
          },
          {
            "system" : "email",
            "value" : "drbob@bobrestermedical.example.com"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:dce50472-2a94-47e6-9501-b52f0df0c813",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "dce50472-2a94-47e6-9501-b52f0df0c813",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_dce50472-2a94-47e6-9501-b52f0df0c813\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner dce50472-2a94-47e6-9501-b52f0df0c813</b></p><a name=\"dce50472-2a94-47e6-9501-b52f0df0c813\"> </a><a name=\"hcdce50472-2a94-47e6-9501-b52f0df0c813\"> </a><p><b>name</b>: Bob Bobrester </p></div>"
        },
        "name" : [
          {
            "family" : "Bobrester",
            "given" : ["Bob"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:ad6fb7b7-c76f-441e-88a5-9051e795db26",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "ad6fb7b7-c76f-441e-88a5-9051e795db26",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_ad6fb7b7-c76f-441e-88a5-9051e795db26\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance ad6fb7b7-c76f-441e-88a5-9051e795db26</b></p><a name=\"ad6fb7b7-c76f-441e-88a5-9051e795db26\"> </a><a name=\"hcad6fb7b7-c76f-441e-88a5-9051e795db26\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 782415009}\">Intolerance to lactose</span></p><p><b>patient</b>: <a href=\"Bundle-aups-basicsummary.html#urn-uuid-9be88cc6-09e8-4dc6-b058-88676240dbc7\">Mia Leanne Banks  Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)</a></p><p><b>onset</b>: 2022</p><p><b>recordedDate</b>: 2023-03-14</p><blockquote><p><b>reaction</b></p><p><b>manifestation</b>: <span title=\"Codes:{http://snomed.info/sct 21522001}\">Abdominal pain</span>, <span title=\"Codes:{http://snomed.info/sct 116289008}\">Abdominal bloating</span>, <span title=\"Codes:{http://snomed.info/sct 62315008}\">Diarrhoea</span></p><p><b>severity</b>: Mild</p></blockquote></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "782415009",
              "display" : "Intolerance to lactose"
            }
          ]
        },
        "patient" : {
          "reference" : "urn:uuid:9be88cc6-09e8-4dc6-b058-88676240dbc7"
        },
        "onsetDateTime" : "2022",
        "recordedDate" : "2023-03-14",
        "reaction" : [
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "21522001",
                    "display" : "Abdominal pain"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "116289008",
                    "display" : "Abdominal bloating"
                  }
                ]
              },
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "62315008",
                    "display" : "Diarrhoea"
                  }
                ]
              }
            ],
            "severity" : "mild"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:06ba95f5-345b-412d-aa66-99e354470015",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "06ba95f5-345b-412d-aa66-99e354470015",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_06ba95f5-345b-412d-aa66-99e354470015\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance 06ba95f5-345b-412d-aa66-99e354470015</b></p><a name=\"06ba95f5-345b-412d-aa66-99e354470015\"> </a><a name=\"hc06ba95f5-345b-412d-aa66-99e354470015\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>type</b>: Intolerance</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 1269424006}\">Gluten intolerance</span></p><p><b>patient</b>: <a href=\"Bundle-aups-basicsummary.html#urn-uuid-9be88cc6-09e8-4dc6-b058-88676240dbc7\">Mia Leanne Banks  Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)</a></p><p><b>onset</b>: 1999</p><p><b>recordedDate</b>: 2023-01-12</p><h3>Reactions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Substance</b></td><td><b>Manifestation</b></td><td><b>Severity</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 89811004}\">Gluten</span></td><td><span title=\"Codes:{http://snomed.info/sct 84229001}\">Fatigue</span></td><td>Mild</td></tr></table></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ],
          "text" : "Active"
        },
        "type" : "intolerance",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1269424006"
            }
          ],
          "text" : "Gluten intolerance"
        },
        "patient" : {
          "reference" : "urn:uuid:9be88cc6-09e8-4dc6-b058-88676240dbc7"
        },
        "onsetDateTime" : "1999",
        "recordedDate" : "2023-01-12",
        "reaction" : [
          {
            "substance" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "89811004"
                }
              ],
              "text" : "Gluten"
            },
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "84229001"
                  }
                ],
                "text" : "Fatigue"
              }
            ],
            "severity" : "mild"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:d24db2d5-3400-4158-892c-d018acdeba09",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "d24db2d5-3400-4158-892c-d018acdeba09",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_d24db2d5-3400-4158-892c-d018acdeba09\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance d24db2d5-3400-4158-892c-d018acdeba09</b></p><a name=\"d24db2d5-3400-4158-892c-d018acdeba09\"> </a><a name=\"hcd24db2d5-3400-4158-892c-d018acdeba09\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 373568007}\">Chlorhexidine</span></p><p><b>patient</b>: <a href=\"Bundle-aups-basicsummary.html#urn-uuid-9be88cc6-09e8-4dc6-b058-88676240dbc7\">Mia Leanne Banks  Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)</a></p><p><b>onset</b>: 2023-01-12</p><p><b>recordedDate</b>: 2023-09-09</p><h3>Reactions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Substance</b></td><td><b>Manifestation</b></td><td><b>Severity</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 373568007}\">Chlorhexidine</span></td><td><span title=\"Codes:{http://snomed.info/sct 247472004}\">Hives</span></td><td>Mild</td></tr></table></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ],
          "text" : "Active"
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "373568007"
            }
          ],
          "text" : "Chlorhexidine"
        },
        "patient" : {
          "reference" : "urn:uuid:9be88cc6-09e8-4dc6-b058-88676240dbc7"
        },
        "onsetDateTime" : "2023-01-12",
        "recordedDate" : "2023-09-09",
        "reaction" : [
          {
            "substance" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "373568007"
                }
              ],
              "text" : "Chlorhexidine"
            },
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "247472004"
                  }
                ],
                "text" : "Hives"
              }
            ],
            "severity" : "mild"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:347e8435-cea1-4e94-9755-abb027926bb1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "347e8435-cea1-4e94-9755-abb027926bb1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_347e8435-cea1-4e94-9755-abb027926bb1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 347e8435-cea1-4e94-9755-abb027926bb1</b></p><a name=\"347e8435-cea1-4e94-9755-abb027926bb1\"> </a><a name=\"hc347e8435-cea1-4e94-9755-abb027926bb1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"#hc347e8435-cea1-4e94-9755-abb027926bb1/bisoprolol\">Medication Bisoprolol fumarate 2.5 mg tablet</a></p><p><b>subject</b>: <a href=\"Bundle-aups-basicsummary.html#urn-uuid-9be88cc6-09e8-4dc6-b058-88676240dbc7\">Mia Leanne Banks  Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)</a></p><p><b>effective</b>: 2025-01-05</p><p><b>dateAsserted</b>: 2025-01-05</p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>1/2 tablet in the morning</td></tr></table><hr/><blockquote><p class=\"res-header-id\"><b>Generated Narrative: Medication #bisoprolol</b></p><a name=\"347e8435-cea1-4e94-9755-abb027926bb1/bisoprolol\"> </a><a name=\"hc347e8435-cea1-4e94-9755-abb027926bb1/bisoprolol\"> </a><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 23281011000036106}\">Bisoprolol 2.5mg tab</span></p><p><b>form</b>: <span title=\"Codes:{http://snomed.info/sct 385055001}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 386869006}\">Bisoprolol fumarate</span></td><td>2.5 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: SNOMED CT  code385055001 = 'Tablet')</span></td></tr></table></blockquote></div>"
        },
        "contained" : [
          {
            "resourceType" : "Medication",
            "id" : "bisoprolol",
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "23281011000036106",
                  "display" : "Bisoprolol fumarate 2.5 mg tablet"
                }
              ],
              "text" : "Bisoprolol 2.5mg tab"
            },
            "form" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "385055001",
                  "display" : "Tablet"
                }
              ]
            },
            "ingredient" : [
              {
                "itemCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://snomed.info/sct",
                      "code" : "386869006",
                      "display" : "Bisoprolol fumarate"
                    }
                  ]
                },
                "strength" : {
                  "numerator" : {
                    "value" : 2.5,
                    "system" : "http://unitsofmeasure.org",
                    "code" : "mg"
                  },
                  "denominator" : {
                    "value" : 1,
                    "unit" : "Tablet",
                    "system" : "http://snomed.info/sct",
                    "code" : "385055001"
                  }
                }
              }
            ]
          }
        ],
        "status" : "active",
        "medicationReference" : {
          "reference" : "#bisoprolol"
        },
        "subject" : {
          "reference" : "urn:uuid:9be88cc6-09e8-4dc6-b058-88676240dbc7"
        },
        "effectiveDateTime" : "2025-01-05",
        "dateAsserted" : "2025-01-05",
        "dosage" : [
          {
            "text" : "1/2 tablet in the morning"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:310f1593-d610-4144-a6e8-1f823d955e0d",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "310f1593-d610-4144-a6e8-1f823d955e0d",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_310f1593-d610-4144-a6e8-1f823d955e0d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition 310f1593-d610-4144-a6e8-1f823d955e0d</b></p><a name=\"310f1593-d610-4144-a6e8-1f823d955e0d\"> </a><a name=\"hc310f1593-d610-4144-a6e8-1f823d955e0d\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 160245001}\">No current problems or disability</span></p><p><b>subject</b>: <a href=\"Bundle-aups-basicsummary.html#urn-uuid-9be88cc6-09e8-4dc6-b058-88676240dbc7\">Mia Leanne Banks  Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)</a></p><p><b>recordedDate</b>: 2024-12-21</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "160245001",
              "display" : "No current problems or disability"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:9be88cc6-09e8-4dc6-b058-88676240dbc7"
        },
        "recordedDate" : "2024-12-21"
      }
    }
  ]
}

```
