# Artefacts Summary - AU Patient Summary Implementation Guide v0.6.0-cibuild

* [**Table of Contents**](toc.md)
* [**FHIR artefacts**](artefacts.md)
* **Artefacts Summary**

## Artefacts Summary

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [AU PS Consumer](ActorDefinition-au-ps-actor-consumer.md) | An AU PS Consumer is a system that consumes an AU PS Bundle and uses it to display or process patient summary content. This actor is based on the Consumer (IPS) actor, and describes the additional requirements and documentation applied for the Australian context. |
| [AU PS Producer](ActorDefinition-au-ps-actor-producer.md) | An AU PS Producer is a system which creates or assembles an AU PS Bundle through automated generation or human curation of the patient summary content. This actor is based on the Creator (IPS) actor, and describes the additional requirements and documentation applied for the Australian context. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AU PS AllergyIntolerance](StructureDefinition-au-ps-allergyintolerance.md) | This profile sets minimum expectations for an AllergyIntolerance resource in the context of a patient summary in an Australian context. It is based on the [AU Core AllergyIntolerance](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-allergyintolerance.html) profile, and applies the additional requirements from [AllergyIntolerance (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/AllergyIntolerance-uv-ips). |
| [AU PS Bundle](StructureDefinition-au-ps-bundle.md) | This profile sets minimum expectations for a Bundle resource in the context of a patient summary in an Australian context. It is based on FHIR [Bundle](http://hl7.org/fhir/StructureDefinition/Bundle), and applies the constraints of [Bundle (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips) and AU Patient Summary (AU PS). AU PS is specified in this guide as a HL7 FHIR document (a Bundle including a Composition), composed by a set of potentially reusable 'minimal' data blocks (the AU PS profiles). |
| [AU PS Composition](StructureDefinition-au-ps-composition.md) | This profile sets minimum expectations for a Composition resource in the context of a patient summary in an Australian context. It is based on [AU Base Composition](http://hl7.org.au/fhir/StructureDefinition/au-composition) and imposes [Composition (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/Composition-uv-ips). AU Patient Summary (AU PS) is specified in this guide as a HL7 FHIR document (a Bundle including a Composition), composed by a set of potentially reusable 'minimal' data blocks (the AU PS profiles). |
| [AU PS Condition](StructureDefinition-au-ps-condition.md) | This profile sets minimum expectations for a Condition resource in the context of a patient summary in an Australian context. It is based on the [AU Core Condition](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-condition.html) profile, and applies the additional requirements from [Condition (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips). |
| [AU PS Encounter](StructureDefinition-au-ps-encounter.md) | This profile sets minimum expectations for an Encounter resource in the context of a patient summary in an Australian context. It is based on the [AU Core Encounter](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-encounter.html) profile, and applies the additional constraints for use in a patient summary context consistent with the profiling conventions of [IPS](https://hl7.org/fhir/uv/ips/STU2/). |
| [AU PS Immunization](StructureDefinition-au-ps-immunization.md) | This profile sets minimum expectations for an Immunization resource in the context of a patient summary in an Australian context. It is based on the [AU Core Immunization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-immunization.html) profile, and applies the additional requirements from [Immunization (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips). |
| [AU PS Medication](StructureDefinition-au-ps-medication.md) | This profile sets minimum expectations for a Medication resource in the context of a patient summary in an Australian context. It is based on the [AU Core Medication](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-medication.html) profile, and applies the additional requirements from [Medication (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips). |
| [AU PS MedicationRequest](StructureDefinition-au-ps-medicationrequest.md) | This profile sets minimum expectations for a MedicationRequest resource in the context of a patient summary in an Australian context. It is based on the [AU Core MedicationRequest](http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationrequest), and applies the additional requirements from [MedicationRequest (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationRequest-uv-ips). |
| [AU PS MedicationStatement](StructureDefinition-au-ps-medicationstatement.md) | This profile sets minimum expectations for a MedicationStatement resource in the context of a patient summary in an Australian context. It is based on the [AU Core MedicationStatement](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-medicationstatement.html) profile, and applies the additional requirements from [MedicationStatement (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips). |
| [AU PS Organization](StructureDefinition-au-ps-organization.md) | This profile sets minimum expectations for an Organization resource in the context of a patient summary in an Australian context. It is based on the [AU Core Organization](http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization) profile, and applies the additional requirements from [Organization (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/Organization-uv-ips). |
| [AU PS Pathology Result Observation](StructureDefinition-au-ps-diagnosticresult-path.md) | This profile sets minimum expectations for an Observation resource that represents a pathology result associated with a patient in the context of a patient summary in an Australian context. It is based on the [AU Core Pathology Result Observation](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-diagnosticresult-path.html) profile, and applies the additional requirements from [Observation Results - Laboratory/Pathology (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-results-laboratory-pathology-uv-ips.html). |
| [AU PS Patient](StructureDefinition-au-ps-patient.md) | This profile sets minimum expectations for a Patient resource in the context of a patient summary in an Australian context. It is based on the [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html) profile, and applies the additional requirements from [Patient (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips). |
| [AU PS Practitioner](StructureDefinition-au-ps-practitioner.md) | This profile sets minimum expectations for a Practitioner resource in the context of a patient summary in an Australian context. It is based on the [AU Core Practitioner](http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner) profile, and applies the additional requirements from [Practitioner (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/Practitioner-uv-ips). |
| [AU PS PractitionerRole](StructureDefinition-au-ps-practitionerrole.md) | This profile sets minimum expectations for a PractitionerRole resource in the context of a patient summary in an Australian context. It is based on the [AU Core PractitionerRole](http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole) profile, and applies the additional requirements from [PractitionerRole (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/PractitionerRole-uv-ips). |
| [AU PS Procedure](StructureDefinition-au-ps-procedure.md) | This profile sets minimum expectations for a Procedure resource in the context of a patient summary in an Australian context. It is based on the [AU Core Procedure](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-procedure.html) profile, and applies the additional requirements from [Procedure (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/Procedure-uv-ips). |
| [AU PS RelatedPerson](StructureDefinition-au-ps-relatedperson.md) | This profile sets minimum expectations for a RelatedPerson resource in the context of a patient summary in an Australian context. It is based on the [AU Core Related Person](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-relatedperson.html) profile, and applies the additional constraints for use in a patient summary context consistent with the profiling conventions of [IPS](https://hl7.org/fhir/uv/ips/STU2/). |
| [AU PS Smoking Status](StructureDefinition-au-ps-smokingstatus.md) | This profile sets minimum expectations for an Observation resource that represents a patient's smoking status in the context of a patient summary in an Australian context. It is based on the [AU Core Smoking Status](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-smokingstatus.html) profile, and applies the additional requirements from [Observation Social History - Tobacco Use (IPS)](http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-tobaccouse-uv-ips). |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Bundle - Basic summary](Bundle-aups-basicsummary.md) | Shows an example of a provider curated patient summary that demonstrates no known problems or disabilities, current allergies and intolerances, and current medication use. Example for the **AU PS Bundle** and **AU PS Composition** profile. Patient: Mia Leanne Banks. |
| [Bundle - Jeramy’s Patient Summary as of 27 May 2025](Bundle-aups-gpvisit-retrieval.md) | [Interstate GP use case](uc-interstate.md) example. Shows an example of a patient summary authored by the patient's usual GP that was updated after a recent admission to hospital. Example for the **AU PS Bundle** and **AU PS Composition** profile. Patient: Jeramy Ezra Banks. |
| [Bundle - No Known X](Bundle-aups-noknownx.md) | Shows an example of a patient summary that demonstrates no known problems or disabilities, no known allergies and intolerances, and no known current medications. Example for the **AU PS Bundle** and **AU PS Composition** profile. Patient: Charlotte Morris. |
| [Bundle - Patient Summary for Joyce Johnson as of 07 NOV 2024 (with digital signature)](Bundle-aups-referral-endoconsult-autogen.md) | [Referral to Specialist and Allied Health use case](uc-referral.md) example. Shows an example of a patient summary containing the medical history and current medications that is automatically generated by a clinical information system and includes the most recent information. This example is digitally signed. Example for the **AU PS Bundle** and **AU PS Composition** profile. Patient: Joyce Johnson. |
| [Bundle - Patient Summary for Joyce Johnson as of 28 OCT 2024 (with electronic signature)](Bundle-aups-referral-endoconsult-curated.md) | [Referral to Specialist and Allied Health use case](uc-referral.md) example. Shows an example of a patient summary containing the medical history and current medications at the time of referral that was authored by the GP through curation of a generated view of the data within their clinical information system, and was attested at the time of creation of the patient summary and signed electronically. Example for the **AU PS Bundle** and **AU PS Composition** profile. Patient: Joyce Johnson. |
| [Bundle - Section empty reason](Bundle-aups-section-emptyreason.md) | Shows a software-assembled patient summary that demonstrates missing data for Patient.birthDate and suppressed data for Patient.gender and Patient.identifier using the Data Absent Reason extension. The system also has no information for the sections: problems, allergies, medications, and immunisations. Example for the **AU PS Bundle** and **AU PS Composition** profiles. Patient: Ronny Lawrence Irvine. |

