# Resource au-ps-actor-producer



## Resource Content

```json
{
  "resourceType" : "Basic",
  "id" : "au-ps-actor-producer",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ps/ImplementationGuide/hl7.fhir.au.ps"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.url",
      "valueUri" : "http://hl7.org.au/fhir/ps/ActorDefinition/au-ps-actor-producer"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.version",
      "valueString" : "0.6.0-cibuild"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.name",
      "valueString" : "AUPSProducer"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.title",
      "valueString" : "AU PS Producer"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.status",
      "valueCode" : "active"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.date",
      "valueDateTime" : "2026-02-15T11:53:43+00:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.publisher",
      "valueString" : "HL7 Australia"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.contact",
      "valueContactDetail" : {
        "name" : "HL7 Australia FHIR Work Group",
        "telecom" : [
          {
            "system" : "url",
            "value" : "https://confluence.hl7.org/display/HAFWG",
            "use" : "work"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.description",
      "valueMarkdown" : "An AU PS Producer is a system which creates or assembles an AU PS Bundle through automated generation or human curation of the patient summary content. This actor is based on the Creator (IPS) actor, and describes the additional requirements and documentation applied for the Australian context."
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.jurisdiction",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.copyright",
      "valueMarkdown" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved."
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.type",
      "valueCode" : "system"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.documentation",
      "valueMarkdown" : "An AU PS Producer **SHALL** comply with the requirements of the [Creator (IPS)](https://hl7.org/fhir/uv/ips/STU2/ActorDefinition-Creator.html), and:\n\n - **SHALL** implement the AU PS Bundle, AU PS Composition and AU PS Patient profiles\n\n - **SHALL** for each mandatory section in AU PS Composition, implement the AU PS profiles referenced by the corresponding section entry (i.e. AU PS AllergyIntolerance, AU PS Condition, and at least one of AU PS MedicationStatement and AU PS MedicationRequest)\n\n - **SHOULD** for each recommended section in AU PS Composition, implement the profiles referenced by the corresponding section entry (e.g. AU PS Immunization, Observation Results - Radiology (IPS), AU PS Procedure, and DeviceUseStatement (IPS))\n\n - **SHOULD** for each optional or undefined section, implement profiles referenced in the AU PS Bundle, otherwise implement an AU Core or AU Base profile where applicable\n\n - **SHALL** implement the AU PS Producer obligations defined in the implemented profiles. Where an IPS profile is referenced in the AU PS Bundle, the obligations of the Creator (IPS) actor **SHALL** apply\n\n - **SHALL** implement the requirements on [Suppressed Data](https://build.fhir.org/ig/hl7au/au-fhir-ps/branches/master/general-requirements.html#suppressed-data) when data is NOT allowed to be shared\n\n - **SHALL** implement the requirements on [Missing Data, Empty Sections, Known Absence of Data](https://build.fhir.org/ig/hl7au/au-fhir-ps/branches/master/general-requirements.html#missing-data-empty-sections-known-absence-of-data)"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.derivedFrom",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/ActorDefinition/Creator"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/fhir-types",
        "code" : "ActorDefinition"
      }
    ]
  }
}

```
