/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.builtin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.json.ParseException;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.builtin.SimpleReturnFunction;
import net.sourceforge.plantuml.tim.expression.TValue;

public class LoadJson
extends SimpleReturnFunction {
    private static final String VALUE_CHARSET_DEFAULT = "UTF-8";
    private static final String VALUE_DEFAULT_DEFAULT = "{}";

    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%load_json", 3);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 1 || nbArg == 2 || nbArg == 3;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        String path = values.get(0).toString();
        try {
            String data = this.loadStringData(path, this.getCharset(values));
            if (data == null) {
                data = this.getDefaultJson(values);
            }
            JsonValue jsonValue = Json.parse(data);
            return TValue.fromJson(jsonValue);
        }
        catch (ParseException pe) {
            Logme.error(pe);
            throw new EaterException("JSON parse issue in source " + path + " on location " + pe.getLocation(), location);
        }
        catch (UnsupportedEncodingException e) {
            Logme.error(e);
            throw new EaterException("JSON encoding issue in source " + path + ": " + e.getMessage(), location);
        }
    }

    private String getDefaultJson(List<TValue> values) {
        if (values.size() > 1) {
            return values.get(1).toString();
        }
        return VALUE_DEFAULT_DEFAULT;
    }

    private String getCharset(List<TValue> values) {
        if (values.size() == 3) {
            return values.get(2).toString();
        }
        return VALUE_CHARSET_DEFAULT;
    }

    private String loadStringData(String path, String charset) throws EaterException, UnsupportedEncodingException {
        byte[] byteData = null;
        if (path.startsWith("http://") || path.startsWith("https://")) {
            SURL url = SURL.create(path);
            if (url != null) {
                byteData = url.getBytes();
            }
        } else {
            try {
                SFile file = FileSystem.getInstance().getFile(path);
                if (file != null && file.exists() && file.canRead() && !file.isDirectory()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
                    FileUtils.copyToStream(file, (OutputStream)out);
                    byteData = out.toByteArray();
                }
            }
            catch (IOException e) {
                Logme.error(e);
            }
        }
        if (byteData == null || byteData.length == 0) {
            return null;
        }
        return new String(byteData, charset);
    }
}

