/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ASCIIMathTeXImg {
    private int aAMnestingDepth;
    private Ttype aAMpreviousSymbol;
    private Ttype aAMcurrentSymbol;
    private static final Tuple aAMsqrt = new Tuple("sqrt", "msqrt", "sqrt", null, Ttype.UNARY, new Flag[0]);
    private static final Tuple aAMroot = new Tuple("root", "mroot", "root", null, Ttype.BINARY, new Flag[0]);
    private static final Tuple aAMfrac = new Tuple("frac", "mfrac", "/", null, Ttype.BINARY, new Flag[0]);
    private static final Tuple aAMdiv = new Tuple("/", "mfrac", "/", null, Ttype.INFIX, new Flag[0]);
    private static final Tuple aAMover = new Tuple("stackrel", "mover", "stackrel", null, Ttype.BINARY, new Flag[0]);
    private static final Tuple aAMsub = new Tuple("_", "msub", "_", null, Ttype.INFIX, new Flag[0]);
    private static final Tuple aAMsup = new Tuple("^", "msup", "^", null, Ttype.INFIX, new Flag[0]);
    private static final Tuple aAMtext = new Tuple("text", "mtext", "text", null, Ttype.TEXT, new Flag[0]);
    private static final Tuple aAMmbox = new Tuple("mbox", "mtext", "mbox", null, Ttype.TEXT, new Flag[0]);
    private static final Tuple aAMquote = new Tuple("\"", "mtext", "mbox", null, Ttype.TEXT, new Flag[0]);
    private static final List<Tuple> aAMsymbols = new ArrayList<Tuple>(Arrays.asList(new Tuple("alpha", "mi", "\u03b1", null, Ttype.CONST, new Flag[0]), new Tuple("beta", "mi", "\u03b2", null, Ttype.CONST, new Flag[0]), new Tuple("chi", "mi", "\u03c7", null, Ttype.CONST, new Flag[0]), new Tuple("delta", "mi", "\u03b4", null, Ttype.CONST, new Flag[0]), new Tuple("Delta", "mo", "\u0394", null, Ttype.CONST, new Flag[0]), new Tuple("epsi", "mi", "\u03b5", "epsilon", Ttype.CONST, new Flag[0]), new Tuple("varepsilon", "mi", "\u025b", null, Ttype.CONST, new Flag[0]), new Tuple("eta", "mi", "\u03b7", null, Ttype.CONST, new Flag[0]), new Tuple("gamma", "mi", "\u03b3", null, Ttype.CONST, new Flag[0]), new Tuple("Gamma", "mo", "\u0393", null, Ttype.CONST, new Flag[0]), new Tuple("iota", "mi", "\u03b9", null, Ttype.CONST, new Flag[0]), new Tuple("kappa", "mi", "\u03ba", null, Ttype.CONST, new Flag[0]), new Tuple("lambda", "mi", "\u03bb", null, Ttype.CONST, new Flag[0]), new Tuple("Lambda", "mo", "\u039b", null, Ttype.CONST, new Flag[0]), new Tuple("lamda", "mi", "lambda", null, Ttype.DEFINITION, new Flag[0]), new Tuple("Lamda", "mi", "Lambda", null, Ttype.DEFINITION, new Flag[0]), new Tuple("mu", "mi", "\u03bc", null, Ttype.CONST, new Flag[0]), new Tuple("nu", "mi", "\u03bd", null, Ttype.CONST, new Flag[0]), new Tuple("omega", "mi", "\u03c9", null, Ttype.CONST, new Flag[0]), new Tuple("Omega", "mo", "\u03a9", null, Ttype.CONST, new Flag[0]), new Tuple("phi", "mi", "\u03c6", null, Ttype.CONST, new Flag[0]), new Tuple("varphi", "mi", "\u03d5", null, Ttype.CONST, new Flag[0]), new Tuple("Phi", "mo", "\u03a6", null, Ttype.CONST, new Flag[0]), new Tuple("pi", "mi", "\u03c0", null, Ttype.CONST, new Flag[0]), new Tuple("Pi", "mo", "\u03a0", null, Ttype.CONST, new Flag[0]), new Tuple("psi", "mi", "\u03c8", null, Ttype.CONST, new Flag[0]), new Tuple("Psi", "mi", "\u03a8", null, Ttype.CONST, new Flag[0]), new Tuple("rho", "mi", "\u03c1", null, Ttype.CONST, new Flag[0]), new Tuple("sigma", "mi", "\u03c3", null, Ttype.CONST, new Flag[0]), new Tuple("Sigma", "mo", "\u03a3", null, Ttype.CONST, new Flag[0]), new Tuple("tau", "mi", "\u03c4", null, Ttype.CONST, new Flag[0]), new Tuple("theta", "mi", "\u03b8", null, Ttype.CONST, new Flag[0]), new Tuple("vartheta", "mi", "\u03d1", null, Ttype.CONST, new Flag[0]), new Tuple("Theta", "mo", "\u0398", null, Ttype.CONST, new Flag[0]), new Tuple("upsilon", "mi", "\u03c5", null, Ttype.CONST, new Flag[0]), new Tuple("xi", "mi", "\u03be", null, Ttype.CONST, new Flag[0]), new Tuple("Xi", "mo", "\u039e", null, Ttype.CONST, new Flag[0]), new Tuple("zeta", "mi", "\u03b6", null, Ttype.CONST, new Flag[0]), new Tuple("*", "mo", "\u22c5", "cdot", Ttype.CONST, new Flag[0]), new Tuple("**", "mo", "\u2217", "ast", Ttype.CONST, new Flag[0]), new Tuple("***", "mo", "\u22c6", "star", Ttype.CONST, new Flag[0]), new Tuple("//", "mo", "/", "/", Ttype.CONST, new Flag[]{Flag.VAL, Flag.NOTEXCOPY}), new Tuple("\\\\", "mo", "\\", "backslash", Ttype.CONST, new Flag[0]), new Tuple("setminus", "mo", "\\", null, Ttype.CONST, new Flag[0]), new Tuple("xx", "mo", "\u00d7", "times", Ttype.CONST, new Flag[0]), new Tuple("|><", "mo", "\u22c9", "ltimes", Ttype.CONST, new Flag[0]), new Tuple("><|", "mo", "\u22ca", "rtimes", Ttype.CONST, new Flag[0]), new Tuple("|><|", "mo", "\u22c8", "bowtie", Ttype.CONST, new Flag[0]), new Tuple("-:", "mo", "\u00f7", "div", Ttype.CONST, new Flag[0]), new Tuple("divide", "mo", "-:", null, Ttype.DEFINITION, new Flag[0]), new Tuple("@", "mo", "\u2218", "circ", Ttype.CONST, new Flag[0]), new Tuple("o+", "mo", "\u2295", "oplus", Ttype.CONST, new Flag[0]), new Tuple("ox", "mo", "\u2297", "otimes", Ttype.CONST, new Flag[0]), new Tuple("o.", "mo", "\u2299", "odot", Ttype.CONST, new Flag[0]), new Tuple("sum", "mo", "\u2211", null, Ttype.UNDEROVER, new Flag[0]), new Tuple("prod", "mo", "\u220f", null, Ttype.UNDEROVER, new Flag[0]), new Tuple("^^", "mo", "\u2227", "wedge", Ttype.CONST, new Flag[0]), new Tuple("^^^", "mo", "\u22c0", "bigwedge", Ttype.UNDEROVER, new Flag[0]), new Tuple("vv", "mo", "\u2228", "vee", Ttype.CONST, new Flag[0]), new Tuple("vvv", "mo", "\u22c1", "bigvee", Ttype.UNDEROVER, new Flag[0]), new Tuple("nn", "mo", "\u2229", "cap", Ttype.CONST, new Flag[0]), new Tuple("nnn", "mo", "\u22c2", "bigcap", Ttype.UNDEROVER, new Flag[0]), new Tuple("uu", "mo", "\u222a", "cup", Ttype.CONST, new Flag[0]), new Tuple("uuu", "mo", "\u22c3", "bigcup", Ttype.UNDEROVER, new Flag[0]), new Tuple("overset", "mover", "stackrel", null, Ttype.BINARY, new Flag[0]), new Tuple("underset", "munder", "stackrel", null, Ttype.BINARY, new Flag[0]), new Tuple("!=", "mo", "\u2260", "ne", Ttype.CONST, new Flag[0]), new Tuple(":=", "mo", ":=", null, Ttype.CONST, new Flag[0]), new Tuple("lt", "mo", "<", null, Ttype.CONST, new Flag[0]), new Tuple("gt", "mo", ">", null, Ttype.CONST, new Flag[0]), new Tuple("<=", "mo", "\u2264", "le", Ttype.CONST, new Flag[0]), new Tuple("lt=", "mo", "\u2264", "leq", Ttype.CONST, new Flag[0]), new Tuple("gt=", "mo", "\u2265", "geq", Ttype.CONST, new Flag[0]), new Tuple(">=", "mo", "\u2265", "ge", Ttype.CONST, new Flag[0]), new Tuple("mlt", "mo", "\u226a", "ll", Ttype.CONST, new Flag[0]), new Tuple("mgt", "mo", "\u226b", "gg", Ttype.CONST, new Flag[0]), new Tuple("-<", "mo", "\u227a", "prec", Ttype.CONST, new Flag[0]), new Tuple("-lt", "mo", "\u227a", null, Ttype.CONST, new Flag[0]), new Tuple(">-", "mo", "\u227b", "succ", Ttype.CONST, new Flag[0]), new Tuple("-<=", "mo", "\u2aaf", "preceq", Ttype.CONST, new Flag[0]), new Tuple(">-=", "mo", "\u2ab0", "succeq", Ttype.CONST, new Flag[0]), new Tuple("in", "mo", "\u2208", null, Ttype.CONST, new Flag[0]), new Tuple("!in", "mo", "\u2209", "notin", Ttype.CONST, new Flag[0]), new Tuple("sub", "mo", "\u2282", "subset", Ttype.CONST, new Flag[0]), new Tuple("sup", "mo", "\u2283", "supset", Ttype.CONST, new Flag[0]), new Tuple("sube", "mo", "\u2286", "subseteq", Ttype.CONST, new Flag[0]), new Tuple("supe", "mo", "\u2287", "supseteq", Ttype.CONST, new Flag[0]), new Tuple("-=", "mo", "\u2261", "equiv", Ttype.CONST, new Flag[0]), new Tuple("~=", "mo", "\u2245", "stackrel{\\sim}{=}", Ttype.CONST, new Flag[]{Flag.NOTEXCOPY}), new Tuple("cong", "mo", "~=", null, Ttype.DEFINITION, new Flag[0]), new Tuple("~", "mo", "\u223c", "sim", Ttype.CONST, new Flag[0]), new Tuple("~~", "mo", "\u2248", "approx", Ttype.CONST, new Flag[0]), new Tuple("prop", "mo", "\u221d", "propto", Ttype.CONST, new Flag[0]), new Tuple("and", "mtext", "and", null, Ttype.SPACE, new Flag[0]), new Tuple("or", "mtext", "or", null, Ttype.SPACE, new Flag[0]), new Tuple("not", "mo", "\u00ac", "neg", Ttype.CONST, new Flag[0]), new Tuple("=>", "mo", "\u21d2", "Rightarrow", Ttype.CONST, new Flag[0]), new Tuple("implies", "mo", "=>", null, Ttype.DEFINITION, new Flag[0]), new Tuple("if", "mo", "if", null, Ttype.SPACE, new Flag[0]), new Tuple("<=>", "mo", "\u21d4", "Leftrightarrow", Ttype.CONST, new Flag[0]), new Tuple("iff", "mo", "<=>", null, Ttype.DEFINITION, new Flag[0]), new Tuple("AA", "mo", "\u2200", "forall", Ttype.CONST, new Flag[0]), new Tuple("EE", "mo", "\u2203", "exists", Ttype.CONST, new Flag[0]), new Tuple("_|_", "mo", "\u22a5", "bot", Ttype.CONST, new Flag[0]), new Tuple("TT", "mo", "\u22a4", "top", Ttype.CONST, new Flag[0]), new Tuple("|--", "mo", "\u22a2", "vdash", Ttype.CONST, new Flag[0]), new Tuple("|==", "mo", "\u22a8", "models", Ttype.CONST, new Flag[0]), new Tuple("(", "mo", "(", null, Ttype.LEFTBRACKET, new Flag[]{Flag.VAL}), new Tuple(")", "mo", ")", null, Ttype.RIGHTBRACKET, new Flag[]{Flag.VAL}), new Tuple("[", "mo", "[", null, Ttype.LEFTBRACKET, new Flag[]{Flag.VAL}), new Tuple("]", "mo", "]", null, Ttype.RIGHTBRACKET, new Flag[]{Flag.VAL}), new Tuple("left(", "mo", "(", "(", Ttype.LEFTBRACKET, new Flag[]{Flag.VAL, Flag.NOTEXCOPY}), new Tuple("right)", "mo", ")", ")", Ttype.RIGHTBRACKET, new Flag[]{Flag.VAL, Flag.NOTEXCOPY}), new Tuple("left[", "mo", "[", "[", Ttype.LEFTBRACKET, new Flag[]{Flag.VAL, Flag.NOTEXCOPY}), new Tuple("right]", "mo", "]", "]", Ttype.RIGHTBRACKET, new Flag[]{Flag.VAL, Flag.NOTEXCOPY}), new Tuple("{", "mo", "{", "lbrace", Ttype.LEFTBRACKET, new Flag[0]), new Tuple("}", "mo", "}", "rbrace", Ttype.RIGHTBRACKET, new Flag[0]), new Tuple("|", "mo", "|", null, Ttype.LEFTRIGHT, new Flag[]{Flag.VAL}), new Tuple("|:", "mo", "|", "|", Ttype.LEFTRIGHT, new Flag[]{Flag.VAL, Flag.NOTEXCOPY}), new Tuple(":|", "mo", "|", "|", Ttype.RIGHTBRACKET, new Flag[]{Flag.VAL, Flag.NOTEXCOPY}), new Tuple(":|:", "mo", "|", "|", Ttype.CONST, new Flag[]{Flag.VAL, Flag.NOTEXCOPY}), new Tuple("(:", "mo", "\u2329", "langle", Ttype.LEFTBRACKET, new Flag[0]), new Tuple(":)", "mo", "\u232a", "rangle", Ttype.RIGHTBRACKET, new Flag[0]), new Tuple("<<", "mo", "\u2329", "langle", Ttype.LEFTBRACKET, new Flag[0]), new Tuple(">>", "mo", "\u232a", "rangle", Ttype.RIGHTBRACKET, new Flag[0]), new Tuple("{:", "mo", "{:", null, Ttype.LEFTBRACKET, new Flag[]{Flag.INVISIBLE}), new Tuple(":}", "mo", ":}", null, Ttype.RIGHTBRACKET, new Flag[]{Flag.INVISIBLE}), new Tuple("int", "mo", "\u222b", null, Ttype.CONST, new Flag[0]), new Tuple("dx", "mi", "{:d x:}", null, Ttype.DEFINITION, new Flag[0]), new Tuple("dy", "mi", "{:d y:}", null, Ttype.DEFINITION, new Flag[0]), new Tuple("dz", "mi", "{:d z:}", null, Ttype.DEFINITION, new Flag[0]), new Tuple("dt", "mi", "{:d t:}", null, Ttype.DEFINITION, new Flag[0]), new Tuple("oint", "mo", "\u222e", null, Ttype.CONST, new Flag[0]), new Tuple("del", "mo", "\u2202", "partial", Ttype.CONST, new Flag[0]), new Tuple("grad", "mo", "\u2207", "nabla", Ttype.CONST, new Flag[0]), new Tuple("+-", "mo", "\u00b1", "pm", Ttype.CONST, new Flag[0]), new Tuple("-+", "mo", "\u2213", "mp", Ttype.CONST, new Flag[0]), new Tuple("O/", "mo", "\u2205", "emptyset", Ttype.CONST, new Flag[0]), new Tuple("oo", "mo", "\u221e", "infty", Ttype.CONST, new Flag[0]), new Tuple("aleph", "mo", "\u2135", null, Ttype.CONST, new Flag[0]), new Tuple("...", "mo", "...", "ldots", Ttype.CONST, new Flag[0]), new Tuple(":.", "mo", "\u2234", "therefore", Ttype.CONST, new Flag[0]), new Tuple(":'", "mo", "\u2235", "because", Ttype.CONST, new Flag[0]), new Tuple("/_", "mo", "\u2220", "angle", Ttype.CONST, new Flag[0]), new Tuple("/_\\", "mo", "\u25b3", "triangle", Ttype.CONST, new Flag[0]), new Tuple("\\ ", "mo", "\u00a0", null, Ttype.CONST, new Flag[]{Flag.VAL}), new Tuple("frown", "mo", "\u2322", null, Ttype.CONST, new Flag[0]), new Tuple("%", "mo", "%", "%", Ttype.CONST, new Flag[]{Flag.NOTEXCOPY}), new Tuple("quad", "mo", "\u00a0\u00a0", null, Ttype.CONST, new Flag[0]), new Tuple("qquad", "mo", "\u00a0\u00a0\u00a0\u00a0", null, Ttype.CONST, new Flag[0]), new Tuple("cdots", "mo", "\u22ef", null, Ttype.CONST, new Flag[0]), new Tuple("vdots", "mo", "\u22ee", null, Ttype.CONST, new Flag[0]), new Tuple("ddots", "mo", "\u22f1", null, Ttype.CONST, new Flag[0]), new Tuple("diamond", "mo", "\u22c4", null, Ttype.CONST, new Flag[0]), new Tuple("square", "mo", "\u25a1", "boxempty", Ttype.CONST, new Flag[0]), new Tuple("|__", "mo", "\u230a", "lfloor", Ttype.CONST, new Flag[0]), new Tuple("__|", "mo", "\u230b", "rfloor", Ttype.CONST, new Flag[0]), new Tuple("|~", "mo", "\u2308", "lceil", Ttype.CONST, new Flag[0]), new Tuple("lceiling", "mo", "|~", null, Ttype.DEFINITION, new Flag[0]), new Tuple("~|", "mo", "\u2309", "rceil", Ttype.CONST, new Flag[0]), new Tuple("rceiling", "mo", "~|", null, Ttype.DEFINITION, new Flag[0]), new Tuple("CC", "mo", "\u2102", "mathbb{C}", Ttype.CONST, new Flag[]{Flag.NOTEXCOPY}), new Tuple("NN", "mo", "\u2115", "mathbb{N}", Ttype.CONST, new Flag[]{Flag.NOTEXCOPY}), new Tuple("QQ", "mo", "\u211a", "mathbb{Q}", Ttype.CONST, new Flag[]{Flag.NOTEXCOPY}), new Tuple("RR", "mo", "\u211d", "mathbb{R}", Ttype.CONST, new Flag[]{Flag.NOTEXCOPY}), new Tuple("ZZ", "mo", "\u2124", "mathbb{Z}", Ttype.CONST, new Flag[]{Flag.NOTEXCOPY}), new Tuple("f", "mi", "f", null, Ttype.UNARY, new Flag[]{Flag.FUNC, Flag.VAL}), new Tuple("g", "mi", "g", null, Ttype.UNARY, new Flag[]{Flag.FUNC, Flag.VAL}), new Tuple("prime", "mo", "\u2032", "'", Ttype.CONST, new Flag[]{Flag.VAL, Flag.NOTEXCOPY}), new Tuple("''", "mo", "''", null, Ttype.CONST, new Flag[]{Flag.VAL}), new Tuple("'''", "mo", "'''", null, Ttype.CONST, new Flag[]{Flag.VAL}), new Tuple("''''", "mo", "''''", null, Ttype.CONST, new Flag[]{Flag.VAL}), new Tuple("lim", "mo", "lim", null, Ttype.UNDEROVER, new Flag[0]), new Tuple("Lim", "mo", "Lim", null, Ttype.UNDEROVER, new Flag[0]), new Tuple("sin", "mo", "sin", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("cos", "mo", "cos", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("tan", "mo", "tan", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("arcsin", "mo", "arcsin", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("arccos", "mo", "arccos", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("arctan", "mo", "arctan", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("sinh", "mo", "sinh", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("cosh", "mo", "cosh", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("tanh", "mo", "tanh", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("cot", "mo", "cot", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("coth", "mo", "coth", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("sech", "mo", "sech", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("csch", "mo", "csch", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("sec", "mo", "sec", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("csc", "mo", "csc", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("log", "mo", "log", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("ln", "mo", "ln", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple(new String[]{"|", "|"}, "abs", "mo", "abs", null, Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple(new String[]{"\\|", "\\|"}, "norm", "mo", "norm", null, Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple(new String[]{"\\lfloor", "\\rfloor"}, "floor", "mo", "floor", null, Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple(new String[]{"\\lceil", "\\rceil"}, "ceil", "mo", "ceil", null, Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple("Sin", "mo", "Sin", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Cos", "mo", "Cos", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Tan", "mo", "Tan", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Arcsin", "mo", "Arcsin", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Arccos", "mo", "Arccos", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Arctan", "mo", "Arctan", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Sinh", "mo", "Sinh", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Cosh", "mo", "Cosh", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Tanh", "mo", "Tanh", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Cot", "mo", "Cot", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Sec", "mo", "Sec", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Csc", "mo", "Csc", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Log", "mo", "Log", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("Ln", "mo", "Ln", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple(new String[]{"|", "|"}, "Abs", "mo", "abs", null, Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple("det", "mo", "det", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("exp", "mo", "exp", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("dim", "mo", "dim", null, Ttype.CONST, new Flag[0]), new Tuple("mod", "mo", "mod", "text{mod}", Ttype.CONST, new Flag[]{Flag.NOTEXCOPY}), new Tuple("gcd", "mo", "gcd", null, Ttype.UNARY, new Flag[]{Flag.FUNC}), new Tuple("lcm", "mo", "lcm", "text{lcm}", Ttype.UNARY, new Flag[]{Flag.FUNC, Flag.NOTEXCOPY}), new Tuple("lub", "mo", "lub", null, Ttype.CONST, new Flag[0]), new Tuple("glb", "mo", "glb", null, Ttype.CONST, new Flag[0]), new Tuple("min", "mo", "min", null, Ttype.UNDEROVER, new Flag[0]), new Tuple("max", "mo", "max", null, Ttype.UNDEROVER, new Flag[0]), new Tuple("uarr", "mo", "\u2191", "uparrow", Ttype.CONST, new Flag[0]), new Tuple("darr", "mo", "\u2193", "downarrow", Ttype.CONST, new Flag[0]), new Tuple("rarr", "mo", "\u2192", "rightarrow", Ttype.CONST, new Flag[0]), new Tuple("->", "mo", "\u2192", "to", Ttype.CONST, new Flag[0]), new Tuple(">->", "mo", "\u21a3", "rightarrowtail", Ttype.CONST, new Flag[0]), new Tuple("->>", "mo", "\u21a0", "twoheadrightarrow", Ttype.CONST, new Flag[0]), new Tuple(">->>", "mo", "\u2916", "twoheadrightarrowtail", Ttype.CONST, new Flag[0]), new Tuple("|->", "mo", "\u21a6", "mapsto", Ttype.CONST, new Flag[0]), new Tuple("larr", "mo", "\u2190", "leftarrow", Ttype.CONST, new Flag[0]), new Tuple("harr", "mo", "\u2194", "leftrightarrow", Ttype.CONST, new Flag[0]), new Tuple("uArr", "mo", "\u21d1", "Uparrow", Ttype.CONST, new Flag[0]), new Tuple("dArr", "mo", "\u21d3", "Downarrow", Ttype.CONST, new Flag[0]), new Tuple("rArr", "mo", "\u21d2", "Rightarrow", Ttype.CONST, new Flag[0]), new Tuple("lArr", "mo", "\u21d0", "Leftarrow", Ttype.CONST, new Flag[0]), new Tuple("hArr", "mo", "\u21d4", "Leftrightarrow", Ttype.CONST, new Flag[0]), aAMsqrt, aAMroot, aAMfrac, aAMdiv, aAMover, aAMsub, aAMsup, new Tuple("cancel", "menclose", "cancel", null, Ttype.UNARY, new Flag[0]), new Tuple("Sqrt", "msqrt", "sqrt", null, Ttype.UNARY, new Flag[0]), new Tuple("hat", "mover", "^", null, Ttype.UNARY, new Flag[]{Flag.ACC}), new Tuple("bar", "mover", "\u00af", "overline", Ttype.UNARY, new Flag[]{Flag.ACC}), new Tuple("vec", "mover", "\u2192", null, Ttype.UNARY, new Flag[]{Flag.ACC}), new Tuple("tilde", "mover", "~", null, Ttype.UNARY, new Flag[]{Flag.ACC}), new Tuple("dot", "mover", ".", null, Ttype.UNARY, new Flag[]{Flag.ACC}), new Tuple("ddot", "mover", "..", null, Ttype.UNARY, new Flag[]{Flag.ACC}), new Tuple("overarc", "mover", "\u23dc", "stackrel{\\frown}", Ttype.UNARY, new Flag[]{Flag.ACC, Flag.NOTEXCOPY}), new Tuple("overparen", "mover", "\u23dc", "stackrel{\\frown}", Ttype.UNARY, new Flag[]{Flag.ACC, Flag.NOTEXCOPY}), new Tuple("ul", "munder", "\u0332", "underline", Ttype.UNARY, new Flag[]{Flag.ACC}), new Tuple("ubrace", "munder", "\u23df", "underbrace", Ttype.UNARY, new Flag[]{Flag.ACC}), new Tuple("obrace", "mover", "\u23de", "overbrace", Ttype.UNARY, new Flag[]{Flag.ACC}), aAMtext, aAMmbox, aAMquote, new Tuple("color", "mstyle", null, null, Ttype.BINARY, new Flag[0]), new Tuple("bb", "mstyle", "bb", "mathbf", Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple("mathbf", "mstyle", "mathbf", null, Ttype.UNARY, new Flag[0]), new Tuple("sf", "mstyle", "sf", "mathsf", Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple("mathsf", "mstyle", "mathsf", null, Ttype.UNARY, new Flag[0]), new Tuple("bbb", "mstyle", "bbb", "mathbb", Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple("mathbb", "mstyle", "mathbb", null, Ttype.UNARY, new Flag[0]), new Tuple("cc", "mstyle", "cc", "mathcal", Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple("mathcal", "mstyle", "mathcal", null, Ttype.UNARY, new Flag[0]), new Tuple("tt", "mstyle", "tt", "mathtt", Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple("mathtt", "mstyle", "mathtt", null, Ttype.UNARY, new Flag[0]), new Tuple("fr", "mstyle", "fr", "mathfrak", Ttype.UNARY, new Flag[]{Flag.NOTEXCOPY}), new Tuple("mathfrak", "mstyle", "mathfrak", null, Ttype.UNARY, new Flag[0]), new Tuple("newline", "mo", "newline", "\\\\", Ttype.CONST, new Flag[]{Flag.VAL, Flag.NOTEXCOPY})));
    private static String[] aAMnames;

    private String slice(String str, int start, int end) {
        if (end > str.length()) {
            return str.substring(start);
        }
        return str.substring(start, end);
    }

    private String slice(String str, int start) {
        return str.substring(start);
    }

    private String substr(String str, int pos, int len) {
        if (pos + len > str.length()) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }

    private static void aAMinitSymbols() {
        int symlen = aAMsymbols.size();
        for (int i = 0; i < symlen; ++i) {
            if (aAMsymbols.get(i).tex == null || aAMsymbols.get(i).hasFlag(Flag.NOTEXCOPY)) continue;
            Tuple tmp = aAMsymbols.get(i).hasFlag(Flag.ACC) ? new Tuple(aAMsymbols.get(i).tex, aAMsymbols.get(i).tag, aAMsymbols.get(i).output, null, aAMsymbols.get(i).ttype, new Flag[]{Flag.ACC}) : new Tuple(aAMsymbols.get(i).tex, aAMsymbols.get(i).tag, aAMsymbols.get(i).output, null, aAMsymbols.get(i).ttype, new Flag[0]);
            aAMsymbols.add(tmp);
        }
        ASCIIMathTeXImg.refreshSymbols();
    }

    private static void refreshSymbols() {
        Collections.sort(aAMsymbols, (o1, o2) -> ((Tuple)o1).input.compareTo(((Tuple)o2).input));
        aAMnames = new String[aAMsymbols.size()];
        for (int i = 0; i < aAMsymbols.size(); ++i) {
            ASCIIMathTeXImg.aAMnames[i] = aAMsymbols.get(i).input;
        }
    }

    private String aAMremoveCharsAndBlanks(String str, int n) {
        int i;
        String st = str.length() > 1 && str.length() > n && str.charAt(n) == '\\' && str.charAt(n + 1) != '\\' && str.charAt(n + 1) != ' ' ? this.slice(str, n + 1) : this.slice(str, n);
        for (i = 0; i < st.length() && st.charAt(i) <= ' '; ++i) {
        }
        return this.slice(st, i);
    }

    private int aAMposition(String[] arr, String str, int n) {
        int i = 0;
        if (n == 0) {
            n = -1;
            int h = arr.length;
            while (n + 1 < h) {
                int m = n + h >> 1;
                if (arr[m].compareTo(str) < 0) {
                    n = m;
                    continue;
                }
                h = m;
            }
            return h;
        }
        for (i = n; i < arr.length && arr[i].compareTo(str) < 0; ++i) {
        }
        return i;
    }

    private Tuple aAMgetSymbol(String str) {
        String tagst;
        String st;
        int k = 0;
        int j = 0;
        int mk = 0;
        String match = "";
        boolean more = true;
        for (int i = 1; i <= str.length() && more; ++i) {
            st = str.substring(0, i);
            k = this.aAMposition(aAMnames, st, j = k);
            if (k < aAMnames.length && this.slice(str, 0, aAMnames[k].length()).equals(aAMnames[k])) {
                match = aAMnames[k];
                mk = k;
                i = match.length();
            }
            more = k < aAMnames.length && this.slice(str, 0, aAMnames[k].length()).compareTo(aAMnames[k]) >= 0;
        }
        this.aAMpreviousSymbol = this.aAMcurrentSymbol;
        if (!match.equals("")) {
            this.aAMcurrentSymbol = aAMsymbols.get(mk).ttype;
            return aAMsymbols.get(mk);
        }
        this.aAMcurrentSymbol = Ttype.CONST;
        st = this.slice(str, 0, 1);
        boolean integ = true;
        for (k = 1; "0".compareTo(st) <= 0 && st.compareTo("9") <= 0 && k <= str.length(); ++k) {
            st = this.slice(str, k, k + 1);
        }
        if (st.equals(".") && "0".compareTo(st = this.slice(str, k, k + 1)) <= 0 && st.compareTo("9") <= 0) {
            integ = false;
            ++k;
            while ("0".compareTo(st) <= 0 && st.compareTo("9") <= 0 && k <= str.length()) {
                st = this.slice(str, k, k + 1);
                ++k;
            }
        }
        if (integ && k > 1 || k > 2) {
            st = this.slice(str, 0, k - 1);
            tagst = "mn";
        } else {
            st = this.slice(str, 0, 1);
            String string = tagst = !("A".compareTo(st) <= 0 && st.compareTo("Z") <= 0 || "a".compareTo(st) <= 0 && st.compareTo("z") <= 0) ? "mo" : "mi";
        }
        if (st.equals("-") && str.length() > 1 && str.charAt(1) != ' ' && this.aAMpreviousSymbol == Ttype.INFIX) {
            this.aAMcurrentSymbol = Ttype.INFIX;
            return new Tuple(st, tagst, st, null, Ttype.UNARY, new Flag[]{Flag.FUNC, Flag.VAL});
        }
        return new Tuple(st, tagst, st, null, Ttype.CONST, new Flag[]{Flag.VAL});
    }

    private String aAMTremoveBrackets(String node) {
        if (node.length() > 1 && node.charAt(0) == '{' && node.charAt(node.length() - 1) == '}') {
            int leftchop = 0;
            String st = this.substr(node, 1, 5);
            if (st.equals("\\left")) {
                st = "" + node.charAt(6);
                if (st.equals("(") || st.equals("[") || st.equals("{")) {
                    leftchop = 7;
                } else {
                    st = this.substr(node, 6, 7);
                    if (st.equals("\\lbrace")) {
                        leftchop = 13;
                    }
                }
            } else {
                st = "" + node.charAt(1);
                if (st.equals("(") || st.equals("[")) {
                    leftchop = 2;
                }
            }
            if (leftchop > 0 && node.length() > 8) {
                st = node.substring(node.length() - 8);
                if (st.equals("\\right)}") || st.equals("\\right]}") || st.equals("\\right.}")) {
                    node = "{" + node.substring(leftchop);
                    node = node.substring(0, node.length() - 8) + "}";
                } else if (st.equals("\\rbrace}")) {
                    node = "{" + node.substring(leftchop);
                    node = node.substring(0, node.length() - 14) + "}";
                }
            }
        }
        return node;
    }

    private String aAMTgetTeXsymbol(Tuple symb) {
        String pre = symb.hasFlag(Flag.VAL) ? "" : "\\";
        if (symb.tex == null) {
            return pre + symb.input;
        }
        return pre + symb.tex;
    }

    private String[] aAMTparseSexpr(String str) {
        String newFrag = "";
        Tuple symbol = this.aAMgetSymbol(str = this.aAMremoveCharsAndBlanks(str, 0));
        if (symbol == null || symbol.ttype == Ttype.RIGHTBRACKET && this.aAMnestingDepth > 0) {
            return new String[]{null, str};
        }
        if (symbol.ttype == Ttype.DEFINITION) {
            str = symbol.output + this.aAMremoveCharsAndBlanks(str, symbol.input.length());
            symbol = this.aAMgetSymbol(str);
        }
        switch (symbol.ttype) {
            case UNDEROVER: 
            case CONST: {
                str = this.aAMremoveCharsAndBlanks(str, symbol.input.length());
                String texsymbol = this.aAMTgetTeXsymbol(symbol);
                if (texsymbol.isEmpty() || texsymbol.charAt(0) == '\\' || symbol.tag.equals("mo")) {
                    return new String[]{texsymbol, str};
                }
                return new String[]{"{" + texsymbol + "}", str};
            }
            case LEFTBRACKET: {
                String node;
                ++this.aAMnestingDepth;
                str = this.aAMremoveCharsAndBlanks(str, symbol.input.length());
                String[] result = this.aAMTparseExpr(str, true);
                --this.aAMnestingDepth;
                int leftchop = 0;
                if (this.substr(result[0], 0, 6).equals("\\right")) {
                    String st = "" + result[0].charAt(6);
                    if (st.equals(")") || st.equals("]") || st.equals("}")) {
                        leftchop = 6;
                    } else if (st.equals(".")) {
                        leftchop = 7;
                    } else {
                        st = this.substr(result[0], 6, 7);
                        if (st.equals("\\rbrace")) {
                            leftchop = 13;
                        }
                    }
                }
                if (leftchop > 0) {
                    result[0] = result[0].substring(leftchop);
                    node = symbol.hasFlag(Flag.INVISIBLE) ? "{" + result[0] + "}" : "{" + this.aAMTgetTeXsymbol(symbol) + result[0] + "}";
                } else {
                    node = symbol.hasFlag(Flag.INVISIBLE) ? "{\\left." + result[0] + "}" : "{\\left" + this.aAMTgetTeXsymbol(symbol) + result[0] + "}";
                }
                return new String[]{node, result[1]};
            }
            case TEXT: {
                int i;
                if (symbol != aAMquote) {
                    str = this.aAMremoveCharsAndBlanks(str, symbol.input.length());
                }
                if ((i = str.charAt(0) == '{' ? str.indexOf("}") : (str.charAt(0) == '(' ? str.indexOf(")") : (str.charAt(0) == '[' ? str.indexOf("]") : (symbol == aAMquote ? str.indexOf("\"", 1) : 0)))) == -1) {
                    i = str.length();
                }
                if (i == 0) {
                    newFrag = "\\text{" + str.charAt(0) + "}";
                } else {
                    String st = str.substring(1, i);
                    if (st.charAt(0) == ' ') {
                        newFrag = "\\ ";
                    }
                    newFrag = newFrag + "\\text{" + st + "}";
                    if (st.charAt(st.length() - 1) == ' ') {
                        newFrag = newFrag + "\\ ";
                    }
                }
                if (i == str.length()) {
                    --i;
                }
                str = this.aAMremoveCharsAndBlanks(str, i + 1);
                return new String[]{newFrag, str};
            }
            case UNARY: {
                str = this.aAMremoveCharsAndBlanks(str, symbol.input.length());
                String[] result = this.aAMTparseSexpr(str);
                if (result[0] == null) {
                    return new String[]{"{" + this.aAMTgetTeXsymbol(symbol) + "}", str};
                }
                if (symbol.hasFlag(Flag.FUNC)) {
                    String st = "" + (str.isEmpty() ? "" : Character.valueOf(str.charAt(0)));
                    if (st.equals("^") || st.equals("_") || st.equals("/") || st.equals("|") || st.equals(",") || symbol.input.length() == 1 && symbol.input.matches("\\w") && !st.equals("(")) {
                        return new String[]{"{" + this.aAMTgetTeXsymbol(symbol) + "}", str};
                    }
                    String node = "{" + this.aAMTgetTeXsymbol(symbol) + "{" + result[0] + "}}";
                    return new String[]{node, result[1]};
                }
                result[0] = this.aAMTremoveBrackets(result[0]);
                if (symbol.input.equals("sqrt")) {
                    return new String[]{"\\sqrt{" + result[0] + "}", result[1]};
                }
                if (symbol.input.equals("cancel")) {
                    return new String[]{"\\cancel{" + result[0] + "}", result[1]};
                }
                if (symbol.rewriteleftright != null) {
                    return new String[]{"{\\left" + symbol.rewriteleftright[0] + result[0] + "\\right" + symbol.rewriteleftright[1] + '}', result[1]};
                }
                if (symbol.hasFlag(Flag.ACC)) {
                    return new String[]{this.aAMTgetTeXsymbol(symbol) + "{" + result[0] + "}", result[1]};
                }
                return new String[]{"{" + this.aAMTgetTeXsymbol(symbol) + "{" + result[0] + "}}", result[1]};
            }
            case BINARY: {
                str = this.aAMremoveCharsAndBlanks(str, symbol.input.length());
                String[] result = this.aAMTparseSexpr(str);
                if (result[0] == null) {
                    return new String[]{'{' + this.aAMTgetTeXsymbol(symbol) + '}', str};
                }
                result[0] = this.aAMTremoveBrackets(result[0]);
                String[] result2 = this.aAMTparseSexpr(result[1]);
                if (result2[0] == null) {
                    return new String[]{'{' + this.aAMTgetTeXsymbol(symbol) + '}', str};
                }
                result2[0] = this.aAMTremoveBrackets(result2[0]);
                newFrag = symbol.input.equals("color") ? "{\\color{" + result[0].replaceAll("[\\{\\}]", "") + "}" + result2[0] + "}" : (symbol.input.equals("root") ? "{\\sqrt[" + result[0] + "]{" + result2[0] + "}}" : "{" + this.aAMTgetTeXsymbol(symbol) + "{" + result[0] + "}{" + result2[0] + "}}");
                return new String[]{newFrag, result2[1]};
            }
            case INFIX: {
                str = this.aAMremoveCharsAndBlanks(str, symbol.input.length());
                return new String[]{symbol.output, str};
            }
            case SPACE: {
                str = this.aAMremoveCharsAndBlanks(str, symbol.input.length());
                return new String[]{"{\\quad\\text{" + symbol.input + "}\\quad}", str};
            }
            case LEFTRIGHT: {
                ++this.aAMnestingDepth;
                str = this.aAMremoveCharsAndBlanks(str, symbol.input.length());
                String[] result = this.aAMTparseExpr(str, false);
                --this.aAMnestingDepth;
                String st = "" + result[0].charAt(result[0].length() - 1);
                if (st.equals("|") && str.charAt(0) != ',') {
                    String node = "{\\left|" + result[0] + "}";
                    return new String[]{node, result[1]};
                }
                String node = "{\\mid}";
                return new String[]{node, str};
            }
        }
        str = this.aAMremoveCharsAndBlanks(str, symbol.input.length());
        return new String[]{"{" + this.aAMTgetTeXsymbol(symbol) + "}", str};
    }

    private String[] aAMTparseIexpr(String str) {
        str = this.aAMremoveCharsAndBlanks(str, 0);
        Tuple sym1 = this.aAMgetSymbol(str);
        String[] result = this.aAMTparseSexpr(str);
        String node = result[0];
        str = result[1];
        Tuple symbol = this.aAMgetSymbol(str);
        if (symbol.ttype == Ttype.INFIX && !symbol.input.equals("/")) {
            Tuple sym2;
            result = this.aAMTparseSexpr(str = this.aAMremoveCharsAndBlanks(str, symbol.input.length()));
            result[0] = result[0] == null ? "{}" : this.aAMTremoveBrackets(result[0]);
            str = result[1];
            if (symbol.input.equals("_")) {
                sym2 = this.aAMgetSymbol(str);
                if (sym2.input.equals("^")) {
                    str = this.aAMremoveCharsAndBlanks(str, sym2.input.length());
                    String[] res2 = this.aAMTparseSexpr(str);
                    res2[0] = this.aAMTremoveBrackets(res2[0]);
                    str = res2[1];
                    node = "{" + node;
                    node = node + "_{" + result[0] + "}";
                    node = node + "^{" + res2[0] + "}";
                    node = node + "}";
                } else {
                    node = node + "_{" + result[0] + "}";
                }
            } else {
                node = node + "^{" + result[0] + "}";
            }
            if (sym1.hasFlag(Flag.FUNC) && (sym2 = this.aAMgetSymbol(str)).ttype != Ttype.INFIX && sym2.ttype != Ttype.RIGHTBRACKET && (sym1.input.length() > 1 || sym2.ttype == Ttype.LEFTBRACKET)) {
                result = this.aAMTparseIexpr(str);
                node = "{" + node + result[0] + "}";
                str = result[1];
            }
        }
        return new String[]{node, str};
    }

    private String[] aAMTparseExpr(String str, boolean rightbracket) {
        String node;
        Tuple symbol;
        String newFrag = "";
        boolean addedright = false;
        do {
            str = this.aAMremoveCharsAndBlanks(str, 0);
            String[] result = this.aAMTparseIexpr(str);
            node = result[0];
            str = result[1];
            symbol = this.aAMgetSymbol(str);
            if (symbol.ttype == Ttype.INFIX && symbol.input.equals("/")) {
                result = this.aAMTparseIexpr(str = this.aAMremoveCharsAndBlanks(str, symbol.input.length()));
                result[0] = result[0] == null ? "{}" : this.aAMTremoveBrackets(result[0]);
                str = result[1];
                node = this.aAMTremoveBrackets(node);
                node = "\\frac{" + node + "}";
                node = node + "{" + result[0] + "}";
                newFrag = newFrag + node;
                symbol = this.aAMgetSymbol(str);
                continue;
            }
            if (node == null) continue;
            newFrag = newFrag + node;
        } while ((symbol.ttype != Ttype.RIGHTBRACKET && (symbol.ttype != Ttype.LEFTRIGHT || rightbracket) || this.aAMnestingDepth == 0) && (symbol.output == null || !symbol.output.equals("")));
        if (symbol.ttype == Ttype.RIGHTBRACKET || symbol.ttype == Ttype.LEFTRIGHT) {
            char left;
            char right;
            int len = newFrag.length();
            if (len > 2 && newFrag.charAt(0) == '{' && newFrag.indexOf(44) > 0 && ((right = newFrag.charAt(len - 2)) == ')' || right == ']') && ((left = newFrag.charAt(6)) == '(' && right == ')' && !symbol.output.equals("}") || left == '[' && right == ']')) {
                String mxout = "";
                ArrayList<Integer> pos = new ArrayList<Integer>();
                pos.add(0);
                boolean matrix = true;
                int mxnestingd = 0;
                ArrayList<ArrayList<Integer>> subpos = new ArrayList<ArrayList<Integer>>();
                subpos.add(new ArrayList<Integer>(Arrays.asList(0)));
                int lastsubposstart = 0;
                int mxanynestingd = 0;
                String columnaligns = "";
                for (int i = 1; i < len - 1; ++i) {
                    if (newFrag.charAt(i) == left) {
                        ++mxnestingd;
                    }
                    if (newFrag.charAt(i) == right && --mxnestingd == 0 && i + 3 < newFrag.length() && newFrag.charAt(i + 2) == ',' && newFrag.charAt(i + 3) == '{') {
                        pos.add(i + 2);
                        lastsubposstart = i + 2;
                        while (subpos.size() <= lastsubposstart) {
                            subpos.add(null);
                        }
                        subpos.set(lastsubposstart, new ArrayList<Integer>(Arrays.asList(i + 2)));
                    }
                    if (newFrag.charAt(i) == '[' || newFrag.charAt(i) == '(' || newFrag.charAt(i) == '{') {
                        ++mxanynestingd;
                    }
                    if (newFrag.charAt(i) == ']' || newFrag.charAt(i) == ')' || newFrag.charAt(i) == '}') {
                        --mxanynestingd;
                    }
                    if (newFrag.charAt(i) == ',' && mxanynestingd == 1) {
                        ((List)subpos.get(lastsubposstart)).add(i);
                    }
                    if (mxanynestingd >= 0) continue;
                    if (lastsubposstart == i + 1) {
                        ++i;
                        continue;
                    }
                    matrix = false;
                }
                pos.add(len);
                int lastmxsubcnt = -1;
                if (mxnestingd == 0 && !pos.isEmpty() && matrix) {
                    for (int i = 0; i < pos.size() - 1; ++i) {
                        int j;
                        ArrayList<String> subarr = null;
                        if (i > 0) {
                            mxout = mxout + "\\\\";
                        }
                        if (i == 0) {
                            if (((List)subpos.get((Integer)pos.get(i))).size() == 1) {
                                subarr = new ArrayList<String>(Arrays.asList(this.substr(newFrag, (Integer)pos.get(i) + 7, (Integer)pos.get(i + 1) - (Integer)pos.get(i) - 15)));
                            } else {
                                subarr = new ArrayList<String>(Arrays.asList(newFrag.substring((Integer)pos.get(i) + 7, (Integer)((List)subpos.get((Integer)pos.get(i))).get(1))));
                                for (j = 2; j < ((List)subpos.get((Integer)pos.get(i))).size(); ++j) {
                                    subarr.add(newFrag.substring((Integer)((List)subpos.get((Integer)pos.get(i))).get(j - 1) + 1, (Integer)((List)subpos.get((Integer)pos.get(i))).get(j)));
                                }
                                subarr.add(newFrag.substring((Integer)((List)subpos.get((Integer)pos.get(i))).get(((List)subpos.get((Integer)pos.get(i))).size() - 1) + 1, (Integer)pos.get(i + 1) - 8));
                            }
                        } else if (((List)subpos.get((Integer)pos.get(i))).size() == 1) {
                            subarr = new ArrayList<String>(Arrays.asList(this.substr(newFrag, (Integer)pos.get(i) + 8, (Integer)pos.get(i + 1) - (Integer)pos.get(i) - 16)));
                        } else {
                            subarr = new ArrayList<String>(Arrays.asList(newFrag.substring((Integer)pos.get(i) + 8, (Integer)((List)subpos.get((Integer)pos.get(i))).get(1))));
                            for (j = 2; j < ((List)subpos.get((Integer)pos.get(i))).size(); ++j) {
                                subarr.add(newFrag.substring((Integer)((List)subpos.get((Integer)pos.get(i))).get(j - 1) + 1, (Integer)((List)subpos.get((Integer)pos.get(i))).get(j)));
                            }
                            subarr.add(newFrag.substring((Integer)((List)subpos.get((Integer)pos.get(i))).get(((List)subpos.get((Integer)pos.get(i))).size() - 1) + 1, (Integer)pos.get(i + 1) - 8));
                        }
                        for (j = subarr.size() - 1; j >= 0; --j) {
                            if (((String)subarr.get(j)).equals("{\\mid}")) {
                                if (i == 0) {
                                    columnaligns = "|" + columnaligns;
                                }
                                subarr.remove(j);
                                continue;
                            }
                            if (i != 0) continue;
                            columnaligns = "c" + columnaligns;
                        }
                        if (lastmxsubcnt > 0 && subarr.size() != lastmxsubcnt) {
                            matrix = false;
                        } else if (lastmxsubcnt == -1) {
                            lastmxsubcnt = subarr.size();
                        }
                        for (int z = 0; z < subarr.size(); ++z) {
                            mxout = mxout + (String)subarr.get(z);
                            if (z >= subarr.size() - 1) continue;
                            mxout = mxout + "&";
                        }
                    }
                }
                mxout = "\\begin{array}{" + columnaligns + "} " + mxout + "\\end{array}";
                if (matrix) {
                    newFrag = mxout;
                }
            }
            str = this.aAMremoveCharsAndBlanks(str, symbol.input.length());
            if (!symbol.hasFlag(Flag.INVISIBLE)) {
                node = "\\right" + this.aAMTgetTeXsymbol(symbol);
                newFrag = newFrag + node;
                addedright = true;
            } else {
                newFrag = newFrag + "\\right.";
                addedright = true;
            }
        }
        if (this.aAMnestingDepth > 0 && !addedright) {
            newFrag = newFrag + "\\right.";
        }
        return new String[]{newFrag, str};
    }

    private String patchColor(String latex) {
        return latex.replace("\\color{", "\\textcolor{");
    }

    public String getTeX(String asciiMathInput) {
        this.aAMnestingDepth = 0;
        this.aAMpreviousSymbol = Ttype.CONST;
        this.aAMcurrentSymbol = Ttype.CONST;
        String result = this.aAMTparseExpr(asciiMathInput, false)[0];
        return this.patchColor(result);
    }

    static {
        ASCIIMathTeXImg.aAMinitSymbols();
    }

    static class Tuple {
        private final String input;
        private final String tag;
        private final String output;
        private final String tex;
        private final Ttype ttype;
        private final String[] rewriteleftright;
        private final Collection<Flag> flags;

        private Tuple(String[] rewriteleftright, String input, String tag, String output, String tex, Ttype ttype, Flag ... flags) {
            this.input = input;
            this.tag = tag;
            this.output = output;
            this.tex = tex;
            this.ttype = ttype;
            this.flags = Arrays.asList(flags);
            this.rewriteleftright = rewriteleftright;
        }

        private Tuple(String input, String tag, String output, String tex, Ttype ttype, Flag ... flags) {
            this.input = input;
            this.tag = tag;
            this.output = output;
            this.tex = tex;
            this.ttype = ttype;
            this.flags = Arrays.asList(flags);
            this.rewriteleftright = null;
        }

        public boolean hasFlag(Flag flagName) {
            return this.flags.contains((Object)flagName);
        }
    }

    private static enum Flag {
        ACC,
        VAL,
        FUNC,
        INVISIBLE,
        NOTEXCOPY;

    }

    private static enum Ttype {
        CONST,
        UNARY,
        BINARY,
        INFIX,
        LEFTBRACKET,
        RIGHTBRACKET,
        SPACE,
        UNDEROVER,
        DEFINITION,
        LEFTRIGHT,
        TEXT;

    }
}

