# Artifacts Summary - HL7 v2.9.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [V2CodeSystem](StructureDefinition-V2CodeSystem.md) | Profile for CodeSystem instances generated in this guide. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Codesystem tableNo](StructureDefinition-codesystem-tableNo.md) | extension for tableNo |
| [Codesystem v2versionCreated](StructureDefinition-codesystem-v2versionCreated.md) | extension for v2versionCreated |
| [Codesystem versionHistory](StructureDefinition-codesystem-versionHistory.md) | extension for versionHistory |
| [Codesystem versionIntroduced](StructureDefinition-codesystem-versionIntroduced.md) | extension for versionIntroduced |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Alternate Character Sets (2.9.1 - 1.4.3)](ValueSet-hl7VSalternateCharacterSets.md) | Value Set of codes that identify one of a number of possible standard alternate character sets for a message, either single-byte or double-byte. |
| [Coding System (2.9.1 - 1.10.0)](ValueSet-hl7VScodingSystem.md) | Names of coding systems. Each coding system is assigned a unique identifier, which is generally a short mnemonic derived from the full name of the coding system. |
| [Data Types (2.9.1 - 1.2.2)](ValueSet-hl7VSdataTypes.md) | Value Set of codes specifying the data type. |
| [Gender Harmony Concepts (2.9.1 - 1.0.0)](ValueSet-hl7VSgenderHarmonyConcepts.md) | tbd |
| [Identifier Type (2.9.1 - 1.7.0)](ValueSet-hl7VSidentifierType.md) | Concepts specifying types of identififiers, as used in person and organization identification datatypes in HL7 Version 2 standards. |
| [Message Structure (2.9.1 - 7.5.0)](ValueSet-hl7VSmessageStructure.md) | HL7 abstract message structure codes. |
| [Message Type (2.9.1 - 1.10.0)](ValueSet-hl7VSmessageType.md) | Concepts which specify message types for HL7 Version 2.x messaging. |
| [Segment Group (2.9.1 - 9.0.1)](ValueSet-hl7VSsegmentGroup.md) | Value Set of codes that specify the optional segment groups which are to be included in a response. |
| [Sexual Orientation (2.9.1 - 1.0.0)](ValueSet-Sexual_Orientation.md) | Concepts specifying a person’s sexual orientation. Used in HL7 Version 2.x messages in the GSP segment. |
| [Telecommunication Equipment Type (2.9.1 - 1.3.0)](ValueSet-hl7VStelecommunicationEquipmentType.md) | Concepts for specifying a type of telecommunication equipment. |
| [Telecommunication Use Code (2.9.1 - 1.3.0)](ValueSet-hl7VStelecommunicationUseCode.md) | Concepts for specifying a specific use of a telecommunication number. |
| [Version ID (2.9.1 - 1.14.0)](ValueSet-hl7VSversionControlTable.md) | Concepts which are used to identify an HL7 version in the Version 2.x family of published standards. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Alternate Character Sets (2.9.1 - 1.4.3)](CodeSystem-alternateCharacterSets.md) | HL7-defined code system of concepts used to specify the character set(s) in use. Includes both single-byte and double-byte characters sets, and used in Version 2.x messaging in the MSH segment. |
| [Coding System (2.9.1 - 1.10.0)](CodeSystem-codingSystem.md) | HL7-defined code system of concepts specifying the coding system. This table is maintained outside of the published Version 2 standards, and may be found at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm. Used in HL7 Version 2.x messaging in the CWE segment. |
| [Data Types (2.9.1 - 1.2.2)](CodeSystem-dataTypes.md) | HL7-defined code system of concepts specifying the format of the observation value in the Observation Result (OBX). Used in HL7 Version 2.x messaging in the OBX, OM1, OM3 and OMC segments. |
| [Gender Harmony Concepts (2.9.1 - 1.0.0)](CodeSystem-loinc.md) | See http://loinc.org for a detailed description; the HL70396 code for LOINC is ‘LN’ |
| [Identifier Type (2.9.1 - 1.7.0)](CodeSystem-identifierType.md) | HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messaging data types CX, PLN, PPN, XCN and XON. |
| [Message Structure (2.9.1 - 7.5.0)](CodeSystem-messageStructure.md) | HL7-defined code system of abstract message structure codes. Each code identifies a specific message structure abstract syntax as published in the HL7 Version 2 standard. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Message Type (2.9.1 - 1.10.0)](CodeSystem-messageType.md) | HL7-defined code system of concepts which specify message types. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Segment Group (2.9.1 - 9.0.1)](CodeSystem-segmentGroup.md) | HL7-defined code system of concepts specifying the optional segment groups which are to be included in the response. This is a repeating field, to accommodate inclusion of multiple segment groups. The default for this field, not present, means that all relevant groups are included. Used in HL7 Version 2.x messaging in the Response Control Parameter (RCP) segment. |
| [Sexual Orientation (2.9.1 - 1.0.0)](CodeSystem-snomedct.md) | Snomed CT |
| [Telecommunication Equipment Type (2.9.1 - 1.3.0)](CodeSystem-telecommunicationEquipmentType.md) | HL7-defined code system of concepts for specifying a type of telecommunication equipment. Best practice is to use this concept whenever a telecommunication number or access string for particular equipment is specified. Used in HL7 Version 2.x messaging in the XTN segment. |
| [Telecommunication Use Code (2.9.1 - 1.3.0)](CodeSystem-telecommunicationUse.md) | HL7-defined code system of concepts for specifying a specific use of a telecommunication number. Best practice is to use this concept whenever a telecommunication number or access string is specified. Used in HL7 Version 2.x messaging in the XTN segment. |
| [Version ID (2.9.1 - 1.14.0)](CodeSystem-versionId.md) | HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x family of published standards. Used in HL7 Version 2.x messaging in the VID segment. |

