# Codesystem versionHistory - HL7 v2.9.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Codesystem versionHistory**

## Extension: Codesystem versionHistory (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory | *Version*:1.0.0 |
| Draft as of 2026-01-25 | *Computable Name*:versionHistory |

extension for versionHistory

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [AlternateCharacterSets](CodeSystem-alternateCharacterSets.md), [CodingSystem](CodeSystem-codingSystem.md), [DataTypes](CodeSystem-dataTypes.md), [IdentifierType](CodeSystem-identifierType.md)... Show 8 more, [Loinc](CodeSystem-loinc.md), [MessageStructure](CodeSystem-messageStructure.md), [MessageType](CodeSystem-messageType.md), [SegmentGroup](CodeSystem-segmentGroup.md), [Snomedct](CodeSystem-snomedct.md), [TelecommunicationEquipmentType](CodeSystem-telecommunicationEquipmentType.md), [TelecommunicationUse](CodeSystem-telecommunicationUse.md) and [VersionId](CodeSystem-versionId.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.v2.uv.terminology.v291|current/StructureDefinition/codesystem-versionHistory)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-codesystem-versionHistory.csv), [Excel](StructureDefinition-codesystem-versionHistory.xlsx), [Schematron](StructureDefinition-codesystem-versionHistory.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "codesystem-versionHistory",
  "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
  "version" : "1.0.0",
  "name" : "versionHistory",
  "title" : "Codesystem versionHistory",
  "status" : "draft",
  "experimental" : true,
  "date" : "2026-01-25T17:51:32+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "extension for versionHistory",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "CodeSystem"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
        "isModifier" : false,
        "isSummary" : false
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
