# Sexual Orientation (2.9.1 - 1.0.0) - HL7 v2.9.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sexual Orientation (2.9.1 - 1.0.0)**

## CodeSystem: Sexual Orientation (2.9.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/snomedct | *Version*:1.0.0 |
| Active as of 2026-01-25 | *Computable Name*:Snomedct |
| *Other Identifiers:*OID:2.16.840.1.113883.6.96 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Snomed CT 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Sexual_Orientation](ValueSet-Sexual_Orientation.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "snomedct",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0823"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/snomedct",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.6.96"
    }
  ],
  "version" : "1.0.0",
  "name" : "Snomedct",
  "title" : "Sexual Orientation (2.9.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-25T17:51:32+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Snomed CT",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "20430005",
      "display" : "heterosexual",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The HL70396 code for this code is ‘SCT’"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-28"
        }
      ]
    },
    {
      "code" : "42035005",
      "display" : "Bisexual",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The HL70396 code for this code is ‘SCT’"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-28"
        }
      ]
    },
    {
      "code" : "89217008",
      "display" : "Lesbian, gay or homosexual",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "The HL70396 code for this code is ‘SCT’"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-28"
        }
      ]
    },
    {
      "code" : "UNK",
      "display" : "Unknown",
      "definition" : "A proper value is applicable, but not known.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This means the actual value is not known. If the only thing that is unknown is how to properly express the value in the necessary constraints (value set, datatype, etc.), then the OTH or UNC flavor should be used. No properties should be included for a datatype with this property unless:\r\n1. Those properties themselves directly translate to a semantic of \"unknown\". (E.g. a local code sent as a translation that conveys 'unknown')\r\n2. Those properties further qualify the nature of what is unknown. (E.g. specifying a use code of \"H\" and a URL prefix of \"tel:\" to convey that it is the home phone number that is unknown.)\r\n\r\nThis code is drawn from V3 Null Flavor (http://terminology.hl7.org/CodeSystem/v3-NullFlavor).\r\nThe HL70396 code for this code is ‘NULLFL’"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2023-08-18"
        }
      ]
    },
    {
      "code" : "asked-declined",
      "display" : "Asked But Declined",
      "definition" : "The source was asked but declined to answer.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This code is drawn from FHIR DataAbsentReason (http://terminology.hl7.org/CodeSystem/data-absent-reason).\r\nThe HL70396 code for this code is ‘DAR’"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2023-08-18"
        }
      ]
    }
  ]
}

```
