# Gender Harmony Concepts (2.9.1 - 1.0.0) - HL7 v2.9.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Gender Harmony Concepts (2.9.1 - 1.0.0)**

## CodeSystem: Gender Harmony Concepts (2.9.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/loinc | *Version*:1.0.0 |
| Active as of 2026-01-25 | *Computable Name*:Loinc |
| *Other Identifiers:*OID:2.16.840.1.113883.6.1 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
See http://loinc.org for a detailed description; the HL70396 code for LOINC is ‘LN’ 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSgenderHarmonyConcepts](ValueSet-hl7VSgenderHarmonyConcepts.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "loinc",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0820"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/loinc",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.6.1"
    }
  ],
  "version" : "1.0.0",
  "name" : "Loinc",
  "title" : "Gender Harmony Concepts (2.9.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-25T17:51:32+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "See http://loinc.org for a detailed description; the HL70396 code for LOINC is ‘LN’",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "76690-7",
      "display" : "Sexual Orientation",
      "definition" : "https://loinc.org/76690-7/",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The HL70396 code for LOINC is ‘LN’"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-28"
        }
      ]
    },
    {
      "code" : "76691-5",
      "display" : "Gender Identity",
      "definition" : "https://loinc.org/76691-5/",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The HL70396 code for LOINC is ‘LN’"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-28"
        }
      ]
    },
    {
      "code" : "90778-2",
      "display" : "Personal pronouns - Reported",
      "definition" : "https://loinc.org/90778-2/",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The HL70396 code for LOINC is ‘LN’"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-28"
        }
      ]
    }
  ]
}

```
