# Message Type (2.9.1 - 1.10.0) - HL7 v2.9.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Message Type (2.9.1 - 1.10.0)**

## CodeSystem: Message Type (2.9.1 - 1.10.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/messageType | *Version*:1.10.0 |
| Active as of 2026-01-25 | *Computable Name*:MessageType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.30 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify message types. Used in HL7 Version 2.x messaging in the MSH segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmessageType](ValueSet-hl7VSmessageType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "messageType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0076"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/messageType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.30"
    }
  ],
  "version" : "1.10.0",
  "name" : "MessageType",
  "title" : "Message Type (2.9.1 - 1.10.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-25T17:51:32+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify message types.  Used in HL7 Version 2.x messaging in the MSH segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "chapter",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#chapter",
      "description" : "chapter",
      "type" : "string"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VShl7VSevent"
        }
      ],
      "code" : "event",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#event",
      "description" : "event",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "1081",
      "code" : "ACK",
      "display" : "General acknowledgment message",
      "definition" : "General acknowledgment message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "2"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "2"
        }
      ]
    },
    {
      "id" : "1082",
      "code" : "ADR",
      "display" : "ADT response",
      "definition" : "ADT response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage bezüglich Aufnahme / Verlegung / Entlassung von Patienten"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "3 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "3"
        }
      ]
    },
    {
      "id" : "1084",
      "code" : "ADT",
      "display" : "ADT message",
      "definition" : "ADT message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Aufnahme / Entlassung / Verlegung"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "3"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "3"
        }
      ]
    },
    {
      "id" : "1085",
      "code" : "BAR",
      "display" : "Add/change billing account",
      "definition" : "Add/change billing account",
      "designation" : [
        {
          "language" : "de",
          "value" : "Hinzufügen / Ändern von Abrechnungsdaten"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "6"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "6"
        }
      ]
    },
    {
      "id" : "1086",
      "code" : "BPS",
      "display" : "Blood product dispense status message",
      "definition" : "Blood product dispense status message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1088",
      "code" : "BRP",
      "display" : "Blood product dispense status acknowledgement message",
      "definition" : "Blood product dispense status acknowledgement message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1089",
      "code" : "BRT",
      "display" : "Blood product transfusion/disposition acknowledgement message",
      "definition" : "Blood product transfusion/disposition acknowledgement message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1090",
      "code" : "BTS",
      "display" : "Blood product transfusion/disposition message",
      "definition" : "Blood product transfusion/disposition message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1091",
      "code" : "CCF",
      "display" : "Collaborative Care Fetch",
      "definition" : "Collaborative Care Fetch",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1092",
      "code" : "CCI",
      "display" : "Collaborative Care Information",
      "definition" : "Collaborative Care Information",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1093",
      "code" : "CCM",
      "display" : "Collaborative Care Message",
      "definition" : "Collaborative Care Message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1094",
      "code" : "CCQ",
      "display" : "Collaborative Care Referral",
      "definition" : "Collaborative Care Referral",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1096",
      "code" : "CCU",
      "display" : "Collaborative Care Referral",
      "definition" : "Collaborative Care Referral",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1087",
      "code" : "CNQ",
      "display" : "Cancel query",
      "definition" : "Cancel query",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung der Anfrage"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1097",
      "code" : "CQU",
      "display" : "Collaborative Care Referral",
      "definition" : "Collaborative Care Referral",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1098",
      "code" : "CRM",
      "display" : "Clinical study registration message",
      "definition" : "Clinical study registration message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1099",
      "code" : "CSU",
      "display" : "Unsolicited study data message",
      "definition" : "Unsolicited study data message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1101",
      "code" : "DBC",
      "display" : "Create Donor Record",
      "definition" : "Create Donor Record",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1103",
      "code" : "DBU",
      "display" : "Update Donor Record",
      "definition" : "Update Donor Record",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1105",
      "code" : "DEL",
      "display" : "Donor Eligibility",
      "definition" : "Donor Eligibility",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1106",
      "code" : "DEO",
      "display" : "Donor Eligibility Observation",
      "definition" : "Donor Eligibility Observation",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1107",
      "code" : "DER",
      "display" : "Donor Eligibility Request",
      "definition" : "Donor Eligibility Request",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1108",
      "code" : "DFT",
      "display" : "Detail financial transactions",
      "definition" : "Detail financial transactions",
      "designation" : [
        {
          "language" : "de",
          "value" : "Einzelbuchung"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "6"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "6"
        }
      ]
    },
    {
      "id" : "1109",
      "code" : "DOC",
      "display" : "Document response",
      "definition" : "Document response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "9 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "9"
        }
      ]
    },
    {
      "id" : "1110",
      "code" : "DPR",
      "display" : "Donation Procedure",
      "definition" : "Donation Procedure",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1111",
      "code" : "DRC",
      "display" : "Donor Request to Collect",
      "definition" : "Donor Request to Collect",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1112",
      "code" : "DSR",
      "display" : "Display response",
      "definition" : "Display response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort im Anzeigeformat"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1114",
      "code" : "EAC",
      "display" : "Automated equipment command message",
      "definition" : "Automated equipment command message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1115",
      "code" : "EAN",
      "display" : "Automated equipment notification message",
      "definition" : "Automated equipment notification message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1116",
      "code" : "EAR",
      "display" : "Automated equipment response message",
      "definition" : "Automated equipment response message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1100",
      "code" : "EDR",
      "display" : "Enhanced display response",
      "definition" : "Enhanced display response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1117",
      "code" : "EHC",
      "display" : "Health Care Invoice",
      "definition" : "Health Care Invoice",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "16"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "16"
        }
      ]
    },
    {
      "id" : "1102",
      "code" : "EQQ",
      "display" : "Embedded query language query",
      "definition" : "Embedded query language query",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1104",
      "code" : "ERP",
      "display" : "Event replay response",
      "definition" : "Event replay response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1095",
      "code" : "ERQ",
      "display" : "Event replay query",
      "definition" : "Event replay query",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1118",
      "code" : "ESR",
      "display" : "Automated equipment status update acknowledgment message",
      "definition" : "Automated equipment status update acknowledgment message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1119",
      "code" : "ESU",
      "display" : "Automated equipment status update message",
      "definition" : "Automated equipment status update message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1120",
      "code" : "INR",
      "display" : "Automated equipment inventory request message",
      "definition" : "Automated equipment inventory request message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1121",
      "code" : "INU",
      "display" : "Automated equipment inventory update message",
      "definition" : "Automated equipment inventory update message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1122",
      "code" : "LSR",
      "display" : "Automated equipment log/service request message",
      "definition" : "Automated equipment log/service request message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1123",
      "code" : "LSU",
      "display" : "Automated equipment log/service update message",
      "definition" : "Automated equipment log/service update message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1113",
      "code" : "MCF",
      "display" : "Delayed Acknowledgment (Retained for backward compatibility only)",
      "definition" : "Delayed Acknowledgment (Retained for backward compatibility only)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "id" : "1124",
      "code" : "MDM",
      "display" : "Medical document management",
      "definition" : "Medical document management",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "9"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "9"
        }
      ]
    },
    {
      "id" : "1125",
      "code" : "MFD",
      "display" : "Master files delayed application acknowledgment",
      "definition" : "Master files delayed application acknowledgment",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "8 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "8"
        }
      ]
    },
    {
      "id" : "1126",
      "code" : "MFK",
      "display" : "Master files application acknowledgment",
      "definition" : "Master files application acknowledgment",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "8"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "8"
        }
      ]
    },
    {
      "id" : "1127",
      "code" : "MFN",
      "display" : "Master files notification",
      "definition" : "Master files notification",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdateiänderung"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "8"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "8"
        }
      ]
    },
    {
      "id" : "1128",
      "code" : "MFQ",
      "display" : "Master files query",
      "definition" : "Master files query",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "8 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "8"
        }
      ]
    },
    {
      "id" : "1129",
      "code" : "MFR",
      "display" : "Master files response",
      "definition" : "Master files response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Stammdateianfrage"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "8 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "8"
        }
      ]
    },
    {
      "id" : "1130",
      "code" : "NMD",
      "display" : "Application management data message",
      "definition" : "Application management data message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "14"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "14"
        }
      ]
    },
    {
      "id" : "1131",
      "code" : "NMQ",
      "display" : "Application management query message",
      "definition" : "Application management query message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "14 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "14"
        }
      ]
    },
    {
      "id" : "1132",
      "code" : "NMR",
      "display" : "Application management response message",
      "definition" : "Application management response message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "14 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "14"
        }
      ]
    },
    {
      "id" : "1133",
      "code" : "OMB",
      "display" : "Blood product order message",
      "definition" : "Blood product order message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1134",
      "code" : "OMD",
      "display" : "Dietary order",
      "definition" : "Dietary order",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1135",
      "code" : "OMG",
      "display" : "General clinical order message",
      "definition" : "General clinical order message",
      "designation" : [
        {
          "language" : "de",
          "value" : "allgemeiner Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1136",
      "code" : "OMI",
      "display" : "Imaging order",
      "definition" : "Imaging order",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag für bildgebende Untersuchung"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1139",
      "code" : "OML",
      "display" : "Laboratory order message",
      "definition" : "Laboratory order message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Laborauftrag"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1140",
      "code" : "OMN",
      "display" : "Non-stock requisition order message",
      "definition" : "Non-stock requisition order message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1141",
      "code" : "OMP",
      "display" : "Pharmacy/treatment order message",
      "definition" : "Pharmacy/treatment order message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1142",
      "code" : "OMQ",
      "display" : "General order message with document payload",
      "definition" : "General order message with document payload",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1143",
      "code" : "OMS",
      "display" : "Stock requisition order message",
      "definition" : "Stock requisition order message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1144",
      "code" : "OPL",
      "display" : "Population/Location-Based Laboratory Order Message",
      "definition" : "Population/Location-Based Laboratory Order Message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1145",
      "code" : "OPR",
      "display" : "Population/Location-Based Laboratory Order Acknowledgment Message",
      "definition" : "Population/Location-Based Laboratory Order Acknowledgment Message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1146",
      "code" : "OPU",
      "display" : "Unsolicited Population/Location-Based Laboratory Observation Message",
      "definition" : "Unsolicited Population/Location-Based Laboratory Observation Message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1147",
      "code" : "ORA",
      "display" : "Observation Report Acknowledgment",
      "definition" : "Observation Report Acknowledgment",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1148",
      "code" : "ORB",
      "display" : "Blood product order acknowledgement message",
      "definition" : "Blood product order acknowledgement message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1149",
      "code" : "ORD",
      "display" : "Dietary order acknowledgment message",
      "definition" : "Dietary order acknowledgment message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1150",
      "code" : "ORF",
      "display" : "Query for results of observation",
      "definition" : "Query for results of observation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfrage nach Untersuchungsergebnissen"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1151",
      "code" : "ORG",
      "display" : "General clinical order acknowledgment message",
      "definition" : "General clinical order acknowledgment message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1152",
      "code" : "ORI",
      "display" : "Imaging order acknowledgement message",
      "definition" : "Imaging order acknowledgement message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1153",
      "code" : "ORL",
      "display" : "Laboratory acknowledgment message (unsolicited)",
      "definition" : "Laboratory acknowledgment message (unsolicited)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1154",
      "code" : "ORM",
      "display" : "Pharmacy/treatment order message",
      "definition" : "Pharmacy/treatment order message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1155",
      "code" : "ORN",
      "display" : "Non-stock requisition - General order acknowledgment message",
      "definition" : "Non-stock requisition - General order acknowledgment message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1156",
      "code" : "ORP",
      "display" : "Pharmacy/treatment order acknowledgment message",
      "definition" : "Pharmacy/treatment order acknowledgment message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1157",
      "code" : "ORR",
      "display" : "General order response message response to any ORM",
      "definition" : "General order response message response to any ORM",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung von der Anwendung für einen Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1158",
      "code" : "ORS",
      "display" : "Stock requisition - Order acknowledgment message",
      "definition" : "Stock requisition - Order acknowledgment message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1159",
      "code" : "ORU",
      "display" : "Unsolicited transmission of an observation message",
      "definition" : "Unsolicited transmission of an observation message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nicht angeforderte Untersuchungsergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1160",
      "code" : "ORX",
      "display" : "General Order Message with Document Payload Acknowledgement",
      "definition" : "General Order Message with Document Payload Acknowledgement",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1161",
      "code" : "OSM",
      "display" : "Specimen Shipment Message",
      "definition" : "Specimen Shipment Message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1162",
      "code" : "OSQ",
      "display" : "Query response for order status",
      "definition" : "Query response for order status",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1163",
      "code" : "OSR",
      "display" : "Query response for order status",
      "definition" : "Query response for order status",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1164",
      "code" : "OSU",
      "display" : "Order status update",
      "definition" : "Order status update",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1165",
      "code" : "OUL",
      "display" : "Unsolicited laboratory observation message",
      "definition" : "Unsolicited laboratory observation message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1166",
      "code" : "PEX",
      "display" : "Product experience message",
      "definition" : "Product experience message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1167",
      "code" : "PGL",
      "display" : "Patient goal message",
      "definition" : "Patient goal message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "12"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "12"
        }
      ]
    },
    {
      "id" : "1168",
      "code" : "PIN",
      "display" : "Patient insurance information",
      "definition" : "Patient insurance information",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1169",
      "code" : "PMU",
      "display" : "Add personnel record",
      "definition" : "Add personnel record",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "15"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "15"
        }
      ]
    },
    {
      "id" : "1170",
      "code" : "PPG",
      "display" : "Patient pathway message (goal-oriented)",
      "definition" : "Patient pathway message (goal-oriented)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "12"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "12"
        }
      ]
    },
    {
      "id" : "1171",
      "code" : "PPP",
      "display" : "Patient pathway message (problem-oriented)",
      "definition" : "Patient pathway message (problem-oriented)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "12"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "chapter",
          "valueString" : "12"
        }
      ]
    },
    {
      "id" : "1172",
      "code" : "PPR",
      "display" : "Patient problem message",
      "definition" : "Patient problem message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "12"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "12"
        }
      ]
    },
    {
      "id" : "1173",
      "code" : "PPT",
      "display" : "Patient pathway goal-oriented response",
      "definition" : "Patient pathway goal-oriented response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "unknown"
        }
      ]
    },
    {
      "id" : "1174",
      "code" : "PPV",
      "display" : "Patient goal response",
      "definition" : "Patient goal response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "unknown"
        }
      ]
    },
    {
      "id" : "1175",
      "code" : "PRR",
      "display" : "Patient problem response",
      "definition" : "Patient problem response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "unknown"
        }
      ]
    },
    {
      "id" : "1176",
      "code" : "PTR",
      "display" : "Patient pathway problem-oriented response",
      "definition" : "Patient pathway problem-oriented response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "unknown"
        }
      ]
    },
    {
      "id" : "1177",
      "code" : "QBP",
      "display" : "Query by parameter",
      "definition" : "Query by parameter",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1178",
      "code" : "QCK",
      "display" : "Query general acknowledgment",
      "definition" : "Deferred query",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1179",
      "code" : "QCN",
      "display" : "Cancel query",
      "definition" : "Cancel query",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1180",
      "code" : "QRY",
      "display" : "Query, original mode",
      "definition" : "Query, original mode",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "3"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "3"
        }
      ]
    },
    {
      "id" : "1181",
      "code" : "QSB",
      "display" : "Create subscription",
      "definition" : "Create subscription",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1182",
      "code" : "QSX",
      "display" : "Cancel subscription/acknowledge message",
      "definition" : "Cancel subscription/acknowledge message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1183",
      "code" : "QVR",
      "display" : "Query for previous events",
      "definition" : "Query for previous events",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1184",
      "code" : "RAR",
      "display" : "Pharmacy/treatment administration information",
      "definition" : "Pharmacy/treatment administration information",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1185",
      "code" : "RAS",
      "display" : "Pharmacy/treatment administration message",
      "definition" : "Pharmacy/treatment administration message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Erfolgte Verabreichung von Medikamenten"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1186",
      "code" : "RCI",
      "display" : "Return clinical information",
      "definition" : "Return clinical information",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1187",
      "code" : "RCL",
      "display" : "Return clinical list",
      "definition" : "Return clinical list",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1189",
      "code" : "RDE",
      "display" : "Pharmacy/treatment encoded order message",
      "definition" : "Pharmacy/treatment encoded order message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Medikamentenverordnung (Apotheke)"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1190",
      "code" : "RDR",
      "display" : "Pharmacy/treatment dispense information",
      "definition" : "Pharmacy/treatment dispense information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage bezüglich Abgabe von Medikamenten"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1191",
      "code" : "RDS",
      "display" : "Pharmacy/treatment dispense message",
      "definition" : "Pharmacy/treatment dispense message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abgabe von Medikamenten"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1192",
      "code" : "RDY",
      "display" : "Display based response",
      "definition" : "Display based response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1193",
      "code" : "REF",
      "display" : "Patient referral",
      "definition" : "Patient referral",
      "designation" : [
        {
          "language" : "de",
          "value" : "Überweisung eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1194",
      "code" : "RER",
      "display" : "Pharmacy/treatment encoded order information",
      "definition" : "Pharmacy/treatment encoded order information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage bezüglich Medikamentenverordnung (Apotheke)"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1195",
      "code" : "RGR",
      "display" : "Pharmacy/treatment dose information",
      "definition" : "Pharmacy/treatment dose information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage bezüglich Verabreichungsvorschrift für Medikamente"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1196",
      "code" : "RGV",
      "display" : "Pharmacy/treatment give message",
      "definition" : "Pharmacy/treatment give message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verabreichungsvorschrift für Medikamente"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1137",
      "code" : "ROC",
      "display" : "Request clinical information",
      "definition" : "Request clinical information",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1138",
      "code" : "ROD",
      "display" : "Request pateint demographics",
      "definition" : "Request pateint demographics",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1197",
      "code" : "ROR",
      "display" : "Pharmacy/treatment order response",
      "definition" : "Pharmacy/treatment order response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage bezüglich Medikamentenverordnung"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1199",
      "code" : "RPA",
      "display" : "Return patient authorization",
      "definition" : "Return patient authorization",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1200",
      "code" : "RPI",
      "display" : "Return patient information",
      "definition" : "Return patient information",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1201",
      "code" : "RPL",
      "display" : "Return patient display list",
      "definition" : "Return patient display list",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1202",
      "code" : "RPR",
      "display" : "Return patient list",
      "definition" : "Return patient list",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1203",
      "code" : "RQA",
      "display" : "Request patient authorization",
      "definition" : "Request patient authorization",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1204",
      "code" : "RQC",
      "display" : "Request clinical information",
      "definition" : "Request clinical information",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1205",
      "code" : "RQI",
      "display" : "Request patient information",
      "definition" : "Request patient information",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1206",
      "code" : "RQP",
      "display" : "Request patient demographics",
      "definition" : "Request patient demographics",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1188",
      "code" : "RQQ",
      "display" : "Event replay query",
      "definition" : "Event replay query",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "1207",
      "code" : "RRA",
      "display" : "Pharmacy/treatment administration acknowledgment message",
      "definition" : "Pharmacy/treatment administration acknowledgment message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung für Verabreichungsmeldung"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1208",
      "code" : "RRD",
      "display" : "Pharmacy/treatment dispense acknowledgment message",
      "definition" : "Pharmacy/treatment dispense acknowledgment message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung für Abgabemeldung"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1209",
      "code" : "RRE",
      "display" : "Pharmacy/treatment encoded order acknowledgment message",
      "definition" : "Pharmacy/treatment encoded order acknowledgment message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung für Verordnung (Apotheke)"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1210",
      "code" : "RRG",
      "display" : "Pharmacy/treatment give acknowledgment message",
      "definition" : "Pharmacy/treatment give acknowledgment message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Empfangsbestätigung für Verabreichungsvorschrift"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1212",
      "code" : "RRI",
      "display" : "Return referral information",
      "definition" : "Return referral information",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "11"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "11"
        }
      ]
    },
    {
      "id" : "1213",
      "code" : "RSP",
      "display" : "Segment pattern response",
      "definition" : "Segment pattern response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1214",
      "code" : "RTB",
      "display" : "Tabular response",
      "definition" : "Tabular response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1215",
      "code" : "SCN",
      "display" : "Notification of Anti-Microbial Device Cycle Data",
      "definition" : "Notification of Anti-Microbial Device Cycle Data",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "17"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "17"
        }
      ]
    },
    {
      "id" : "1216",
      "code" : "SDN",
      "display" : "Notification of Anti-Microbial Device Data",
      "definition" : "Notification of Anti-Microbial Device Data",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "17"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "17"
        }
      ]
    },
    {
      "id" : "1217",
      "code" : "SDR",
      "display" : "Sterilization anti-microbial device data request",
      "definition" : "Sterilization anti-microbial device data request",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "17"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "17"
        }
      ]
    },
    {
      "id" : "1218",
      "code" : "SET",
      "display" : "Specimen Event Tracking",
      "definition" : "This message type is used to report how the specimen moves through its lifecycle from collection, identification, transport, acceptance or rejection, processing to storage and disposition.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "1219",
      "code" : "SIU",
      "display" : "Schedule information unsolicited",
      "definition" : "Schedule information unsolicited",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "10"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "10"
        }
      ]
    },
    {
      "id" : "1220",
      "code" : "SLN",
      "display" : "Notification of New Sterilization Lot",
      "definition" : "Notification of New Sterilization Lot",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "17"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "17"
        }
      ]
    },
    {
      "id" : "1221",
      "code" : "SLR",
      "display" : "Sterilization lot request",
      "definition" : "Sterilization lot request",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "17"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "17"
        }
      ]
    },
    {
      "id" : "1222",
      "code" : "SMD",
      "display" : "Sterilization anti-microbial device cycle data request",
      "definition" : "Sterilization anti-microbial device cycle data request",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "17"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "17"
        }
      ]
    },
    {
      "id" : "1198",
      "code" : "SPQ",
      "display" : "Stored procedure request",
      "definition" : "Stored procedure request",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-10-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1223",
      "code" : "SQM",
      "display" : "Schedule query message",
      "definition" : "Schedule query message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "10 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "10"
        }
      ]
    },
    {
      "id" : "1224",
      "code" : "SQR",
      "display" : "Schedule query response",
      "definition" : "Schedule query response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "10 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "10"
        }
      ]
    },
    {
      "id" : "1225",
      "code" : "SRM",
      "display" : "Schedule request message",
      "definition" : "Schedule request message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "10"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "10"
        }
      ]
    },
    {
      "id" : "1226",
      "code" : "SRR",
      "display" : "Scheduled request response",
      "definition" : "Scheduled request response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "10"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "10"
        }
      ]
    },
    {
      "id" : "1227",
      "code" : "SSR",
      "display" : "Specimen status request message",
      "definition" : "Specimen status request message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1228",
      "code" : "SSU",
      "display" : "Specimen status update message",
      "definition" : "Specimen status update message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1229",
      "code" : "STC",
      "display" : "Notification of Sterilization Configuration",
      "definition" : "Notification of Sterilization Configuration",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "17"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "17"
        }
      ]
    },
    {
      "id" : "1230",
      "code" : "STI",
      "display" : "Sterilization item request",
      "definition" : "Sterilization item request",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "17"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        },
        {
          "code" : "chapter",
          "valueString" : "17"
        }
      ]
    },
    {
      "id" : "1231",
      "code" : "SUR",
      "display" : "Summary product experience report",
      "definition" : "Summary product experience report",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "7 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "chapter",
          "valueString" : "7"
        }
      ]
    },
    {
      "id" : "1232",
      "code" : "TBR",
      "display" : "Tabular data response",
      "definition" : "Tabular data response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1233",
      "code" : "TCR",
      "display" : "Automated equipment test code settings request message",
      "definition" : "Automated equipment test code settings request message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1234",
      "code" : "TCU",
      "display" : "Automated equipment test code settings update message",
      "definition" : "Automated equipment test code settings update message",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "13"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "chapter",
          "valueString" : "13"
        }
      ]
    },
    {
      "id" : "1235",
      "code" : "UDM",
      "display" : "Unsolicited display update message",
      "definition" : "Unsolicited display update message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nicht angeforderte Nachricht im Anzeigeformat"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "5"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "chapter",
          "valueString" : "5"
        }
      ]
    },
    {
      "id" : "1211",
      "code" : "VQQ",
      "display" : "Virtual table query",
      "definition" : "Virtual table query",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1236",
      "code" : "VXQ",
      "display" : "Query for vaccination record",
      "definition" : "Query for vaccination record",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1237",
      "code" : "VXR",
      "display" : "Vaccination record response",
      "definition" : "Vaccination record response",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 - Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1238",
      "code" : "VXU",
      "display" : "Unsolicited vaccination record update",
      "definition" : "Unsolicited vaccination record update",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    },
    {
      "id" : "1239",
      "code" : "VXX",
      "display" : "Response for vaccination query with multiple PID matches",
      "definition" : "Response for vaccination query with multiple PID matches",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "4 -Deprecated"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "chapter",
          "valueString" : "4"
        }
      ]
    }
  ]
}

```
