# Identifier Type (2.9.1 - 1.7.0) - HL7 v2.9.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Identifier Type (2.9.1 - 1.7.0)**

## CodeSystem: Identifier Type (2.9.1 - 1.7.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/identifierType | *Version*:1.7.0 |
| Active as of 2026-01-25 | *Computable Name*:IdentifierType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.108 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messaging data types CX, PLN, PPN, XCN and XON. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSidentifierType](ValueSet-hl7VSidentifierType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "identifierType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0203"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/identifierType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.108"
    }
  ],
  "version" : "1.7.0",
  "name" : "IdentifierType",
  "title" : "Identifier Type (2.9.1 - 1.7.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-25T17:51:32+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messaging data types CX, PLN, PPN, XCN and XON.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "class",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#class",
      "description" : "class",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "1968",
      "code" : "AC",
      "display" : "Accreditation/Certification Identifier",
      "definition" : "Identifier that has been assigned by an accreditation or certification organization in specific fields, indicating a recognized skill",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "In Ask at Order Entry (AOE) questions this can be used to identify the ID with the assigning authority.  For instance, a credentialed sonographer whose identifier assigned by the credentialing body has been entered can be properly labeled."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "1969",
      "code" : "ACSN",
      "display" : "Accession ID",
      "definition" : "Accession Identifier",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "id" : "1970",
      "code" : "AIN",
      "display" : "Animal Identification Number (US Official)",
      "definition" : "A numbering system for the official identification of individual animals in the United States that provides a nationally unique identification number for each animal. The first two numbers on a tag are the numbers assigned to a specific State.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "AIN is the official acronym used by USDA"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "1971",
      "code" : "AM",
      "display" : "American Express",
      "definition" : "American Express",
      "designation" : [
        {
          "language" : "de",
          "value" : "American Express"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deprecated and replaced by BC in v 2.5."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1972",
      "code" : "AMA",
      "display" : "American Medical Association Number",
      "definition" : "A physician identifier assigned by the AMA.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "1973",
      "code" : "AN",
      "display" : "Account number",
      "definition" : "Account An identifier that is unique to an account.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Kontonummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1974",
      "code" : "ANC",
      "display" : "Account number Creditor",
      "definition" : "A more precise definition of an account number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Financial<p>Sometimes two distinct account numbers must be transmitted in the same message, one as the creditor, the other as the debitor.<p>Kreditorenkontonummer"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Financial"
        }
      ]
    },
    {
      "id" : "1975",
      "code" : "AND",
      "display" : "Account number debitor",
      "definition" : "A more precise definition of an account number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Financial<p>Sometimes two distinct account numbers must be transmitted in the same message, one as the creditor, the other as the debitor.<p>Debitorenkontonummer"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Financial"
        }
      ]
    },
    {
      "id" : "1976",
      "code" : "ANON",
      "display" : "Anonymous identifier",
      "definition" : "An identifier for a living subject whose real identity is protected or suppressed",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Justification: For public health reporting purposes, anonymous identifiers are occasionally used for protecting patient identity in reporting certain results. For instance, a state health department may choose to use a scheme for generating an anonymous identifier for reporting a patient that has had a positive human immunodeficiency virus antibody test. Anonymous identifiers can be used in PID 3 by replacing the medical record number or other non-anonymous identifier. The assigning authority for an anonymous identifier would be the state/local health department."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "1977",
      "code" : "ANT",
      "display" : "Temporary Account Number",
      "definition" : "Temporary version of an Account Number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Financial\r\nUse Case: An ancillary system that does not normally assign account numbers is the first time to register a patient. This ancillary system will generate a temporary account number that will only be used until an official account number is assigned."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Financial"
        }
      ]
    },
    {
      "id" : "1978",
      "code" : "APRN",
      "display" : "Advanced Practice Registered Nurse number",
      "definition" : "An identifier that is unique to an advanced practice registered nurse within the jurisdiction of a certifying board",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "1979",
      "code" : "ASID",
      "display" : "Ancestor Specimen ID",
      "definition" : "A unique identifier for the ancestor specimen.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "All child, grandchild, etc. specimens of the ancestor specimen share the same Ancestor Specimen ID."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "id" : "1980",
      "code" : "BA",
      "display" : "Bank Account Number",
      "definition" : "Bank Account Number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Financial"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "class",
          "valueCode" : "Financial"
        }
      ]
    },
    {
      "id" : "1981",
      "code" : "BC",
      "display" : "Bank Card Number",
      "definition" : "An identifier that is unique to a person's bank card",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Financial<p>Replaces AM, DI, DS, MS, and VS beginning in v 2.5."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Financial"
        }
      ]
    },
    {
      "id" : "1982",
      "code" : "BCFN",
      "display" : "Birth Certificate File Number",
      "definition" : "The identifier used within the jurisdictional vital records office file system as an auxiliary means of accessing the record associated with the birth certificate.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "1983",
      "code" : "BCT",
      "display" : "Birth Certificate",
      "definition" : "A number associated with a document identifying the event of a person's birth",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "1984",
      "code" : "BR",
      "display" : "Birth registry number",
      "definition" : "An identifier unique within the Assigning Authority that is the official legal record of a person's birth.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Geburtsregisternummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1985",
      "code" : "BRN",
      "display" : "Breed Registry Number",
      "definition" : "Breed Registry Number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "id" : "1986",
      "code" : "BSNR",
      "display" : "Primary physician office number",
      "definition" : "Primary physician office number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Betriebsstättennummer - for use in the German realm."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "id" : "1987",
      "code" : "CAAI",
      "display" : "Consumer Application Account Identifier",
      "definition" : "An identifier for the consumer (e.g., patient, caregiver) for an application such as a portal or App.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This may be the same as a username, but frequently is different."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "1988",
      "code" : "CC",
      "display" : "Cost Center number",
      "definition" : "Cost Center number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Financial<p>Use Case: needed especially for transmitting information about invoices."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Financial"
        }
      ]
    },
    {
      "id" : "1989",
      "code" : "CONM",
      "display" : "Change of Name Document",
      "definition" : "A number associated with a document identifying a person's legal change of name.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "1990",
      "code" : "CY",
      "display" : "County number",
      "definition" : "County number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "1991",
      "code" : "CZ",
      "display" : "Citizenship Card",
      "definition" : "A number assigned by a person's country of residence to identify a person's citizenship.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "1992",
      "code" : "DC",
      "display" : "Death Certificate ID",
      "definition" : "The identifier assigned to a death certificate, and printed on the death certificate when issued by a jurisdictional vital records office",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "1993",
      "code" : "DCFN",
      "display" : "Death Certificate File Number",
      "definition" : "The identifier used within the jurisdictional vital records office file system as an auxiliary means of accessing the record associated with the death certificate.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "1994",
      "code" : "DDS",
      "display" : "Dentist license number",
      "definition" : "An identifier that is unique to a dentist within the jurisdiction of the licensing board",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "1995",
      "code" : "DEA",
      "display" : "Drug Enforcement Administration registration number",
      "definition" : "An identifier for an individual or organization relative to controlled substance regulation and transactions.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Use case: This is a registration number that identifies an individual or organization relative to controlled substance regulation and transactions. \r\nA DEA number has a very precise and widely accepted meaning within the United States. Surprisingly, the US Drug Enforcement Administration does not solely assign DEA numbers in the United States. Hospitals have the authority to issue DEA numbers to their medical residents. These DEA numbers are based upon the hospital’s DEA number, but the authority rests with the hospital on the assignment to the residents. Thus, DEA as an Identifier Type is necessary in addition to DEA as an Assigning Authority."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "1996",
      "code" : "DFN",
      "display" : "Drug Furnishing or prescriptive authority Number",
      "definition" : "An identifier issued to a health care provider authorizing the person to write drug orders",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Use Case: A nurse practitioner has authorization to furnish or prescribe pharmaceutical substances; this identifier is in component 1."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "1997",
      "code" : "DI",
      "display" : "Diner's Club card",
      "definition" : "Diner's Club card",
      "designation" : [
        {
          "language" : "de",
          "value" : "Diners Club"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deprecated and replaced by BC in v 2.5."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1998",
      "code" : "DL",
      "display" : "Driver's license number",
      "definition" : "Driver's license number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Führerscheinnummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "1999",
      "code" : "DN",
      "display" : "Doctor number",
      "definition" : "Doctor number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Arztnummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2000",
      "code" : "DO",
      "display" : "Osteopathic License number",
      "definition" : "An identifier that is unique to an osteopath within the jurisdiction of a licensing board.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2001",
      "code" : "DP",
      "display" : "Diplomatic Passport",
      "definition" : "A number assigned to a diplomatic passport.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "2002",
      "code" : "DPM",
      "display" : "Podiatrist license number",
      "definition" : "An identifier that is unique to a podiatrist within the jurisdiction of the licensing board.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2003",
      "code" : "DR",
      "display" : "Donor Registration Number",
      "definition" : "Donor Registration Number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "id" : "2004",
      "code" : "DS",
      "display" : "Discover Card",
      "definition" : "Discover Card",
      "designation" : [
        {
          "language" : "de",
          "value" : "Discover Card"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deprecated and replaced by BC in v 2.5."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2005",
      "code" : "DSG",
      "display" : "Diagnostic Study Group",
      "definition" : "Unique Identifier that groups several orders that are to be performed together.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Example: Radiology studies"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2006",
      "code" : "EI",
      "display" : "Employee number",
      "definition" : "A number that uniquely identifies an employee to an employer.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Arbeitnehmernummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2007",
      "code" : "EN",
      "display" : "Employer number",
      "definition" : "Employer number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Arbeitgebernummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2008",
      "code" : "ESN",
      "display" : "Staff Enterprise Number",
      "definition" : "An identifier that is unique to a staff member within an enterprise (as identified by the Assigning Authority).",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "ETIN",
      "display" : "\tElectronic Transmitter Identification Number",
      "definition" : "A unique identifier usually assigned by a health plan or clearinghouse to an organization or provider that electronically transmits healthcare transactions, such as claims, eligibility inquiries, or remittance advices.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-29"
        }
      ]
    },
    {
      "id" : "2009",
      "code" : "FDR",
      "display" : "Fetal Death Report ID",
      "definition" : "The identifier assigned to a fetal death report, and printed on the fetal death report when issued by a jurisdictional vital records office",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2010",
      "code" : "FDRFN",
      "display" : "Fetal Death Report File Number",
      "definition" : "The identifier used within the jurisdictional vital records office file system as an auxiliary means of accessing the record associated with the fetal death report certificate.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2011",
      "code" : "FGN",
      "display" : "Filler Group Number",
      "definition" : "Unique identifier assigned to a group of orders by the filler application.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This is analogous to the Placer Group Number ORC-4, except that it is assigned by the filler."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2012",
      "code" : "FI",
      "display" : "Facility ID",
      "definition" : "Facility ID",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2013",
      "code" : "FILL",
      "display" : "Filler Identifier",
      "definition" : "An identifier for a request where the identifier is issued by the person, or service, that produces the observations or fulfills the request.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2014",
      "code" : "GI",
      "display" : "Guarantor internal identifier",
      "definition" : "Guarantor internal identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "interne ID des Zahlungspflichtigen"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Financial"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "class",
          "valueCode" : "Financial"
        }
      ]
    },
    {
      "id" : "2015",
      "code" : "GIN",
      "display" : "Animal Group Identifier (US Official)",
      "definition" : "Identifier that can be used to unambiguously describe a specific group of animals.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "GIN is the official acronym used by USDA"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2105",
      "code" : "GKV",
      "display" : "insured's ID with public insurance",
      "designation" : [
        {
          "language" : "de",
          "value" : "Gesetzliche Krankenversicherung"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        }
      ]
    },
    {
      "id" : "2016",
      "code" : "GL",
      "display" : "General ledger number",
      "definition" : "General ledger number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Financial"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Financial"
        }
      ]
    },
    {
      "id" : "2017",
      "code" : "GN",
      "display" : "Guarantor external  identifier",
      "definition" : "Guarantor external  identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "externe ID des Zahlungspflichtigen"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Financial"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "class",
          "valueCode" : "Financial"
        }
      ]
    },
    {
      "id" : "2018",
      "code" : "HC",
      "display" : "Health Card Number",
      "definition" : "Health Card Number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "id" : "2019",
      "code" : "IND",
      "display" : "Indigenous/Aboriginal",
      "definition" : "A number assigned to a member of an indigenous or aboriginal group outside of Canada.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "IRISTEM",
      "display" : "\tAn IRI stem",
      "definition" : "An IRI string that can be prepended to the code to obtain a concept IRI for RDF applications. This should be a valid, absolute IRI as defined in RFC 3987. See https://hl7.org/fhir/rdf.html#iri-stem for details on how this value may be used.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-29"
        }
      ]
    },
    {
      "id" : "2020",
      "code" : "JHN",
      "display" : "Jurisdictional health number",
      "definition" : "Jurisdictional health number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance<p>2 uses: a) UK jurisdictional CHI number; b) Canadian provincial health card number:"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2108",
      "code" : "KZVA",
      "display" : "dentist office number",
      "designation" : [
        {
          "language" : "de",
          "value" : "KZVAbrechnungsnummer"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        }
      ]
    },
    {
      "id" : "2021",
      "code" : "LACSN",
      "display" : "Laboratory Accession ID",
      "definition" : "A laboratory accession id is used in the laboratory domain.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The concept of accession is used in other domains such as radiology, so the LACSN is used to distinguish a lab accession id from an radiology accession id"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "id" : "2022",
      "code" : "LANR",
      "display" : "Lifelong physician number",
      "definition" : "Lifelong physician number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Lebenslange Arztnummer - for use in German realm."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "id" : "2023",
      "code" : "LI",
      "display" : "Labor and industries number",
      "definition" : "Labor and industries number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2024",
      "code" : "LN",
      "display" : "License number",
      "definition" : "License number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2025",
      "code" : "LR",
      "display" : "Local Registry ID",
      "definition" : "Local Registry ID",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2026",
      "code" : "MA",
      "display" : "Patient Medicaid number",
      "definition" : "Patient Medicaid number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Armennummer"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2027",
      "code" : "MB",
      "display" : "Member Number",
      "definition" : "An identifier for the insured of an insurance policy (this insured always has a subscriber), usually assigned by the insurance carrier.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Use Case: Person is covered by an insurance policy. This person may or may not be the subscriber of the policy."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2028",
      "code" : "MC",
      "display" : "Patient's Medicare number",
      "definition" : "Patient's Medicare number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Rentnernummer"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2029",
      "code" : "MCD",
      "display" : "Practitioner Medicaid number",
      "definition" : "Practitioner Medicaid number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2030",
      "code" : "MCN",
      "display" : "Microchip Number",
      "definition" : "Microchip Number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "id" : "2031",
      "code" : "MCR",
      "display" : "Practitioner Medicare number",
      "definition" : "Practitioner Medicare number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2032",
      "code" : "MCT",
      "display" : "Marriage Certificate",
      "definition" : "A number associated with a document identifying the event of a person's marriage.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "2033",
      "code" : "MD",
      "display" : "Medical License number",
      "definition" : "An identifier that is unique to a medical doctor within the jurisdiction of a licensing board.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Use Case: These license numbers are sometimes used as identifiers. In some states, the same authority issues all three identifiers, e.g., medical, osteopathic, and physician assistant licenses all issued by one state medical board. For this case, the CX data type requires distinct identifier types to accurately interpret component 1. Additionally, the distinction among these license types is critical in most health care settings (this is not to convey full licensing information, which requires a segment to support all related attributes)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2034",
      "code" : "MI",
      "display" : "Military ID number",
      "definition" : "A number assigned to an individual who has had military duty, but is not currently on active duty. The number is assigned by the DOD or Veterans' Affairs (VA).",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2035",
      "code" : "MR",
      "display" : "Medical record number",
      "definition" : "An identifier that is unique to a patient within a set of medical records, not necessarily unique within an application.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Krankenaktennummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2036",
      "code" : "MRT",
      "display" : "Temporary Medical Record Number",
      "definition" : "Temporary version of a Medical Record Number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Use Case: An ancillary system that does not normally assign medical record numbers is the first time to register a patient. This ancillary system will generate a temporary medical record number that will only be used until an official medical record number is assigned."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2037",
      "code" : "MS",
      "display" : "MasterCard",
      "definition" : "MasterCard",
      "designation" : [
        {
          "language" : "de",
          "value" : "MasterCard"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deprecated and replaced by BC in v 2.5."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2038",
      "code" : "NBSNR",
      "display" : "Secondary physician office number",
      "definition" : "Secondary physician office number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Nebenbetriebsstättennummer - for use in the German realm."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "id" : "2039",
      "code" : "NCT",
      "display" : "Naturalization Certificate",
      "definition" : "A number associated with a document identifying a person's retention of citizenship in a particular country.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "2040",
      "code" : "NE",
      "display" : "National employer identifier",
      "definition" : "National employer identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "In the US, the Assigning Authority for this value is typically CMS, but it may be used by all providers and insurance companies in HIPAA related transactions."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2041",
      "code" : "NH",
      "display" : "National Health Plan Identifier",
      "definition" : "National Health Plan Identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance\r\nUsed for the UK NHS national identifier."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2042",
      "code" : "NI",
      "display" : "National unique individual identifier",
      "definition" : "National unique individual identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance\r\nIn the US, the Assigning Authority for this value is typically CMS, but it may be used by all providers and insurance companies in HIPAA related transactions."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2043",
      "code" : "NII",
      "display" : "National Insurance Organization Identifier",
      "definition" : "National Insurance Organization Identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "Institutskennzeichen der Krankenkasse"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance\r\nIn Germany a national identifier for an insurance company. It is printed on the insurance card (health card). It is not to be confused with the health card number itself.<p>Krankenkassen-ID der KV-Karte"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2110",
      "code" : "NIIH",
      "display" : "National Insurance Headquarters Organization Identifier",
      "definition" : "National Insurance Headquarters Organization Identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "Institutskennzeichen des Krankenkassensitzes"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance\r\nIn Germany a national identifier for an insurance company. It is printed on the insurance card (health card). It is not to be confused with the health card number itself.<p>Krankenkassen-ID der KV-Karte"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-06-14"
        }
      ]
    },
    {
      "id" : "2044",
      "code" : "NIIP",
      "display" : "National Insurance Payor Identifier (Payor)",
      "definition" : "National Insurance Payor Identifier (Payor)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vertragskassennummer (VKNR)"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance\r\nIn Germany the insurance identifier addressed as the payor.<p>Krankenkassen-ID des Rechnungsempfängers<p>Use case: a subdivision issues the card with their identifier, but the main division is going to pay the invoices."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2045",
      "code" : "NNxxx",
      "display" : "National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) country code",
      "definition" : "National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) country code",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2046",
      "code" : "NP",
      "display" : "Nurse practitioner number",
      "definition" : "An identifier that is unique to a nurse practitioner within the jurisdiction of a certifying board.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2047",
      "code" : "NPI",
      "display" : "National provider identifier",
      "definition" : "National provider identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance\r\nIn the US, the Assigning Authority for this value is typically CMS, but it may be used by all providers and insurance companies in HIPAA related transactions."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2048",
      "code" : "OBI",
      "display" : "Observation Instance Identifier",
      "definition" : "Unique and persistent identifier for an observation instance",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "For example in the IHE-LCC Profile this is used to identify the OBX-21 of the result for which a clarification is requested using an OML^O59_OML_O59 message structure"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2049",
      "code" : "OD",
      "display" : "Optometrist license number",
      "definition" : "A number that is unique to an individual optometrist within the jurisdiction of the licensing board.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2050",
      "code" : "PA",
      "display" : "Physician Assistant number",
      "definition" : "An identifier that is unique to a physician assistant within the jurisdiction of a licensing board",
      "designation" : [
        {
          "language" : "de",
          "value" : "Assistenzarztnummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PAYERID",
      "display" : "Payer Identifier",
      "definition" : "A unique identifier, usually assigned by a health plan or clearinghouse, used in electronic healthcare transactions to designate the specific health insurance company or plan that is the recipient or sender of the transaction.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-29"
        }
      ]
    },
    {
      "id" : "2051",
      "code" : "PC",
      "display" : "Parole Card",
      "definition" : "A number identifying a person on parole.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "2052",
      "code" : "PCN",
      "display" : "Penitentiary/correctional institution Number",
      "definition" : "A number assigned to individual who is incarcerated.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2053",
      "code" : "PE",
      "display" : "Living Subject Enterprise Number",
      "definition" : "An identifier that is unique to a living subject within an enterprise (as identified by the Assigning Authority).",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2054",
      "code" : "PEN",
      "display" : "Pension Number",
      "definition" : "Pension Number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "id" : "2055",
      "code" : "PGN",
      "display" : "Placer Group Number",
      "definition" : "Unique identifier assigned to a group of orders by the placer application.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This is analogous to the Placer Group Number ORC-4."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2056",
      "code" : "PHC",
      "display" : "Public Health Case Identifier",
      "definition" : "Identifier assigned to a person during a case investigation as part of a public health event",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "For example every person affected by the Norovirus outbreak on a cruise ship will be assigned a case ID for investigation and follow up"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2057",
      "code" : "PHE",
      "display" : "Public Health Event Identifier",
      "definition" : "Identifier assigned to an event of interest to public health",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "For example an outbreak of Norovirus on a cruise ship – this is assigned by a public health jurisdiction at the local, state or federal level"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2058",
      "code" : "PHO",
      "display" : "Public Health Official ID",
      "definition" : "An identifier for a person working at a public health agency (PHA),  assigned or issued by the agency",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "May need to identify contact in a PHA that approved a test request or is in charge of an investigation."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2059",
      "code" : "PI",
      "display" : "Patient internal identifier",
      "definition" : "A number that is unique to a patient within an Assigning Authority.",
      "designation" : [
        {
          "language" : "de",
          "value" : "interne Patienten-ID"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2060",
      "code" : "PIN",
      "display" : "Premises Identifier Number (US Official)",
      "definition" : "Identifier that uniquely identifies a geographic location in the US.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The owner of the premises, or a person designated by the owner of the premises, can register his/her location. A premises identification number, or PIN, is then permanently assigned to that location associating it with the mailing address. If there is no mailing address at the property, geographic coordinates—latitude and longitude—can be used instead to describe the location.   A premises identification number (PIN) is a unique, 7-digit code that includes both letters and numbers. Example: A123R69"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2106",
      "code" : "PKV",
      "display" : "insured's ID with private insurance",
      "designation" : [
        {
          "language" : "de",
          "value" : "Private Krankenversicherung"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        }
      ]
    },
    {
      "id" : "2061",
      "code" : "PLAC",
      "display" : "Placer Identifier",
      "definition" : "An identifier for a request where the identifier is issued by the person or service making the request.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2062",
      "code" : "PN",
      "display" : "Person number",
      "definition" : "A number that is unique to a living subject within an Assigning Authority.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Personen-ID"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2063",
      "code" : "PNT",
      "display" : "Temporary Living Subject Number",
      "definition" : "Temporary version of a Living Subject Number.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2064",
      "code" : "PPIN",
      "display" : "Medicare/CMS Performing Provider Identification Number",
      "definition" : "Medicare/CMS Performing Provider Identification Number",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class:  Insurance"
        },
        {
          "code" : "usage",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "2065",
      "code" : "PPN",
      "display" : "Passport number",
      "definition" : "A unique number assigned to the document affirming that a person is a citizen of the country.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Passnummer"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "In the US this number is issued only by the State Department."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2066",
      "code" : "PRC",
      "display" : "Permanent Resident Card Number",
      "definition" : "Permanent Resident Card Number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2067",
      "code" : "PRN",
      "display" : "Provider number",
      "definition" : "A number that is unique to an individual provider, a provider group or an organization within an Assigning Authority.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Use case: This allows PRN to represent either an individual (a nurse) or a group/organization (orthopedic surgery team)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2068",
      "code" : "PT",
      "display" : "Patient external identifier",
      "definition" : "Patient external identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "externe Patienten-ID"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2069",
      "code" : "QA",
      "display" : "QA number",
      "definition" : "QA number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2070",
      "code" : "RI",
      "display" : "Resource identifier",
      "definition" : "A generalized resource identifier.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Use Case: An identifier type is needed to accommodate what are commonly known as resources. The resources can include human (e.g. a respiratory therapist), non-human (e.g., a companion animal), inanimate object (e.g., an exam room), organization (e.g., diabetic education class) or any other physical or logical entity."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2071",
      "code" : "RN",
      "display" : "Registered Nurse Number",
      "definition" : "An identifier that is unique to a registered nurse within the jurisdiction of the licensing board.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2072",
      "code" : "RPH",
      "display" : "Pharmacist license number",
      "definition" : "An identifier that is unique to a pharmacist within the jurisdiction of the licensing board.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2073",
      "code" : "RR",
      "display" : "Railroad Retirement number",
      "definition" : "An identifier for an individual enrolled with the Railroad Retirement Administration.  Analogous to, but distinct from, a Social Security Number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Seniorenkartennummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2074",
      "code" : "RRI",
      "display" : "Regional registry ID",
      "definition" : "Regional registry ID",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2075",
      "code" : "RRP",
      "display" : "Railroad Retirement Provider",
      "definition" : "Railroad Retirement Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class:  Insurance"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "2076",
      "code" : "SAMN",
      "display" : "SAMN# accession Number",
      "definition" : "The accession number for the BioSample data repository at the National Center for Biotechnology Information (NCBI)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This accession is a permanent record locator for the BioSample record which contains metadata about the biological sample."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2077",
      "code" : "SB",
      "display" : "Social Beneficiary Identifier",
      "definition" : "An identifier issued by a governmental organization to a person to identify the person should they apply for or receive social services and/or benefits",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2078",
      "code" : "SID",
      "display" : "Specimen ID",
      "definition" : "Identifier for a specimen.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Used when it is not known if the specimen ID is a unique specimen ID (USID) or an ancestor ID (ASID)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "id" : "2079",
      "code" : "SL",
      "display" : "State license",
      "definition" : "State license",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2080",
      "code" : "SN",
      "display" : "Subscriber Number",
      "definition" : "An identifier for a subscriber of an insurance policy which is unique for, and usually assigned by, the insurance carrier.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance\r\nUse Case: A person is the subscriber of an insurance policy. The person’s family may be plan members, but are not the subscriber."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2081",
      "code" : "SNBSN",
      "display" : "State assigned NDBS card Identifier",
      "definition" : "The identifier on a Newborn Screening Dried Bloodspot (NDBS) card that is assigned by the state which provided the sample collection cards and to whom this information must be reported",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "For use either with OBX-5 as CX datatype, where OBX-3 uses LOINC 57716-3^State printed on filter paper card [Identifier] in NBS card^LN, or in SPM-31"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2082",
      "code" : "SNO",
      "display" : "Serial Number",
      "definition" : "An identifier affixed to an item by the manufacturer when it is first made, where each item has a different identifier.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2083",
      "code" : "SP",
      "display" : "Study Permit",
      "definition" : "A number associated with a permit identifying a person who is a resident of a jurisdiction for the purpose of education.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "2084",
      "code" : "SR",
      "display" : "State registry ID",
      "definition" : "State registry ID",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2085",
      "code" : "SRX",
      "display" : "SRA Accession number",
      "definition" : "The accession number generated by the Sequence Read Archive (SRA) at the National Center for Biotechnology Information (NCBI) when sequence data are uploaded to NCBI.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This provides both the sequence data and metadata on how the sample was sequenced. – This accession is a permanent record locator for the submitted un-assembled sequence data."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2086",
      "code" : "SS",
      "display" : "Social Security number",
      "definition" : "Social Security number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sozialversicherungsnummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2087",
      "code" : "STN",
      "display" : "Shipment Tracking Number",
      "definition" : "Identifier assigned to a package being shipped",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "For example the Fed Ex / UPS / DHS / USPS tracking number"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2088",
      "code" : "TAX",
      "display" : "Tax ID number",
      "definition" : "Tax ID number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Steueridentifikationsnummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2089",
      "code" : "TN",
      "display" : "Treaty Number/ (Canada)",
      "definition" : "A number assigned to a member of an indigenous group in Canada.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Use Case: First Nation."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "id" : "2090",
      "code" : "TPR",
      "display" : "Temporary Permanent Resident (Canada)",
      "definition" : "A number associated with a document identifying a person's temporary permanent resident status.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "2091",
      "code" : "TRL",
      "display" : "Training License Number",
      "definition" : "The license number used during training.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2092",
      "code" : "U",
      "display" : "Unspecified identifier",
      "definition" : "Unspecified identifier",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "UCID",
      "display" : "Unique Claim Identifier",
      "definition" : "A unique identifier assigned by a payer for a claim received from a provider or subscriber.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-29"
        }
      ]
    },
    {
      "id" : "2093",
      "code" : "UDI",
      "display" : "Universal Device Identifier",
      "definition" : "An identifier assigned to a device using the Unique Device Identification framework as defined by IMDRF (http://imdrf.org). ",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2016-03-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2094",
      "code" : "UPIN",
      "display" : "Medicare/CMS (formerly HCFA)'s Universal Physician Identification numbers",
      "definition" : "An identifier for a provider within the CMS/Medicare program.  A globally unique identifier for the provider in the Medicare program.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "class",
          "valueCode" : "Insurance"
        }
      ]
    },
    {
      "id" : "2095",
      "code" : "USID",
      "display" : "Unique Specimen ID",
      "definition" : "A unique identifier for a specimen.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "id" : "2096",
      "code" : "VN",
      "display" : "Visit number",
      "definition" : "Visit number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Fallnummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2097",
      "code" : "VP",
      "display" : "Visitor Permit",
      "definition" : "A number associated with a document identifying a person as a visitor of a jurisdiction or country.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Besucherkennung"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "2098",
      "code" : "VS",
      "display" : "VISA",
      "definition" : "VISA",
      "designation" : [
        {
          "language" : "de",
          "value" : "VISA"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Deprecated and replaced by BC in v 2.5."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2099",
      "code" : "WC",
      "display" : "WIC identifier",
      "definition" : "WIC identifier",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "id" : "2100",
      "code" : "WCN",
      "display" : "Workers' Comp Number",
      "definition" : "Workers' Comp Number",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "id" : "2101",
      "code" : "WP",
      "display" : "Work Permit",
      "definition" : "A number associated with a permit for a person who is granted permission to work in a country for a specified time period.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "id" : "2102",
      "code" : "XV",
      "display" : "Health Plan Identifier",
      "definition" : "National unique health plan identifier required by the US Department of Health and Human Services, Centers for Medicare and Medicaid Services (CMS) in the US Realm.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Also referred to as HPID (Health Plan Identifier)."
        },
        {
          "code" : "usage",
          "valueString" : "The code value ‘XV’ is used in CMS mandated Health Insurance Portability and Accountability Act (HIPAA) transactions."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "id" : "2103",
      "code" : "XX",
      "display" : "Organization identifier",
      "definition" : "Organization identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "Organisations-ID"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "id" : "2107",
      "code" : "ZANR",
      "display" : "dentist identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zahnarztnummer"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        }
      ]
    }
  ]
}

```
