# Relationship Type (2.9 - 1.0.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Relationship Type (2.9 - 1.0.0)**

## CodeSystem: Relationship Type (2.9 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/v2CS-relationshipType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:V2CS-relationshipType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.448 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts that identify the type of relationship identified by Relationship Instance Identifier (REL-3) that is established between the Source Information Instance (REL-4) and the Target Information Instance (REL-5). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSrelationshipType](ValueSet-hl7VSrelationshipType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2CS-relationshipType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0948"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/v2CS-relationshipType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.448"
    }
  ],
  "version" : "1.0.0",
  "name" : "V2CS-relationshipType",
  "title" : "Relationship Type (2.9 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that identify the type of relationship identified by Relationship Instance Identifier (REL-3) that is established between the Source Information Instance (REL-4)  and the Target Information Instance (REL-5).",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CAUS",
      "display" : "Causes/caused",
      "definition" : "Source universal service identifier causes/caused the outcome(s) on the target",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Example: a procedure caused  complication(s)"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "COMP",
      "display" : "Component of",
      "definition" : "Target universal service identifier is a component of source universal identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Example: one care plan activity (target) is a component of another care plan activity (source)"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "CONCR",
      "display" : "Concurrently",
      "definition" : "Source and target universal service identifier should start concurrently",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Example: two care plan activities should start concurrently"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "EVID",
      "display" : "Evidence",
      "definition" : "Source universal service identifier provides evidence for target universal service identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Example: observation result provides evidence for certain care plan activity or treatment action"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "INTF",
      "display" : "Interferes / interfered",
      "definition" : "Source universal service identifier interferes / interfered with fulfilment of target universal service identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Example: patient financial or physical constraints interferes / interfered with fulfilment of goal"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "LIMIT",
      "display" : "Limits/limited",
      "definition" : "Source universal service identifier limits/limited the fulfillment of target universal service identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Example: patient condition limits the extend that planned treatment can be implemented"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "SUCCD",
      "display" : "Succeeds",
      "definition" : "Target universal service identifier should succeed (starts after end of) source universal service identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Example: one care plan activity (target) should start after completion of another (source)"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "SVTGT",
      "display" : "Service target",
      "definition" : "Target universal service identifier is the object of the service identified by the source universal service identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Example: An order requests clarification or interpretation of a previous clinical laboratory test result"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "TRIG",
      "display" : "Triggers/triggered",
      "definition" : "Source universal service identifier triggers action of target universal service identifier",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Example: a bleeding complication triggers the review and change in anti-coagulant dosage"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    }
  ]
}

```
