# Telecommunication Equipment Type (2.9 - 1.2.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Telecommunication Equipment Type (2.9 - 1.2.0)**

## CodeSystem: Telecommunication Equipment Type (2.9 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/telecommunicationEquipmentType | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:TelecommunicationEquipmentType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.107 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts for specifying a type of telecommunication equipment. Best practice is to use this concept whenever a telecommunication number or access string for particular equipment is specified. Used in HL7 Version 2.x messaging in the XTN segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VStelecommunicationEquipmentType](ValueSet-hl7VStelecommunicationEquipmentType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "telecommunicationEquipmentType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0202"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/telecommunicationEquipmentType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.107"
    }
  ],
  "version" : "1.2.0",
  "name" : "TelecommunicationEquipmentType",
  "title" : "Telecommunication Equipment Type (2.9 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts  for specifying a type of telecommunication equipment.  Best practice is to use this concept whenever a telecommunication number or access string for particular equipment is specified.  Used in HL7 Version 2.x messaging in the XTN segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "BP",
      "display" : "Beeper",
      "definition" : "Beeper",
      "designation" : [
        {
          "language" : "de",
          "value" : "Beeper/Pager"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CP",
      "display" : "Cellular or Mobile Phone",
      "definition" : "Cellular or Mobile Phone",
      "designation" : [
        {
          "language" : "de",
          "value" : "Mobiltelephon"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "FX",
      "display" : "Fax",
      "definition" : "Fax",
      "designation" : [
        {
          "language" : "de",
          "value" : "Fax"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "Internet",
      "display" : "Internet Address",
      "definition" : "Internet Address",
      "designation" : [
        {
          "language" : "de",
          "value" : "Internet"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MD",
      "display" : "Modem",
      "definition" : "Modem",
      "designation" : [
        {
          "language" : "de",
          "value" : "Modem"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PH",
      "display" : "Telephone",
      "definition" : "Telephone",
      "designation" : [
        {
          "language" : "de",
          "value" : "Telephon"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SAT",
      "display" : "Satellite Phone",
      "definition" : "Satellite Phone",
      "designation" : [
        {
          "language" : "de",
          "value" : "Satellitentelefon"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "TDD",
      "display" : "Telecommunications Device for the Deaf",
      "definition" : "Telecommunications Device for the Deaf",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TTY",
      "display" : "Teletypewriter",
      "definition" : "Teletypewriter",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "X.400",
      "display" : "X.400 email address",
      "definition" : "X.400 email address",
      "designation" : [
        {
          "language" : "de",
          "value" : "X.400-Nummer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
