# Sequence/Results Flag (2.9 - 1.0.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sequence/Results Flag (2.9 - 1.0.1)**

## CodeSystem: Sequence/Results Flag (2.9 - 1.0.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/sequenceResultsFlag | *Version*:1.0.1 |
| Active as of 2026-01-27 | *Computable Name*:SequenceResultsFlag |
| *Other Identifiers:*OID:2.16.840.1.113883.18.327 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to specify the sequencing relationship between the current service request and the related service request(s) specified in this TQ2 segment. Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSsequenceResultsFlag](ValueSet-hl7VSsequenceResultsFlag.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "sequenceResultsFlag",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0503"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/sequenceResultsFlag",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.327"
    }
  ],
  "version" : "1.0.1",
  "name" : "SequenceResultsFlag",
  "title" : "Sequence/Results Flag (2.9 - 1.0.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined  code system of concepts used to specify the sequencing relationship between the current service request and the related service request(s) specified in this TQ2 segment.  Used in the Timing/Quantity Relationship (TQ2) segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "C",
      "display" : "Cyclical",
      "definition" : "Cyclical",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Used for indicating a repeating cycle of service requests; for example, individual intravenous solutions used in a cyclical sequence (a.k.a. \"Alternating IVs\"). This value would be compatible with linking separate service requests or with having all cyclical service request components in a single service request. Likewise, the value would be compatible with either Parent-Child messages or a single service request message to communicate the service requests' sequencing"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Reserved for future use",
      "definition" : "Reserved for future use",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Sequential",
      "definition" : "Sequential",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
