# Reason for Study (2.9 - 1.0.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Reason for Study (2.9 - 1.0.0)**

## CodeSystem: Reason for Study (2.9 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/reasonForStudy | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ReasonForStudy |
| *Other Identifiers:*OID:2.16.840.1.113883.18.451 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts that provide additional information to the universal service identifier on why a test, study or review was ordered. Initial values are to support the IHE LCC LAB-7 transaction. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSReasonForStudy](ValueSet-hl7VSReasonForStudy.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "reasonForStudy",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0951"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/reasonForStudy",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.451"
    }
  ],
  "version" : "1.0.0",
  "name" : "ReasonForStudy",
  "title" : "Reason for Study (2.9 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that provide additional information to the universal service identifier on why a test, study or review was ordered. Initial values are to support the IHE LCC LAB-7 transaction.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "BS",
      "display" : "Bank residual specimen",
      "definition" : "Requests that the specimen should be stored long term",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "CR",
      "display" : "Confirm results value",
      "definition" : "Requests verification of previously reported results",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "FP",
      "display" : "Store residual specimen pending follow up",
      "definition" : "Requests that the specimen should be saved for a short duration until follow up is completed",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Provides instructions for Specimen storage"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "IN",
      "display" : "Interpret results",
      "definition" : "Requests interpretation of previously reported results",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "IR",
      "display" : "Review clinically inconsistent results",
      "definition" : "Requests comparison of previously reported results amongst themselves",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "IT",
      "display" : "Incorrect test performed",
      "definition" : "For process improvement work this code can be used to identify when an incorrect test was performed for the target order",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "OP",
      "display" : "Test ordering problem",
      "definition" : "For process improvement work this code can be used to identify orders and the respective results, where problems occurred during ordering",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "PI",
      "display" : "Patient identification problem",
      "definition" : "For process improvement work this code can be used to identify when a patient identification issue has occurred on the target order",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "SI",
      "display" : "Suspected interference",
      "definition" : "Requests verification of previously reported results due to suspected interference",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "SP",
      "display" : "Sampling problem",
      "definition" : "For process improvement work this code can be used to identify orders, where problems occurred during sample collection",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "TP",
      "display" : "Specimen transport problem",
      "definition" : "For process improvement work this code can be used to identify orders, where problems occurred during sample transport",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "TT",
      "display" : "Turnaround time problem",
      "definition" : "For process improvement work this code can be used to identify results with excessive reporting delay",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "XR",
      "display" : "Incorrect results",
      "definition" : "For process improvement work this code can be used to identify when incorrect result were reported for the target order",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used to indicate why review is requested"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    }
  ]
}

```
