# Provider Role (2.9 - 1.2.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Provider Role (2.9 - 1.2.1)**

## CodeSystem: Provider Role (2.9 - 1.2.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/providerRole | *Version*:1.2.1 |
| Active as of 2026-01-27 | *Computable Name*:ProviderRole |
| *Other Identifiers:*OID:2.16.840.1.113883.18.283 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.). Used in HL7 Version 2.x messaging in the ROL segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSproviderRole](ValueSet-hl7VSproviderRole.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "providerRole",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0443"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/providerRole",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.283"
    }
  ],
  "version" : "1.2.1",
  "name" : "ProviderRole",
  "title" : "Provider Role (2.9 - 1.2.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).  Used in HL7 Version 2.x messaging in the ROL segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AD",
      "display" : "Admitting",
      "definition" : "Admitting",
      "designation" : [
        {
          "language" : "de",
          "value" : "Aufnehmender Arzt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "PV1-17 Admitting doctor"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AI",
      "display" : "Assistant/Alternate Interpreter",
      "definition" : "Assistant/Alternate Interpreter",
      "designation" : [
        {
          "language" : "de",
          "value" : "alternativer (oder Assistent des) Befundsarzt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "AP",
      "display" : "Administering Provider",
      "definition" : "Administering Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "RXA-10 Administering Provider"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "AT",
      "display" : "Attending",
      "definition" : "Attending",
      "designation" : [
        {
          "language" : "de",
          "value" : "Behandelnder Arzt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "PV1-7 Attending doctor"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CLP",
      "display" : "Collecting Provider",
      "definition" : "Collecting Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "OBR-10 Collector Identifier"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CP",
      "display" : "Consulting Provider",
      "definition" : "Consulting Provider",
      "designation" : [
        {
          "language" : "de",
          "value" : "Beratender Arzt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DP",
      "display" : "Dispensing Provider",
      "definition" : "Dispensing Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "RXD-10 Dispensing Provider"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "EP",
      "display" : "Entering Provider (probably not the same as transcriptionist?)",
      "definition" : "Entering Provider (probably not the same as transcriptionist?)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "ORC-10 Entered By"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "FHCP",
      "display" : "Family Health Care Professional",
      "definition" : "Family Health Care Professional",
      "designation" : [
        {
          "language" : "de",
          "value" : "Hausarzt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IP",
      "display" : "Initiating Provider (as in action by)",
      "definition" : "Initiating Provider (as in action by)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "ORC-19 Action By"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "MDIR",
      "display" : "Medical Director",
      "definition" : "Medical Director",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "OBX-25 Performing Organization Medical Director"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "OP",
      "display" : "Ordering Provider",
      "definition" : "Ordering Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "ORC-12 Ordering Provider, OBR-16 Ordering Provider, RXO-14 Ordering Provider's DEA Number, RXE-13 Ordering Provider's DEA Number, ORC-24 Ordering Provider Address"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PH",
      "display" : "Pharmacist   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "definition" : "Pharmacist   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "RXE-14 Pharmacist/Treatment Supplier's Verifier ID"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PI",
      "display" : "Primary Interpreter",
      "definition" : "Primary Interpreter",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verantwortlicher Übersetzer"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "PP",
      "display" : "Primary Care Provider",
      "definition" : "Primary Care Provider",
      "designation" : [
        {
          "language" : "de",
          "value" : "Durchgangsarzt"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RO",
      "display" : "Responsible Observer",
      "definition" : "Responsible Observer",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "OBX-16 Responsible Observer"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "RP",
      "display" : "Referring Provider",
      "definition" : "Referring Provider",
      "designation" : [
        {
          "language" : "de",
          "value" : "überweisender/einweisender Arzt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "PV1-8 Referring doctor"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RT",
      "display" : "Referred to Provider",
      "definition" : "Referred to Provider",
      "designation" : [
        {
          "language" : "de",
          "value" : "Überweisungsempfänger"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "TN",
      "display" : "Technician",
      "definition" : "Technician",
      "designation" : [
        {
          "language" : "de",
          "value" : "MTA"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "TR",
      "display" : "Transcriptionist",
      "definition" : "Transcriptionist",
      "designation" : [
        {
          "language" : "de",
          "value" : "Schreibkraft"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.6"
        }
      ]
    },
    {
      "code" : "VP",
      "display" : "Verifying Provider",
      "definition" : "Verifying Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "ORC-11 Verified By"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "VPS",
      "display" : "Verifying Pharmaceutical Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "definition" : "Verifying Pharmaceutical Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "RXE-14 Pharmacist/Treatment Supplier's Verifier ID"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "VTS",
      "display" : "Verifying Treatment Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "definition" : "Verifying Treatment Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "RXE-14 Pharmacist/Treatment Supplier's Verifier ID"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    }
  ]
}

```
