# Pharmacy Order Types (2.9 - 1.0.1) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Pharmacy Order Types (2.9 - 1.0.1)**

## CodeSystem: Pharmacy Order Types (2.9 - 1.0.1) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/pharmacyOrderTypes | *Version*:1.0.1 |
| Active as of 2026-01-27 | *Computable Name*:PharmacyOrderTypes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.306 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the general category of pharmacy order which may be used to determine the processing path the order will take. Used in HL7 Version 2.x messaging in the RXO, RXE, RXD, RXG and RXA segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSpharmacyOrderTypes](ValueSet-hl7VSpharmacyOrderTypes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "pharmacyOrderTypes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0480"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/pharmacyOrderTypes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.306"
    }
  ],
  "version" : "1.0.1",
  "name" : "PharmacyOrderTypes",
  "title" : "Pharmacy Order Types (2.9 - 1.0.1)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the general category of pharmacy order which may be used to determine the processing path the order will take.  Used in HL7 Version 2.x messaging in the RXO, RXE, RXD, RXG and RXA segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "M",
      "display" : "Medication",
      "definition" : "Medication",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Default value.  Includes, but is not limited to, tables, capsules, powders, puffs, and other non-injected/non-infused products."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Other solution as medication orders",
      "definition" : "Other solution as medication orders",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Includes, but is not limited to, piggybacks and syringes"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "IV Large Volume Solutions",
      "definition" : "IV Large Volume Solutions",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Includes, but is not limited to, TPNs, admixtures, solutions and drips."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
