# Participation (2.9 - 1.3.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Participation (2.9 - 1.3.0)**

## CodeSystem: Participation (2.9 - 1.3.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/participation | *Version*:1.3.0 |
| Active as of 2026-01-27 | *Computable Name*:Participation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.420 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts that represent functional involvement of a caregiver or member of a care team with an activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.). Used in HL7 Version 2.x messaging in the PRT segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSparticipation](ValueSet-hl7VSparticipation.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "participation",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0912"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/participation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.420"
    }
  ],
  "version" : "1.3.0",
  "name" : "Participation",
  "title" : "Participation (2.9 - 1.3.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that represent functional involvement of a caregiver or member of a care team with an activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).  Used in HL7 Version 2.x messaging in the PRT segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AAP",
      "display" : "Alert Acknowledging Provider",
      "definition" : "Alert Acknowledging Provider",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "AC",
      "display" : "Administration Cosigner",
      "definition" : "Person that cosigned the prescription",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8"
        }
      ]
    },
    {
      "code" : "AD",
      "display" : "Admitting Provider",
      "definition" : "Admitting Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the PV1 segment, when more information about PV1-17 Admitting doctor is desired."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "AHP",
      "display" : "Authorized Performing Health Professional",
      "definition" : "The specific Health Professional who has been approved to perform the ordered services for the patient.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the AUT segment, which represents an authorization or a pre-authorization for a referred procedure or requested service by the payor covering the patient's health care.  This code is used when the authorization is for a person."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "AI",
      "display" : "Assistant/Alternate Interpreter",
      "definition" : "Assistant/Alternate Interpreter",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "AP",
      "display" : "Administering Provider",
      "definition" : "Administering Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the RXA segment, when more information about RXA-10 Administering Provider is desired."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "APO",
      "display" : "Authorized Performing Provider Organization",
      "definition" : "The Provider Organization that has been approved to perform the sanctioned procedures to which the patient was referred to.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the AUT segment, which represents an authorization or a pre-authorization for a referred procedure or requested service by the payor covering the patient's health care.  This code is used when the authorization is for an organization."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "ARI",
      "display" : "Assistant Result Interpreter",
      "definition" : "Assistant Result Interpreter",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the OBR segment, where OBR-33 Assistant Result Interpreter has been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "AT",
      "display" : "Attending Provider",
      "definition" : "Attending Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the PV1 segment, when more information about \r\n PV1-7 Attending doctor is desired."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "AUT",
      "display" : "Author/Event Initiator",
      "definition" : "Identifies the entity responsible for initiating the event",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the ORC segment, where ORC-19 Action By has been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "CLPO",
      "display" : "Collecting Provider Organization",
      "definition" : "The organization that is responsible for collecting the specimen.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the OBR segment, where OBR-10 Collector Identifier, when intended to convey the organization information, has been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "CP",
      "display" : "Consulting Provider",
      "definition" : "Consulting Provider",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "DIE",
      "display" : "De-Identification Entity",
      "definition" : "Organization, person or device that has the authority to remove a specimen identifier.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "DP",
      "display" : "Dispensing Provider",
      "definition" : "Dispensing Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the RXD segment, where RXD-10 Dispensing Provider has been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "EARI",
      "display" : "Expected Assistant Result Interpreter",
      "definition" : "The Assistant Result Interpreter who is expected to interpret the result (in the future).",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This will support filtering orders into the correct work queue of the Assistant Result Interpreter."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "ED",
      "display" : "Entering Device",
      "definition" : "Identifies the device that was used to enter the order into the system.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the ORC segment, where ORC-18 Entering Device has been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "EO",
      "display" : "Entering Organization",
      "definition" : "Identifies the organization that entered the order into the system.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the ORC segment, where ORC-17 Entering Organization has been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "EP",
      "display" : "Entering Person",
      "definition" : "Identifies the person that entered the order into the system",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Replaces ORC-10 Entered By"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "EPRI",
      "display" : "Expected Principal Result Interpreter",
      "definition" : "The Principal Result Interpreter who is expected to interpret the result (in the future).",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This will support filtering orders into the correct work queue of the Principal Result Interpreter."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "EQUIP",
      "display" : "Equipment",
      "definition" : "Equipment",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the OBX segment, where OBX-18 Equipment Instance Identifier has been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "FHCP",
      "display" : "Family Health Care Professional",
      "definition" : "Family Health Care Professional",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "FL",
      "display" : "From Location",
      "definition" : "Describes the location (coordinates) of the specimen/container in the previous holder / storage equipment before the move or the geographical location from which the specimen/container was moved.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "MDIR",
      "display" : "Medical Director",
      "definition" : "Medical Director",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "OF",
      "display" : "Ordering Facility",
      "definition" : "The facility from where the order was placed",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the ORC segment, where ORC-21 Ordering Facility Name, ORC-22 Ordering Facility Address and ORC-23 Ordering Facility Phone Number have been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "OP",
      "display" : "Ordering Provider",
      "definition" : "Ordering Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with either the ORC segment, where ORC-12 Ordering Provider, OBR-16 Ordering Provider, ORC-24 Ordering Provider Address have been marked for backwards compatibility only, or the OBR segment, where OBR-16 Ordering Provider has been marked for backwards compatibility only; the RXO segment, when more information about RXO-14 Ordering Provider's DEA Number is desired; the RXE segment, where RXE-13 Ordering Provider's DEA Number has been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "OPO",
      "display" : "Ordering Provider Organization",
      "definition" : "The organization the ordering provider is associated with.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This code is broader than Referring Provider Organization (RPO); it can be used for inter and intra-organizational orders."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "OS",
      "display" : "Outside Site(s) Where Observation May Be Performed",
      "definition" : "Outside Site(s) Where Observation May Be Performed",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the OM1 segment, where OM1-27 Outside Site(s) Where Observation May Be Performed has been deprecated."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.8.2"
        }
      ]
    },
    {
      "code" : "PB",
      "display" : "Packed by",
      "definition" : "Packed by",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PH",
      "display" : "Pharmacist",
      "definition" : "Identifies the person taking responsibility for the prescription dispense",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the RXE segment, where RXE-14 Pharmacist/Treatment Supplier's Verifier ID has been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PI",
      "display" : "Primary Interpreter",
      "definition" : "Primary Interpreter",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PO",
      "display" : "Performing Organization",
      "definition" : "Performing Organization",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "POMD",
      "display" : "Performing Organization Medical Director",
      "definition" : "Performing Organization Medical Director",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the OBX segment, where OBX-25 Performing Organization Medical Director has been marked for backwards compatibility only"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PP",
      "display" : "Primary Care Provider",
      "definition" : "Primary Care Provider",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "PPH",
      "display" : "Patient Preferred Pharmacy",
      "definition" : "Pharmacy the patient would prefer to use for any future medication orders.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "When a patient registers, this allows a system to indicate the default pharmacy to which the provider should send prescribed medication orders."
        },
        {
          "code" : "usage",
          "valueString" : "Most likely to be used in ADT messages for outpatient care."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "PRI",
      "display" : "Principal Result Interpreter",
      "definition" : "Identifies the person responsible for interpreting the results of the study/test",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the OBR segment, where OBR-32 Principal Result Interpreter has been marked for backwards compatibility only."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "RCT",
      "display" : "Results Copies To",
      "definition" : "Results Copies To",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "RHP",
      "display" : "Referring Health Professional",
      "definition" : "The Health Professional who refers the patient.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "RIE",
      "display" : "Re-Identification Entity",
      "definition" : "Organization, person or device that has the authority to assign a specimen identifier.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "RO",
      "display" : "Responsible Observer",
      "definition" : "Responsible Observer",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the OBX segment, where OBX-16 Responsible Observer has been marked for backwards compatibility only"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "RP",
      "display" : "Referring Provider",
      "definition" : "Referring Provider",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the PV1 segment, when more information about PV1-8 Referring doctor is desired."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "RPO",
      "display" : "Referring Provider Organization",
      "definition" : "The Provider Organization that refers the patient.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "RT",
      "display" : "Referred to Provider",
      "definition" : "Referred to Provider",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "SB",
      "display" : "Send by",
      "definition" : "Send by",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "SC",
      "display" : "Specimen Collector",
      "definition" : "The person that collected the specimen.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the OBR segment, where OBR-10 Collector Identifier, when intended to convey person information, has been marked for backwards compatibility only"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "TL",
      "display" : "To Location",
      "definition" : "Describes the location (coordinates) of the specimen/container in the previous holder / storage equipment after the move or the geographical location to which the specimen/container was moved.",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "TN",
      "display" : "Technician",
      "definition" : "Technician",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the OBR segment, where OBR-34 Technician has been marked for backwards compatibility only"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "TR",
      "display" : "Transcriptionist",
      "definition" : "Transcriptionist",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the OBR segment, where OBR-35 Transcriptionist has been marked for backwards compatibility only"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "VP",
      "display" : "Verifier (Verifying Person)",
      "definition" : "Identifies the person verifying the dispense / a step in the dispense process / verifying the treatment corresponds to the order",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This role is used in the PRT associated with the ORC segment, where Replaces ORC-11 Verified By has been marked for backwards compatibility only"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2019-03-14"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "VPS",
      "display" : "Verifying Pharmaceutical Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "definition" : "Verifying Pharmaceutical Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use of this code is deprecated; depending on the role of the person use either PH or VP."
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2016-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "VTS",
      "display" : "Verifying Treatment Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "definition" : "Verifying Treatment Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use of this code is deprecated; depending on the role of the person use either PH or VP."
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2016-07-23"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "WAY",
      "display" : "Waypoint",
      "definition" : "Waypoint",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "WAYR",
      "display" : "Waypoint Recipient",
      "definition" : "Waypoint Recipient",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    }
  ]
}

```
