# Order Control Code Reason (2.9 - 1.0.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Order Control Code Reason (2.9 - 1.0.0)**

## CodeSystem: Order Control Code Reason (2.9 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/orderControlCodeReason | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:OrderControlCodeReason |
| *Other Identifiers:*OID:2.16.840.1.113883.18.449 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts that describe reasons for the chosen order control codes. Used in HL7 Version 2 messaging in the ORC segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSorderControlCodeReason](ValueSet-hl7VSorderControlCodeReason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "orderControlCodeReason",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0949"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/orderControlCodeReason",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.449"
    }
  ],
  "version" : "1.0.0",
  "name" : "OrderControlCodeReason",
  "title" : "Order Control Code Reason (2.9 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that describe reasons for the chosen order control codes. Used in HL7 Version 2 messaging in the ORC segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CO",
      "display" : "Cost",
      "definition" : "Order changed based on cost",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "In an order replacement context, this would accompany proposal of a similar but lower cost order"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "ST",
      "display" : "Specimen Type",
      "definition" : "Incorrect specimen type submitted for the requested test",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Order placer may accept, cancel and replace, or choose other testing."
        },
        {
          "code" : "usage",
          "valueString" : "Recommend testing that can use the submitted specimen type"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "SV",
      "display" : "Specimen Volume",
      "definition" : "Provided specimen volume inadequate for testing",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "The question is how to use the available specimen. The Order Placer may choose a different subset of tests."
        },
        {
          "code" : "usage",
          "valueString" : "Recommend a subset of ordered tests appropriate for volume"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "UN",
      "display" : "Unavailable test",
      "definition" : "Requested test not available",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "In an order replacement context, an alternative might be proposed."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    }
  ]
}

```
