# Online Verification Result Error Code (2.9 - 1.0.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Online Verification Result Error Code (2.9 - 1.0.0)**

## CodeSystem: Online Verification Result Error Code (2.9 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/onlineVerificationResultErrorCodes | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:OnlineVerificationResultErrorCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.454 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code values representing a type of error from a failed operation to perform online verification of insurance data. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSonlineVerificationResultErrorCodes](ValueSet-hl7VSonlineVerificationResultErrorCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "onlineVerificationResultErrorCodes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0971"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/onlineVerificationResultErrorCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.454"
    }
  ],
  "version" : "1.0.0",
  "name" : "OnlineVerificationResultErrorCodes",
  "title" : "Online Verification Result Error Code (2.9 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code values representing a type of error from a failed operation to perform online verification of insurance data.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "1",
      "display" : "Update technically not possible",
      "definition" : "English: update of insurance date on card technically not possible\r\n\r\nGerman: Aktualisierung VSD auf eGK technisch nicht möglich",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "2",
      "display" : "Invalid Authentification certificate",
      "definition" : "English: authentication certificate is invalid\r\n\r\nGerman: Authentifizierungszertifikat eGK ungültig",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "3",
      "display" : "Online verification technically not possible",
      "definition" : "English: online verification of authentication certificate is technically not possible\r\n\r\nGerman: Onlineprüfung des Authentifizierungszerti-fikats technisch nicht möglich",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "4",
      "display" : "Update technically not possible due to offline time exceeded",
      "definition" : "English: update of insurance date is technically not possible due to maximum offline time exceeded\r\n\r\nGerman: Aktualisierung VSD auf eGK technisch nicht möglich weil maximaler Offline-Zeitraum überschritten",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    }
  ]
}

```
