# Message Error Condition Codes (2.9 - 1.2.0) - HL7 v2.9 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Message Error Condition Codes (2.9 - 1.2.0)**

## CodeSystem: Message Error Condition Codes (2.9 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/messageErrorCondition | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:MessageErrorCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.18.217 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the HL7 (communications) error code. Used in the ERR segment in HL7 Version 2.x messaging. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmessageErrorConditionCodes](ValueSet-hl7VSmessageErrorConditionCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "messageErrorCondition",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.9"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0357"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/messageErrorCondition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.217"
    }
  ],
  "version" : "1.2.0",
  "name" : "MessageErrorCondition",
  "title" : "Message Error Condition Codes (2.9 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:46:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the HL7 (communications) error code.  Used in the ERR segment in HL7 Version 2.x messaging.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "0",
      "display" : "Message accepted",
      "definition" : "Message accepted",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nachricht akzeptiert"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Success. Optional, as the AA conveys success. Used for systems that must always return a status code."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "100",
      "display" : "Segment sequence error",
      "definition" : "Segment sequence error",
      "designation" : [
        {
          "language" : "de",
          "value" : "Fehler in der Segmentreihenfolge"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Error: The message segments were not in the proper order, or required segments are missing."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "101",
      "display" : "Required field missing",
      "definition" : "Required field missing",
      "designation" : [
        {
          "language" : "de",
          "value" : "erforderliches Feld leer"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Error: A required field is missing from a segment"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "102",
      "display" : "Data type error",
      "definition" : "Data type error",
      "designation" : [
        {
          "language" : "de",
          "value" : "Datentypfehler"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Error: The field contained data of the wrong data type, e.g., an NM field contained \"FOO\"."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "103",
      "display" : "Table value not found",
      "definition" : "Table value not found",
      "designation" : [
        {
          "language" : "de",
          "value" : "fehlender Eintrag in der Tabelle"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Error: A field of data type ID or IS was compared against the corresponding table, and no match was found."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "104",
      "display" : "Value too long",
      "definition" : "Value too long",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Error: a value exceeded the normative length, or the length that the application is able to safely handle."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.7"
        }
      ]
    },
    {
      "code" : "198",
      "display" : "Non-Conformant Cardinality",
      "definition" : "An error has been encountered related to HL7 message content. Message is not -conformant with the applicable specification’s (base standard, conformance profile or implementation profile)  cardinality.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Error: Cardinality is listed as [0..3] and more than 3 of the identified element are present in the message."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "199",
      "display" : "Other HL7 Error",
      "definition" : "Any other error with the HL7 syntax that is not captured in any of the other error codes in this set.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Error"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2022-08-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.9"
        }
      ]
    },
    {
      "code" : "200",
      "display" : "Unsupported message type",
      "definition" : "Unsupported message type",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nachrichtentyp wird nicht unterstützt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Rejection: The Message Type is not supported."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "201",
      "display" : "Unsupported event code",
      "definition" : "Unsupported event code",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ereignis wird nicht unterstützt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Rejection: The Event Code is not supported."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "202",
      "display" : "Unsupported processing id",
      "definition" : "Unsupported processing id",
      "designation" : [
        {
          "language" : "de",
          "value" : "Processing-ID wird nicht unterstützt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Rejection: The Processing ID is not supported."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "203",
      "display" : "Unsupported version id",
      "definition" : "Unsupported version id",
      "designation" : [
        {
          "language" : "de",
          "value" : "Version wird nicht unterstützt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Rejection:  The Version ID is not supported."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-07-13"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "204",
      "display" : "Unknown key identifier",
      "definition" : "Retained for backwards compatibility only: This situation should be reported in ERR-5 (Application Error Code) using code 101 (Unknown Key Identifier) from code system HL70533.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Schlüsselwert nicht gefunden"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "ERR-3 (HL7 Error Code) should be used to convey errors at the structural level and this is an application level error, which should be reported in ERR-5 (Application Error Code)."
        },
        {
          "code" : "status",
          "valueCode" : "backward"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2017-07-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "205",
      "display" : "Duplicate key identifier",
      "definition" : "Retained for backwards compatibility only: This situation should be reported in ERR-5 (Application Error Code) using code 102 (Duplicate Key Identifier) from code system HL70533.",
      "designation" : [
        {
          "language" : "de",
          "value" : "doppelter Schlüsselwert"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "ERR-3 (HL7 Error Code) should be used to convey errors at the structural level and this is an application level error, which should be reported in ERR-5 (Application Error Code)."
        },
        {
          "code" : "status",
          "valueCode" : "backward"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2017-07-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "206",
      "display" : "Application record locked",
      "definition" : "Retained for backwards compatibility only: This situation should be reported in ERR-5 (Application Error Code) using code 103 (Application record locked) from code system HL70533.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Datensatz durch Applikation gesperrt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "ERR-3 (HL7 Error Code) should be used to convey errors at the structural level and this is an application level error, which should be reported in ERR-5 (Application Error Code)."
        },
        {
          "code" : "status",
          "valueCode" : "backward"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2017-07-16"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "207",
      "display" : "Application error",
      "definition" : "An application level error has occurred and the detail for that error is identified in ERR-5.",
      "designation" : [
        {
          "language" : "de",
          "value" : "applikationsinterner Fehler"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This value is used when no other value in this list is applicable and there is an application error reported in ERR-5. It is applicable when ERR-3 is required in an implementation guide."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2017-07-25"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
